/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_VorbisSoundProvider class.
 */

#include "clandefs.h"
#include "RB_ClanRuby.h"

#include "RB_VorbisSoundProvider.h"

/*
 * Ruby class.
 */
static VALUE classVorbisSoundProvider;


/*
 * Free the ClanLib object, used by the garbage collector.
 */
static void freeVorbisSoundProvider( CL_VorbisSoundProvider *s)
{
	printf( "deleting sample\n" );
	delete s;
}

/*
 * Return a Ruby object which wraps the given clanlib object.
 */
VALUE wrapVorbisSoundProvider( CL_VorbisSoundProvider *s )
{
	return Data_Wrap_Struct(classVorbisSoundProvider, 0, freeVorbisSoundProvider, s);
}

/*
 * Ruby constructor.
 */
static VALUE vorbis_new(VALUE self, VALUE file)
{
	printf( "ClanRuby vorbis support is experimental!!\n" );
	char *id = STR2CSTR(file);
	
	printf( "id = %s\n", id );
	
	CL_VorbisSoundProvider *s = new CL_VorbisSoundProvider( id, NULL, false);
	
	return wrapVorbisSoundProvider(s);
}

/*
 * Initialize the ruby class.
 */
void initVorbisSoundProvider()
{
	
	classVorbisSoundProvider= rb_define_class_under(
			mClanRuby,
			"VorbisSoundProvider",
			rb_cObject);

	
	rb_define_singleton_method(
		classVorbisSoundProvider, 
		"new",
		(VALFP)vorbis_new, 
		1);
		
}
