/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_SoundBufferSession class.
 */

#include "clandefs.h"
#include "RB_ClanRuby.h"



/*
 * Ruby class.
 */
static VALUE cSoundBufferSession;


/*
 * Free the ClanLib object, used by the garbage collector.
 */
static void freeSoundBufferSession( CL_SoundBuffer_Session* s)
{
	//delete s;

}

/*
 * Return a Ruby object which wraps the given clanlib object.
 */
VALUE wrapSoundBufferSession( CL_SoundBuffer_Session* s )
{
	return Data_Wrap_Struct(cSoundBufferSession, 0, freeSoundBufferSession, s);
}


/*
 * Return true if the session is still playing.
 */
VALUE soundBufferSession_isPlaying(VALUE self)
{

	CL_SoundBuffer_Session *session; 
	Data_Get_Struct( self, CL_SoundBuffer_Session, session);	
	
	if ( session->is_playing() )
		return Qtrue;
	else
		return Qfalse;
}

/*
 * Return true if the session is still playing.
 */
VALUE soundBufferSession_play(VALUE self)
{

	CL_SoundBuffer_Session *session; 
	Data_Get_Struct( self, CL_SoundBuffer_Session, session);	
	
	session->play();
	
	return Qnil;
}

/*
 * Initialize the ruby class.
 */
void initSoundBufferSession()
{
	cSoundBufferSession=
		rb_define_class_under(
			mClanRuby,
			"SoundBufferSession",
			rb_cObject);


			
	rb_define_method(
		cSoundBufferSession,
		"isPlaying",
		(VALFP)soundBufferSession_isPlaying,
		0);
		
			
	rb_define_method(
		cSoundBufferSession,
		"play",
		(VALFP)soundBufferSession_play,
		0);
				
}
