/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_SoundBuffer class.
 */

#include "clandefs.h"
#include "RB_ClanRuby.h"

#include "RB_SoundBufferSession.h"
#include "RB_Sample.h"
#include "RB_VorbisSoundProvider.h"



/*
 * Ruby class.
 */
static VALUE cSoundBuffer;


/*
 * Free the ClanLib object, used by the garbage collector.
 */
static void freeSoundBuffer( CL_SoundBuffer *s)
{
	//printf( "NOT deleting sound buffer \n" );
	delete s;
}

/*
 * Return a Ruby object which wraps the given clanlib object.
 */
VALUE wrapSoundBuffer( CL_SoundBuffer *s )
{
	return Data_Wrap_Struct(cSoundBuffer, 0, freeSoundBuffer, s);
}

/*
 * Create from a static sample
 */
static VALUE soundBuffer_fromStaticProvider(VALUE self, VALUE vSample)
{
	printf( "sound buffer new: enter\n" );
	
	CL_StaticSoundProvider *sample; 
	Data_Get_Struct( vSample, CL_StaticSoundProvider, sample);
	
	CL_SoundBuffer *s = new CL_SoundBuffer( sample, false);
		
	VALUE ret = wrapSoundBuffer(s);
	rb_iv_set( ret, "@sample", vSample );
	
	return ret;
}

/*
 * Create from a stream
 */
static VALUE soundBuffer_fromStreamProvider(VALUE self, VALUE vSample)
{
	printf( "sound buffer new: enter\n" );
	
	CL_StreamSoundProvider *sample; 
	Data_Get_Struct( vSample, CL_StreamSoundProvider, sample);
	
	CL_SoundBuffer *s = new CL_SoundBuffer( sample, false);
		
	VALUE ret = wrapSoundBuffer(s);
	rb_iv_set( ret, "@sample", vSample );
	
	return ret;
}

static VALUE soundBuffer_play(VALUE self )
{
	
	CL_SoundBuffer *buf; 
	Data_Get_Struct( self, CL_SoundBuffer, buf);
	
	CL_SoundBuffer_Session* sess = new CL_SoundBuffer_Session();
	*sess = buf->play();
	
	return wrapSoundBufferSession(sess);
	
	
}

/**
static VALUE soundBuffer_isPlaying(VALUE self )
{
	
	CL_SoundBuffer *buf; 
	Data_Get_Struct( self, CL_SoundBuffer, buf);
	
	if ( buf->is_playing() )
		return Qtrue;
	else
		return Qfalse;
	
}
*/


/*
 * Initialize the ruby class.
 */
void initSoundBuffer()
{
	cSoundBuffer=
		rb_define_class_under(mClanRuby,"SoundBuffer",	rb_cObject);

	
	rb_define_singleton_method( cSoundBuffer, "createFromStatic",
		(VALFP)soundBuffer_fromStaticProvider, 1);
	
	rb_define_singleton_method( cSoundBuffer, "createFromStream",
		(VALFP)soundBuffer_fromStreamProvider, 1);

	rb_define_method( cSoundBuffer, "play", (VALFP)soundBuffer_play, 0);

/**
	rb_define_method(
		cSoundBuffer, 
		"isPlaying",
		(VALFP)soundBuffer_isPlaying, 
		0);
**/
		
}
