/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_SetupDisplay class. Just some static
 * initializers.
 */

#include "clandefs.h"
#include "RB_ClanRuby.h"


static VALUE setupDisplay_init()
{
	CL_SetupDisplay::init();
	return Qnil;
}

static VALUE setupDisplay_deInit()
{
	CL_SetupDisplay::deinit();
	return Qnil;
}


void initSetupDisplay()
{
	VALUE classSetupDisplay=
		rb_define_class_under(
			mClanRuby,
			"SetupDisplay",
			rb_cObject);

	
	rb_define_singleton_method(
		classSetupDisplay, 
		"init", 
		(VALFP)setupDisplay_init, 
		0);
		
	rb_define_singleton_method(
		classSetupDisplay, 
		"deinit", 
		(VALFP)setupDisplay_deInit, 
		0);

}
