/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_Mouse class.
 */
#include "clandefs.h"
#include "RB_ClanRuby.h"


VALUE classMouse;

/*
 * Input slots for mouse stuff.
 */
static CL_Slot mouseMoveSlot;

/*
 * Ruby method to call when a mouse is moved
 */
static VALUE mouseHandler = Qnil;


/*
 * Clanlib function which is called when a button is pressed,
 * in turn calls the associated ruby button press method if there
 * is one.
 */
static void onMouseMove(int x, int y)
{ 
	printf( "onMouseMove\n" );
	
	VALUE vX = INT2NUM(x);	
	VALUE vY = INT2NUM(y);
	ID callID = rb_intern("call");

	rb_funcall( mouseHandler, callID, 2, vX, vY );
}

/*
 * Ruby methods to get current mouse location.
 */
static VALUE getX(VALUE self)
{
	return INT2NUM(CL_Mouse::get_x() );
}


static VALUE getY(VALUE self)
{
	return INT2NUM(CL_Mouse::get_y() );
}


/*
 * Ruby method to set the object which handles the button press.
 */
static void setMouseHandler(VALUE self, VALUE vHandler)
{
	
	printf( "set mouse handler\n" );
	
	if( mouseHandler != Qnil )
	{
		printf( "disconnecting\n" );
		CL_Mouse::sig_move.disconnect(mouseMoveSlot);
	}
	
	if ( vHandler != Qnil )
	{
		printf( "connecting\n" );
		mouseMoveSlot = CL_Mouse::sig_move.connect(onMouseMove);
	}
	
	mouseHandler = vHandler;
}

/*
 * Initialize this class.
 */
void initMouse()
{
	classMouse = rb_define_class_under(mClanRuby, "Mouse", rb_cObject);
	
	rb_define_singleton_method( 
		classMouse, "mouseHandler=", (VALFP)setMouseHandler, 1);		


	rb_define_singleton_method(classMouse, "x", (VALFP)getX, 0);
		
	rb_define_singleton_method(classMouse, "y", (VALFP)getY, 0);
}
