/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_Keyboard class.
 */
#include "clandefs.h"
#include "RB_ClanRuby.h"

/*
 * Return true if the given key is pressed. See RB_Input for the
 * constants to use for buttonNumber.
 */
static VALUE keyboard_getKeycode(VALUE self, VALUE vButtonNumber)
{
	int buttonNumber = NUM2INT(vButtonNumber);

	bool flag =  CL_Keyboard::get_keycode(buttonNumber);

	return flag ? Qtrue : Qfalse;	
	
}

/*
 * Initialize this class.
 */
void initKeyBoard()
{
	VALUE classKeyBoard=rb_define_class_under(
		mClanRuby, 
		"KeyBoard", 
		rb_cObject);


	rb_define_singleton_method(
		classKeyBoard,
		"getKeycode", 
		(VALFP)keyboard_getKeycode,
		1);
		

}
