/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the ruby wrapper for the CL_JPEGProvider class.
 */
#include "clandefs.h"
#include <ClanLib/jpeg.h>

#include "RB_ClanRuby.h"
#include "RB_Surface.h"

/*
 * Create a JPEG provider object. Takes the name of a JPEG file.
 */
static VALUE JPEGprovider_create(VALUE self, VALUE vFileName)
{
	char* fileName = STR2CSTR(vFileName);

	CL_Surface *surface = CL_JPEGProvider::create(fileName, NULL);
	
	// TBD free filename ?
	
	VALUE ret = wrapSurface(surface);
	
	return ret;
}

/*
 * Initialize this class.
 */
void initJPEGProvider()
{
	
	VALUE classJPEGProvider=rb_define_class_under(
		mClanRuby, 
		"JPEGProvider", 
		rb_cObject);


	rb_define_singleton_method(
		classJPEGProvider, 
		"create", 
		(VALFP)JPEGprovider_create,
		1);
}
