/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Define all the ruby related stuff, including the global clanruby module.
 */

#ifndef __rb_clanruby_h__
#define __rb_clanruby_h__

/*
 * Include the ruby main include.
 */

extern "C" {
#include "ruby.h"
}


/*
 * Function to initialize the clan ruby module.
 */
extern void initClanRuby();

/*
 * Global ruby module used by all the clanruby classes.
 */
extern VALUE mClanRuby;

/*
 * Class of all exceptions thrown by ClanRuby.
 */
extern VALUE classClanLibException;

/*
 * Pointer to a function which returns a value.
 */
typedef VALUE (*VALFP)(...);

/*
 * Macro to define a ruby constant
 */
#define RB_INT_CONST(_module, _name, _value) \
	rb_define_const(_module,_name,INT2NUM(_value))


#endif

