/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This is the actual definition of the clanlib module global.
 */
 
#include "clandefs.h"
#include "RB_ClanRuby.h"
#include <ClanLib/application.h>

/*
 * Every ClanLib program needs to define a CL_ClanApplication object. 
 * Apparently, the CL_ClanApplication constructor sets an internal
 * global reference to the application, so if you don't have one
 * ClanLib blows up.
 */
class MyApp  : public CL_ClanApplication
{
	public:
        	virtual char *get_title()
        	{
                	return "ClanLib 2D API example";
        	}

		virtual int main( int argc, char **argv)
		{
		}
};

/*
 * Global pointer clanlib application object.
 */
MyApp *myapp;

/*
 * Global ruby clanlib module.
 */
VALUE mClanRuby;

/*
 * Global ruby exception class.
 */
VALUE classClanLibException;

/*
 * Initialize the basic ruby objects used by clanruby.
 */
void initClanRuby()
{
	printf( "initClanLib\n" );
	// Before we do anything, create an instance of the
	// Application class. This keeps ClanLib from blowing up.

	myapp = new MyApp();
	
	// The central clanlib module.
	
	mClanRuby=rb_define_module("ClanRuby");
	
	// And a class for our exceptions.
	
	classClanLibException =
		rb_define_class("ClanLibException", rb_eStandardError);
	
}
