/*
    ClanRuby, A set of Ruby bindings for ClanLib

    Copyright (C) 2002 Russell Olsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "clandefs.h"
#include "RB_ClanRuby.h"
#include "RB_System.h"
#include "RB_SetupCore.h"
#include "RB_SetupSound.h"
#include "RB_SetupDisplay.h"
#include "RB_Sample.h"
#include "RB_SoundBuffer.h"
#include "RB_SoundBufferSession.h"
#include "RB_VorbisSoundProvider.h"
#include "RB_Display.h"
#include "RB_Surface.h"
#include "RB_KeyBoard.h"
#include "RB_PNGProvider.h"
#include "RB_JPEGProvider.h"
#include "RB_Rect.h"
#include "RB_ClipRect.h"
#include "RB_Input.h"
#include "RB_Mouse.h"
#include "RB_MouseHandler.h"

/*
 * This is the function called by the ruby interpreter
 * to initialize the ClanRuby extension. We simply call
 * the various init functions to define all the ClanRuby
 * classes, constants, etc. 
 */
extern "C" void Init_ClanRuby()
{
	printf( "init clan ruby\n" );
	initClanRuby();
	initSetupCore();
	initSystem();
	initSetupDisplay();
	initSetupSound();
	initVorbisSoundProvider();
	initSample();
	initSoundBuffer();
	initSoundBufferSession();
	initKeyBoard();
	initDisplay();
	initSurface();
	initPNGProvider();
	initJPEGProvider();
	initRect();
	initClipRect();
	initInput();
 	initMouse();
	initMouseHandler();
}

