"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#transition functions

import pygame, os, gfx, math, parameters, gameobjects
from pygame.locals import *

import nodedata
from nodedata import *

import cursors
from cursors import *


overRide = 0
overRideType = None
noTrans = 0
transitionTypes = {
    'leftscroll': lambda: leftscroll(),
    'rightscroll': lambda: rightscroll(),
    'upscroll': lambda: upscroll(),
    'downscroll': lambda: downscroll(),
    'fade': lambda: fade_maybe(),
    None: lambda: blink(),
    'None': lambda: blink(),
    'none': lambda: blink()
    }
transitionAliases = {
    'None': None,
    'none': None
    }

def blink():
    pygame.display.update(gfx.slideRect)

def fade_maybe():
    if not parameters.DEFAULT_TRANSITION == 'FASTEST':
        fade()
    else:
        blink()


def call():
    global overRide, noTrans

    if noTrans:
        blink()
        noTrans = 0
    elif gameobjects.inobjects: fade_maybe()
    elif overRide and parameters.DEFAULT_TRANSITION != None and not noTrans:
        if transitionTypes.has_key(overRideType): transitionTypes[overRideType]()
        else:
            print "Pyzzle internal error -- transition.py, id 677"
            gfx.quittest = 1
        overRide = 0
        
    elif parameters.DEFAULT_TRANSITION != None and not noTrans :
        if (nodedata.cursor == cursors.fwdcursor or nodedata.cursor == cursors.zipcursor) and parameters.DEFAULT_TRANSITION != 'FASTEST': fade()
        elif nodedata.cursor == cursors.leftcursor or nodedata.cursor == cursors.left180cursor: leftscroll()
        elif nodedata.cursor == cursors.rightcursor or nodedata.cursor == cursors.right180cursor: rightscroll()
        elif nodedata.cursor == cursors.downcursor: downscroll()
        elif nodedata.cursor == cursors.upcursor: upscroll()
        else: blink()
    else: blink()
    
def override():
    global overRide, overRideType 
    overRide = 1
   
    #print nodedata.cursorZone
    nptoncz = nodedata.previousslide.transition_override[nodedata.cursorZone]
    if transitionAliases.has_key(nptoncz): nptoncz = transitionAliases[nptoncz]
    if transitionTypes.has_key(nptoncz): overRideType = nptoncz
    else:
        print 'Pyzzle Error invalid transition type: '+`nptoncz`
        gfx.quittest = 1
                                                                 
def notrans():
    global noTrans
    noTrans = 1
    
def fade():
    
    fade_velocity = get_fade_velocity()
    delay = get_delay()
    tmpSurface = pygame.Surface(gfx.slideRect.size)
    tmpSurface.blit(gfx.surface,(0,0),gfx.slideRect )
    tmpSurface.set_alpha(0)
    gfx.surface.blit(gfx.oldslideSurface, gfx.slideRect.topleft)
    gfx.surface.blit(tmpSurface, gfx.slideRect.topleft)   
    pygame.display.update(gfx.slideRect)
    
    for i in range(1,255,fade_velocity):
        
        tmpSurface.set_alpha(i)

        gfx.surface.blit(tmpSurface, gfx.slideRect.topleft)   
        pygame.display.update(gfx.slideRect)
        pygame.time.delay(delay)
            
    tmpSurface.set_alpha(255)

    gfx.surface.blit(tmpSurface, gfx.slideRect.topleft)   
    pygame.display.update(gfx.slideRect)

def leftscroll():
    scroll_velocity = get_scroll_velocity()
    delay = get_delay()
    tmp1surface = pygame.Surface(gfx.slideRect.size)
    tmp2surface = pygame.Surface(gfx.slideRect.size)
    
    tmp1surface.blit(gfx.surface,(0,0), gfx.slideRect)
    tmp2surface.blit(gfx.oldslideSurface,(0,0))

    #gfx.surface.blit(tmp2surface, gfx.slideRect.topleft)
    #pygame.display.update(gfx.slideRect)
   
    for i in range(0, gfx.slideRect.width+1,scroll_velocity): 
        gfx.surface.blit(tmp2surface, ( gfx.slideRect.left+i, gfx.slideRect.top),(0,0,gfx.slideRect.width-i,gfx.slideRect.height))
        gfx.surface.blit(tmp1surface, ( gfx.slideRect.left, gfx.slideRect.top), ( gfx.slideRect.width -
                                                                                 i, 0, gfx.slideRect.left+i, gfx.slideRect.height ))
        pygame.display.update(gfx.slideRect)                
        pygame.time.delay(delay)
        
    gfx.surface.blit(tmp1surface, gfx.slideRect.topleft)
    pygame.display.update(gfx.slideRect)
    


def rightscroll():
    scroll_velocity = get_scroll_velocity()
    delay = get_delay()
    
    twoRect = Rect(0, 0, gfx.slideRect.width * 2, gfx.slideRect.height)
    tmpSurface = pygame.Surface(twoRect.size)
    
    tmpSurface.blit(gfx.surface,(gfx.slideRect.width,0), gfx.slideRect)
    tmpSurface.blit(gfx.oldslideSurface,(0,0))

    for i in range(0,gfx.slideRect.width+1,scroll_velocity):    
        gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(i,0,gfx.slideRect.width,gfx.slideRect.height))
        pygame.display.update(gfx.slideRect)
        pygame.time.delay(delay)

    gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(gfx.slideRect.width,0,gfx.slideRect.width,gfx.slideRect.height))
    pygame.display.update(gfx.slideRect)

def downscroll():
    scroll_velocity = get_scroll_velocity()
    delay = get_delay()
    
    twoRect = Rect(0, 0, gfx.slideRect.width, gfx.slideRect.height * 2)
    tmpSurface = pygame.Surface(twoRect.size) 

    tmpSurface.blit(gfx.oldslideSurface,(0,0))
    tmpSurface.blit(gfx.surface,(0,gfx.slideRect.height),gfx.slideRect)

    for i in range(0,gfx.slideRect.height+1,scroll_velocity):    
        gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(0,i,gfx.slideRect.width,gfx.slideRect.height))
        pygame.display.update(gfx.slideRect)
        pygame.time.delay(delay)
        
    gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(0,gfx.slideRect.height,gfx.slideRect.width,gfx.slideRect.height))
    pygame.display.update(gfx.slideRect)

def upscroll():
    scroll_velocity = get_scroll_velocity()
    delay = get_delay()
    
    twoRect = Rect(0, 0, gfx.slideRect.width, gfx.slideRect.height * 2)
    tmpSurface = pygame.Surface(twoRect.size) 

    tmpSurface.blit(gfx.surface,(0,0),gfx.slideRect)
    tmpSurface.blit(gfx.oldslideSurface,(0,gfx.slideRect.height))

    for i in range(0,gfx.slideRect.height+1,scroll_velocity):    
        gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(0,gfx.slideRect.height-i,gfx.slideRect.width,gfx.slideRect.height))
        pygame.display.update(gfx.slideRect)
        pygame.time.delay(delay)
        
    gfx.surface.blit(tmpSurface, gfx.slideRect.topleft,(0,0,gfx.slideRect.width,gfx.slideRect.height))
    pygame.display.update(gfx.slideRect)

def get_fade_velocity():
    
    if parameters.DEFAULT_TRANSITION == 'BEST':
        return parameters.FADE_VELOCITY_BEST
    elif parameters.DEFAULT_TRANSITION == 'NORMAL':
        return parameters.FADE_VELOCITY_NORMAL
    else:
        return parameters.FADE_VELOCITY_BEST
    

def get_scroll_velocity():
    
    if parameters.DEFAULT_TRANSITION == 'BEST':
        return parameters.SCROLL_VELOCITY_BEST
    elif parameters.DEFAULT_TRANSITION == 'NORMAL':
        return parameters.SCROLL_VELOCITY_NORMAL
    elif parameters.DEFAULT_TRANSITION == 'FASTEST':
        return parameters.SCROLL_VELOCITY_FASTEST

def get_delay():
    
    if  parameters.DEFAULT_TRANSITION == 'BEST':
        return parameters.DELAY_BEST
    elif  parameters.DEFAULT_TRANSITION == 'NORMAL':
        return parameters.DELAY_NORMAL
    elif parameters.DEFAULT_TRANSITION == 'FASTEST':
        return parameters.DELAY_FASTEST
    else: return parameters.DELAY_BEST
   
