"""
Copyright 2001 - 2002  Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#image functions

import pygame, pygame.font, textrect, gfx, os, sys, paths
from pygame.locals import *

import nodedata, parameters, constants
from constants import *

#sys.path.insert(0, os.path.join('data','text'))

#class text:
#    pass


def display(currentView):
    rectarray = []
    for i in currentView.text:
        
        file = i.fontFile
        
        fontType =  os.path.join(paths.current_text_path, file)

        my_font = pygame.font.Font(fontType, i.size)
        
        my_rect = pygame.Rect(i.rect)
        my_rect.left = my_rect.left + parameters.viewRect.left
        my_rect.top = my_rect.top + parameters.viewRect.top
        rendered_text = textrect.render_textrect(i.textstring, my_font, my_rect, i.color, i.justification)

        if rendered_text:
            gfx.surface.blit(rendered_text, my_rect.topleft)
        rectarray.append(my_rect)
    #pygame.display.update(rectarray)
        
