"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""


mixer = music = None

import pygame, os
from pygame.locals import *

import nodedata, paths
from nodedata import *

STARTUP_AMBIENT = None
STARTUP_VOLUME = 1.0

SAMPLES = 22000

def initialize():
    global mixer, music
    
    try:
        import pygame.mixer as pymix
        pymix.init(SAMPLES, 8, 0)
        mixer = pymix
        music = pymix.music
        return 1
    except (ImportError, pygame.error):
        return 0

def test():
    if pygame.mixer and not pygame.mixer.get_init():
        pygame.mixer = None
    if not pygame.mixer:
        print 'Warning, sound disabled'

def play(a_sound, loop = 0):
    if not pygame.mixer: return    
    global Asound#, currentSound
    if loop != 0:
        currentSound = Asound
    else:
        currentSound = None
    soundfile = os.path.join(paths.current_sound_path, a_sound)
    Asound = pygame.mixer.Sound(soundfile)
    chan = Asound.play(loop)
    if not chan:
            chan = pygame.mixer.find_channel(1)
            chan.play(Asound)
        
def stop():
    global Asound#, currentSound
    Asound.stop()
    #currentSound = None
    

def playambient(amb, vol = 1.0):
    global currentAmbient, music
    
    if not music: return
    if music.get_busy():
        music.stop()
    currentAmbient = amb
    file = os.path.join(paths.current_sound_path, amb)
    music.load(file)
    
    music.play(-1)
    music.set_volume(vol)
  
def stopambient():
    if not pygame.mixer: return
    #global currnetAmbient
    
    music.stop()
    #currentAmbient = None
    
def setambientvol(vol = 1.0):
    global music
    if not music: return
    if vol == None:
        return
    else:
        music.set_volume(vol)

def getambientvol():
    if not pygame.mixer: return
    if currentAmbient == None:
        return None
    else:
        return music.get_volume()

