"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""
import pygame
from pygame.locals import *
#game parameters
FULL_SCREEN = 0     
TESTINGFULL = 1 
VERSION = "0.8"
SCREENSIZE = (800,600)
screenRect = Rect(0,0,SCREENSIZE[0],SCREENSIZE[1])
DISPLAYCAPTION = 'Pyzzle: Orbius Tertius.' 
DEFAULTTRANSITION = None
RESOLUTION = 24 

BACKGROUNDCOLOUR = 0, 0, 0

SLIDESIZE = (640,480)
resolution = RESOLUTION
viewRect = Rect(0, 0, SLIDESIZE[0], SLIDESIZE[1])
viewRect.center = screenRect.center #viewRect is currently setup for the slides to go in the center of the screen

MENUBUTTONDISPLAYDEPTH = 15   
MENUBUTTONPOS = 80, 1
MOVIEMAINLOOPS = 6 
TURNMAPDEPTH = 60
OBJECT_IMAGE_SPACE = 10

#The max with/height of an object
OBJECTMAXSIZE = 40
OBJECT_ARRAY_SHOW_ALPHA = 150 #0-255 object array show alpha amount (transpatert amout), 255 for completely opaque.
OBJECT_ARRAY_HIDE_ALPHA = 0 #0-255 object array hide alpha amount (transpatert amout), 0 for completely transparent.

#----------------------------------------------------------

MENUBUTTONRECT = (0,0,SCREENSIZE[0], MENUBUTTONDISPLAYDEPTH)

OBJECT_RECT = Rect(viewRect.left,viewRect.bottom+10,viewRect.width,OBJECTMAXSIZE)
OBJECT_MOUSEOVER_RECT = Rect(0,viewRect.bottom,screenRect.width ,screenRect.height-viewRect.height )


DISABLE_ZIPMODE = 0

ZIPMODE = 0
#----Transition Parameters--------------------
DEFAULT_TRANSITION = None #can be None, 'BEST', 'FASTEST', 'NORMAL'

SCROLL_VELOCITY_BEST = 30
SCROLL_VELOCITY_NORMAL = 40
SCROLL_VELOCITY_FASTEST = 50

FADE_VELOCITY_BEST = 20
FADE_VELOCITY_NORMAL = 50

DELAY_BEST = 0
DELAY_NORMAL = 0
DELAY_FASTEST = 0


#----Cursor parameters--------------------------------

fwdalphapix      = (1,1)
fistalphapix     = (1,1)
grabalphapix     = (1,1)
leftalphapix     = (1,1)
rightalphapix    = (1,1)
right180alphapix = (1,1)
left180alphapix  = (1,1)
upalphapix       = (1,1)
downalphapix     = (1,1)
zipalphapix      = (3,1)
arrowalphapix    = (1,1)

# Cursor hotspots

fwdhotspot      = (7,2)
arrowhotspot    = (3,2)
fisthotspot     = (7,7)
grabhotspot     = (7,7)
lefthotspot     = (1,5)
left180hotspot  = (1,5)
righthotspot    = (15,5)
right180hotspot = (15,5)
uphotspot       = (10,1)
downhotspot     = (5,15)
ziphotspot      = (7,7)

def setScreenSize(size):
    global SCREENSIZE
    SCREENSIZE = size

def getScreenSize():
    global SCREENSIZE
    return SCREENSIZE

def setSlideSize(size):
    global SLIDESIZE
    SLIDESIZE = size

def getSlideSize():
    global SLIDESIZE
    return SLIDESIZE

def setResolution(resolution = 24):
    global RESOLUTION
    RESOLUTION = resolution

def getResolution():
    global RESOLUTION
    return RESOLUTION 

def setBackgroundColor(color):
    global BACKGROUNDCOLOUR
    BACKGROUNDCOLOUR = color

def getBackgroundColor():
    global BACKGROUNDCOLOUR
    return BACKGROUNDCOLOUR

def setFullScreen(fullscreen = 1):
    global FULL_SCREEN
    if fullscreen:
        FULL_SCREEN = 1
    else:
        FULL_SCREEN = 0

def isFullScreen():
    global FULL_SCREEN
    return FULL_SCREEN

def setTestMode(testmode = 0):
    global TESTINGFULL 
    if testmode:
        TESTINGFULL  = 1
    else:
        TESTINGFULL = 0

def isTestMode():
    global TESTINGFULL
    return TESTINGFULL 

def setDefaultTransition(transition = 'BEST'):
    global DEFAULT_TRANSITION
    DEFAULT_TRANSITION = transition


def getDefaultTransition():
    global DEFAULT_TRANSITION
    return DEFAULT_TRANSITION
    
def setObjectArrayAlpha(low, high):
    global OBJECT_ARRAY_SHOW_ALPHA, OBJECT_ARRAY_HIDE_ALPHA
    OBJECT_ARRAY_SHOW_ALPHA = high
    OBJECT_ARRAY_HIDE_ALPHA = low

def getObjectArrayAlpha(low, high):
    global OBJECT_ARRAY_SHOW_ALPHA, OBJECT_ARRAY_HIDE_ALPHA
    return OBJECT_ARRAY_SHOW_ALPHA, OBJECT_ARRAY_HIDE_ALPHA 

def disableZipMode():
    global DISABLE_ZIPMODE
    DISABLE_ZIPMODE = 0

def isZipModeDisable():
    global DISABLE_ZIPMODE
    return DISABLE_ZIPMODE

def setZipMode(zipmode = 0):
    global ZIPMODE
    ZIPMODE = zipmode

def getZipMode():
    global ZIPMODE
    return ZIPMODE

