"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#movie functions

import pygame, os, gfx, pygame.movie, cursors, nodedata, paths, gameobjects
from pygame.locals import *

import nodedata, parameters

triggerfn = None

def initialize():
    global mov, movsurface, movrect, movcursor,position,load
    mov = None
    tmpsurface = None
    movrect = None
    movcursor = 1
    isloop = 0
    position = 0
    load = 0
    
def play(pos, loops, movcur = 0):
    global mov, movsurface, movrect, tmpmovsurface, movcursor,isloop,position
    gameobjects.moviepos = pos
    position = pos
    isloop = loops
    movcursor = movcur
    currentView = nodedata.currentslide
    file = os.path.join(paths.current_movie_path, currentView.moviefile[pos])
    mov = pygame.movie.Movie(file)
    size = mov.get_size()
    movrect = Rect(0,0,0,0)
    movrect.left = currentView.moviepos[pos][0] + parameters.viewRect.left
    movrect.top = currentView.moviepos[pos][1] + parameters.viewRect.top
    movrect.size = size
    movsurface = pygame.Surface(size)
    tmpmovsurface = pygame.Surface(size)
    tmpmovsurface.blit(gfx.surface, (0,0),movrect)
    mov.set_display(movsurface)
    mov.play(loops)

def play_trigger(pos, trigfn, movcur = 0):
    global mov, movsurface, movrect, tmpmovsurface, movcursor,isloop,position, triggerfn
    loops = 0
    triggerfn = trigfn
    gameobjects.moviepos = pos
    position = pos
    isloop = loops
    movcursor = movcur
    currentView = nodedata.currentslide
    file = os.path.join(paths.current_movie_path, currentView.moviefile[pos])
    mov = pygame.movie.Movie(file)
    size = mov.get_size()
    movrect = Rect(0,0,0,0)
    movrect.left = currentView.moviepos[pos][0] + parameters.viewRect.left
    movrect.top = currentView.moviepos[pos][1] + parameters.viewRect.top
    movrect.size = size
    movsurface = pygame.Surface(size)
    tmpmovsurface = pygame.Surface(size)
    tmpmovsurface.blit(gfx.surface, (0,0),movrect)
    mov.set_display(movsurface)
    mov.play(0)
    


def play_image(pos, imagefile, offset, movcur = 0):
    global mov, movsurface, movrect, tmpmovsurface, movcursor,isloop
    gameobjects.moviepos = pos
    isloop = 0
    if offset == None:
        offset = (0,0)
    movcursor = movcur
    currentView = nodedata.currentslide
    file = os.path.join(paths.current_movie_path, currentView.moviefile[pos])
    mov = pygame.movie.Movie(file)
    size = mov.get_size()
    movrect = Rect(0,0,0,0)
    movrect.left = currentView.moviepos[pos][0] + parameters.viewRect.left
    movrect.top = currentView.moviepos[pos][1] + parameters.viewRect.top
    movrect.size = size
    imagebitmap  = gfx.load(imagefile)
    movsurface = pygame.Surface(size)
    tmpmovsurface = pygame.Surface(size)
    tmpmovsurface.blit(gfx.surface, (0,0),movrect)
    tmpmovsurface.blit(imagebitmap, offset)
    mov.set_display(movsurface)
    mov.play(0)
