"""
    Copyright 2001-2002 Andrew Jones
    
    This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""
import pygame, os
from pygame.locals import *

import parameters
from parameters import *
import constants
from constants import *

import gfx, menurects, nodedata

buttonNo = 0
menuDisplay = []
def menu(visible,menuType):
         
    menurect = getMenuType(menuType)
    menucolour = getMenuColour(menuType)
    if visible:
        

        menuSurface = pygame.Surface(menurect.size)
        tempSurface = pygame.Surface(menurect.size)

        tempSurface.blit(gfx.surface, (0,0), menurect)
        
        
        menuSurface.fill(menucolour)
        if MENUALPHA < 255:
            menuSurface.set_alpha(MENUALPHA,0)
        gfx.surface.blit(menuSurface, menurect)
        menurects.add(displayItem('X.png',(menurect.width - 20, 2), ALPHA_X, menurect),'closemenu')
        
        fillMenu(menuType, menuSurface, menurect)

        gfx.surfacestorage.append(tempSurface)
        gfx.surfacerectstorage.append(menurect)
                                  
        pygame.display.update(menurect)
    else:
        
        gfx.surface.blit(gfx.surfacestorage.pop(),menurect.topleft)
        pygame.display.update(gfx.surfacerectstorage.pop())
    
def display(menuFunction):
    global buttonNo
    
    if menuFunction == 'showmain':
        menu(1, 'main')
        menuDisplay.append('main')
        return 'main'
    elif menuFunction == 'showquit':
        menu(1, 'quit')
        menuDisplay.append('quit')
        return 'quit'
    elif menuFunction == 'showsave':
        menu(1, 'save')
        menuDisplay.append('save')
        return 'save'
    elif menuFunction == 'showload':
        menu(1, 'load')
        menuDisplay.append('load')
        return 'load'
    elif menuFunction == 'showoptions':
        menu(1, 'options')
        menuDisplay.append('options')
        return 'options'
    elif menuFunction == 'showpromptsave':
        menu(1, 'promptsave')
        menuDisplay.append('promptsave')
        return 'promptsave'
    elif menuFunction == 'showpromptload':
        menu(1, 'promptload')
        menuDisplay.append('promptload')
        return 'promptload'

    elif menuFunction == 'closemenu':
        if menurects.menuButtonNo != []:
            menurects.clear(menurects.menuButtonNo.pop())
        gfx.clearRadio()
        menu(0, menuDisplay[len(menuDisplay)-1])
        menuDisplay.pop()
        if menuDisplay == []:
            return None
        else:
            return menuDisplay[len(menuDisplay)-1]
        

def displayItem(file, position, alphapos,  menuRect):
    file = os.path.join('pyzzledata','menudata',file)
    bitmap = gfx.load(file)
    bitmap.set_colorkey(bitmap.get_at(alphapos))
    bitmaprect = bitmap.get_rect()
    bitmaprect.topleft = menuRect.left + position[0], menuRect.top + position[1]
    gfx.surface.blit(bitmap, bitmaprect)
    return bitmaprect

def radioButton(position,slected, menuRect):

    if slected:
        file = os.path.join('pyzzledata','menudata', 'checkbox_yes.png')
        radioBitmap = gfx.load(file)
        radioBitmap.set_colorkey(radioBitmap.get_at(RADIO_ON_ALPHA))
    else:
        file = os.path.join('pyzzledata','menudata', 'checkbox_no.png')
        radioBitmap = gfx.load(file)
        radioBitmap.set_colorkey(radioBitmap.get_at(RADIO_OFF_ALPHA))
        
    radioBitmaprect = radioBitmap.get_rect()
    radioBitmaprect.topleft = menuRect.left + position[0], menuRect.top + position[1]
    
    tmpSurface = pygame.Surface(radioBitmaprect.size)
    tmpSurface.blit(gfx.surface, (0,0), radioBitmaprect)
    gfx.radiosurfacestorage.append(tmpSurface)
    gfx.radiorectstorage.append(radioBitmaprect)
    gfx.surface.blit(radioBitmap, radioBitmaprect)
    return radioBitmaprect

def checkBox(position,slected, menuRect):
    if slected:
        file = os.path.join('pyzzledata','menudata', 'checkbox_yes.png')
        radioBitmap = gfx.load(file)
        radioBitmap.set_colorkey(radioBitmap.get_at(RADIO_ON_ALPHA))
    else:
        file = os.path.join('pyzzledata','menudata', 'checkbox_no.png')
        radioBitmap = gfx.load(file)
        radioBitmap.set_colorkey(radioBitmap.get_at(RADIO_OFF_ALPHA))
        
    radioBitmaprect = radioBitmap.get_rect()
    radioBitmaprect.topleft = menuRect.left + position[0], menuRect.top + position[1]
    
    tmpSurface = pygame.Surface(radioBitmaprect.size)
    tmpSurface.blit(gfx.surface, (0,0), radioBitmaprect)
    gfx.checkboxsurfacestorage.append(tmpSurface)
    gfx.checkboxrectstorage.append(radioBitmaprect)
    gfx.surface.blit(radioBitmap, radioBitmaprect)
    return radioBitmaprect

def changeRadioButton(button):
    gfx.surface.blit(gfx.radiosurfacestorage[0],gfx.radiorectstorage[0].topleft)
    gfx.surface.blit(gfx.radiosurfacestorage[1],gfx.radiorectstorage[1].topleft)
    gfx.surface.blit(gfx.radiosurfacestorage[2],gfx.radiorectstorage[2].topleft)
    gfx.surface.blit(gfx.radiosurfacestorage[3],gfx.radiorectstorage[3].topleft)
    
    file = os.path.join('pyzzledata','menudata', 'checkbox_no.png')
    bitmap = gfx.load(file)
    bitmap.set_colorkey(bitmap.get_at(RADIO_OFF_ALPHA)) 

    gfx.surface.blit(bitmap, gfx.radiorectstorage[0].topleft)
    gfx.surface.blit(bitmap, gfx.radiorectstorage[1].topleft)
    gfx.surface.blit(bitmap, gfx.radiorectstorage[2].topleft)
    gfx.surface.blit(bitmap, gfx.radiorectstorage[3].topleft)
    
    file = os.path.join('pyzzledata','menudata', 'checkbox_yes.png')
    bitmapyes = gfx.load(file)
    bitmapyes.set_colorkey(bitmap.get_at(RADIO_ON_ALPHA))
    
    if button == 'None':
        gfx.surface.blit(bitmapyes, gfx.radiorectstorage[0].topleft)
    elif button == 'FASTEST':
        gfx.surface.blit(bitmapyes, gfx.radiorectstorage[1].topleft)
    if button == 'NORMAL':
        gfx.surface.blit(bitmapyes, gfx.radiorectstorage[2].topleft)
    if button == 'BEST':
        gfx.surface.blit(bitmapyes, gfx.radiorectstorage[3].topleft)
                               
    pygame.display.update(gfx.radiorectstorage)


def changeCheckBoxButton(button):
    
    gfx.surface.blit(gfx.checkboxsurfacestorage[0],gfx.checkboxrectstorage[0].topleft)
    
    file = os.path.join('pyzzledata','menudata', 'checkbox_no.png')
    bitmap = gfx.load(file)
    bitmap.set_colorkey(bitmap.get_at(RADIO_OFF_ALPHA)) 

    gfx.surface.blit(bitmap, gfx.checkboxrectstorage[0].topleft)
        
    file = os.path.join('pyzzledata','menudata', 'checkbox_yes.png')
    bitmapyes = gfx.load(file)
    bitmapyes.set_colorkey(bitmap.get_at(RADIO_ON_ALPHA))
    
    if parameters.ZIPMODE:
        gfx.surface.blit(bitmapyes, gfx.checkboxrectstorage[0].topleft)
    
                               
    pygame.display.update(gfx.checkboxrectstorage)
    
        

def changeRadio(type):
    if type == 'None':
        changeRadioButton('None')
        parameters.DEFAULT_TRANSITION = None
    elif type == 'FASTEST':
        changeRadioButton('FASTEST')
        parameters.DEFAULT_TRANSITION = 'FASTEST'
    elif type == 'NORMAL':
        changeRadioButton('NORMAL')
        parameters.DEFAULT_TRANSITION = 'NORMAL'
    elif type == 'BEST':
        changeRadioButton('BEST')
        parameters.DEFAULT_TRANSITION = 'BEST'
    elif type == 'ZIP':
        parameters.ZIPMODE = not parameters.ZIPMODE
        changeCheckBoxButton('ZIP')
    

def getMenuType(menuType):
    if menuType == 'main':
        return MAINMENURECT
    elif menuType == 'quit':
        return QUITMENURECT
    elif menuType == 'save':
        return SAVEMENURECT
    elif menuType == 'load':
        return LOADMENURECT
    elif menuType == 'options':
        return OPTIONSMENURECT
    elif menuType == 'promptsave':
        return PROMPTMENURECT
    elif menuType == 'promptload':
        return PROMPTMENURECT
    
    
def getMenuColour(menuType):
    if menuType == 'main':
        return MAINMENUCOLOUR
    elif menuType == 'quit':
        return QUITMENUCOLOUR
    elif menuType == 'save':
        return SAVEMENUCOLOUR
    elif menuType == 'load':
        return LOADMENUCOLOUR
    elif menuType == 'options':
        return OPTIONSMENUCOLOUR
    elif menuType == 'promptsave':
        return PROMPTMENUCOLOUR
    elif menuType == 'promptload':
        return PROMPTMENUCOLOUR
    

def fillMenu(menutype, menusurface, menuRect):
    global buttonNo
    if menutype == 'main':
        menurects.add(displayItem('loadbutton.png', MENU_LOAD_BUTTONPOS, (0,0),  menuRect), 'showload')
        menurects.add(displayItem('savebutton.png', MENU_SAVE_BUTTONPOS, (0,0),  menuRect), 'showsave')
        menurects.add(displayItem('optionsbutton.png', MENU_OPTIONS_BUTTONPOS, (0,0),  menuRect), 'showoptions')
        menurects.add(displayItem('quitbutton.png', MENU_QUIT_BUTTONPOS, (0,0),  menuRect), 'showquit')
        menutext(TOPMENUTEXT, TOPMENUTEXTPOS, TOPMENUSIZE, MENUHEADFONT, menuRect)
        menutext(MENUSPEEL_1, MENUSPEEL_1POS, MENUSPEELSIZE, SPEELFONT , menuRect)
        menutext(MENUSPEEL_2, MENUSPEEL_2POS, MENUSPEELSIZE, SPEELFONT, menuRect)
        menutext(MENUSPEEL_3, MENUSPEEL_3POS, MENUSPEELSIZE, SPEELFONT, menuRect)
        menurects.menuButtonNo.append(5)
    elif menutype == 'quit':
        menurects.add(displayItem('yesbutton.png', YES_BUTTON_POS, (0,0),  menuRect), 'quitgame')
        menurects.add(displayItem('nobutton.png', NO_BUTTON_POS, (0,0),  menuRect), 'closemenu')
        menurects.menuButtonNo.append(3)
        menutext(QUITMESSAGE, QUTIMESSAGEPOS, TOPMENUSIZE, MENUHEADFONT, menuRect)
    elif menutype == 'save':
        menurects.add(displayItem('savegamebutton.png', SAVE_GAME_BUTTON_POS, (0,0), menuRect), 'showpromptsave')
        menutext(SAVEMESSAGE, SAVEMESSAGE_POS,  TOPMENUSIZE, MENUHEADFONT,menuRect)
        menurects.menuButtonNo.append(2)
        
        menutext(EXPMESSAGE1, EXPPOS1, MENUSPEELSIZE, SPEELFONT, menuRect)
        menutext(EXPMESSAGE2, EXPPOS2, MENUSPEELSIZE, SPEELFONT, menuRect)
        menutext(EXPMESSAGE3, EXPPOS3, MENUSPEELSIZE, SPEELFONT, menuRect)
    elif menutype == 'load':
        menutext(LOADMESSAGE, LOADMESSAGE_POS, TOPMENUSIZE, MENUHEADFONT, menuRect)
        menurects.add(displayItem('loadgamebutton.png', LOAD_GAME_BUTTON_POS, (0,0), menuRect), 'showpromptload')
        menurects.menuButtonNo.append(2)
        menutext(EXPMESSAGE1, EXPPOS1, MENUSPEELSIZE, SPEELFONT, menuRect)
        menutext(EXPMESSAGE2, EXPPOS2, MENUSPEELSIZE, SPEELFONT, menuRect)
        menutext(EXPMESSAGE3, EXPPOS3, MENUSPEELSIZE, SPEELFONT, menuRect)
        
    elif menutype == 'options':
        addzip = 0
        menutext(OPTIONSMESSAGE, OPTIONSMESSAGE_POS, TOPMENUSIZE, MENUHEADFONT, menuRect)
        menutext(TRANS_TITLE_MESSAGE, TRANS_TITLE_MESSAGE_POS, TRANS_TITLE_MESSAGE_SIZE, SPEELFONT, menuRect)

        menutext(RADIO1_TEXT, RADIO1_TEXT_POS, RADIO_SIZE, SPEELFONT, menuRect)
        menutext(RADIO2_TEXT, RADIO2_TEXT_POS, RADIO_SIZE, SPEELFONT, menuRect)
        menutext(RADIO3_TEXT, RADIO3_TEXT_POS, RADIO_SIZE, SPEELFONT, menuRect)
        menutext(RADIO4_TEXT, RADIO4_TEXT_POS, RADIO_SIZE, SPEELFONT, menuRect)
        if not parameters.DISABLE_ZIPMODE:
            menutext(RADIO_ZIP_TEXT, RADIO_ZIP_TEXT_POS, RADIO_SIZE, SPEELFONT, menuRect)
        
        if parameters.DEFAULT_TRANSITION == None:
            menurects.add(radioButton(RADIO1_POS,1,menuRect), 'transNone')
        else:
            menurects.add(radioButton(RADIO1_POS,0,menuRect), 'transNone')

        if parameters.DEFAULT_TRANSITION == 'FASTEST':
            menurects.add(radioButton(RADIO2_POS,1,menuRect), 'transFastest')
        else:
            menurects.add(radioButton(RADIO2_POS,0,menuRect), 'transFastest')

        if parameters.DEFAULT_TRANSITION == 'NORMAL':
            menurects.add(radioButton(RADIO3_POS,1,menuRect), 'transNormal')
        else:
            menurects.add(radioButton(RADIO3_POS,0,menuRect), 'transNormal')
        if parameters.DEFAULT_TRANSITION == 'BEST':
            menurects.add(radioButton(RADIO4_POS,1,menuRect), 'transBest')
        else:
            menurects.add(radioButton(RADIO4_POS,0,menuRect), 'transBest')

        if not parameters.DISABLE_ZIPMODE:
            addzip = 1
            if parameters.ZIPMODE:
                menurects.add(checkBox(RADIO_ZIP_POS,1,menuRect), 'zip')
            else:
                
                menurects.add(checkBox(RADIO_ZIP_POS,0,menuRect), 'zip')

        menurects.menuButtonNo.append(5+addzip)
        
    elif menutype == 'promptsave':
        menurects.add(displayItem('yesbutton.png', YES_BUTTON_POS, (0,0),  menuRect), 'savegame')
        menurects.add(displayItem('nobutton.png', NO_BUTTON_POS, (0,0),  menuRect), 'closemenu')
        menurects.menuButtonNo.append(3)
        menutext(PROMPTSAVEMESSAGE, PROMPTSAVEMESSAGEPOS, TOPMENUSIZE, MENUHEADFONT, menuRect)
        
    elif menutype == 'promptload':
        menurects.add(displayItem('yesbutton.png', YES_BUTTON_POS, (0,0),  menuRect), 'loadgame')
        menurects.add(displayItem('nobutton.png', NO_BUTTON_POS, (0,0),  menuRect), 'closemenu')
        menurects.menuButtonNo.append(3)
        menutext(PROMPTLOADMESSAGE, PROMPTLOADMESSAGEPOS, TOPMENUSIZE, MENUHEADFONT, menuRect)
        
def menucursor(mousepos):
    length =len(menurects.menuButtonrects)
    if len(menurects.menuButtonrects) > 0: 
        for i in range(length-menurects.menuButtonNo[len(menurects.menuButtonNo)-1],length):

            if menurects.menuButtonrects[i].collidepoint(mousepos):
                return menurects.menuButtonFn[i]

def menutext(thetext, position, size, thefont, menurect):
    
    font = pygame.font.Font(thefont, size)
    text = font.render(thetext, 1, FONTCOLOUR)
    textrect = text.get_rect()
    textrect.topleft = menurect.left + position[0], menurect.top + position[1]
    gfx.surface.blit(text, textrect)
        
