"""
    Copyright 2001-2002 Andrew Jones

    This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""
import pygame, os, nodedata
from pygame.locals import *

import parameters, saveloadfns
from parameters import *
import constants
from constants import *

import menus, gfx, cursors
from menus import *

def event(menu):
    returnvalue = None
    ev = pygame.event.poll()
    
    cursors.cursor.hide()
    
    
    menuvisible = 1
    
    if menu != None:
          menu = menus.display(menu)
          mousepos = pygame.mouse.get_pos()
          menucursorZone = menus.menucursor(mousepos)
    cursors.cursor.show()
    while menuvisible:
        dirtyrects = []
        dirtyrects.extend([cursors.cursor.hide()])
        
        if not pygame.mouse.get_focused():
            #print 'not reciving focus'
            
            event = pygame.event.wait()
            if event.type == pygame.QUIT:
                if  menu != 'quit':
                    menu = menus.display('showquit')
                    mousepos = pygame.mouse.get_pos()
                    menucursorZone = menus.menucursor(mousepos)
        
        else:
            
            #get current event
            event = pygame.event.wait()

            #---MOUSEBUTTONUP EVENT----------------------------
            if (event.type == pygame.MOUSEBUTTONUP):
                radio = 0
                
                if menucursorZone != None:
                     #print menucursorZone
                     if  menucursorZone == 'quitgame':

                         menu = 0
                         gfx.quittest = 1
                     elif menucursorZone == 'savegame':
                         saveloadfns.save_game()
                         menucursorZone = 'closemenu'
                     elif menucursorZone == 'loadgame':
                         returnvalue = saveloadfns.load_game()
                         menucursorZone = 'closemenu'

                     elif menucursorZone == 'transNone':
                         radio = 1
                         changeRadio('None')
                     elif menucursorZone == 'transFastest':
                         radio = 1
                         changeRadio('FASTEST')
                     elif menucursorZone == 'transNormal':
                         radio = 1
                         changeRadio('NORMAL')
                     elif menucursorZone == 'transBest':
                         radio = 1
                         changeRadio('BEST')
                     elif menucursorZone == 'zip':
                         radio = 1
                         changeRadio('ZIP')
                     
                     if not  radio:
                         menu = menus.display(menucursorZone)
                         mousepos = pygame.mouse.get_pos()
                         menucursorZone = menus.menucursor(mousepos)

                     if menu == None:
                         menuvisible = 0
            #----KEYDOWN EVENT--------------------------------
            elif event.type == pygame.KEYDOWN:
                #print player_event
                keystate = pygame.key.get_pressed()
                
                if keystate[K_ESCAPE]:
                    
                    if menu != 'quit':

                        menu = menus.display('showquit')
                        mousepos = pygame.mouse.get_pos()
                        menucursorZone = menus.menucursor(mousepos)
                        
                elif keystate[K_q] and parameters.TESTINGFULL:
                    gfx.quittest = 1
                    menuvisible = 0
                
            #---MENU MOUSE MOTION----------------------------
            elif event.type == pygame.MOUSEMOTION:
                mousepos = pygame.mouse.get_pos()
                menucursorZone = menus.menucursor(mousepos)
                cursors.cursor.update(event)
        dirtyrects.extend([cursors.cursor.show()])
        pygame.display.update(dirtyrects)
        
    cursors.cursor.hide()
    return returnvalue
    
    
        


