"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#image functions

import pygame, os, gfx, nodedata, constants, parameters, paths
from pygame.locals import *

def showimage(currentView):
    
    updateRect = []
    i=0
    for image_file in currentView.imagefile:
        file = os.path.join(paths.current_image_path, currentView.imagefile[i])
        imagebitmap = gfx.load(file)
        imageRect = imagebitmap.get_rect()
        
        if currentView.image[i].isAlpha():
            imagebitmap.set_colorkey(imagebitmap.get_at(currentView.image[i].getAlphaPos()))
                                     
        imageRect = Rect(currentView.imagepos[i][0] + parameters.viewRect.left,
                         currentView.imagepos[i][1]+parameters.viewRect.top,imageRect.width, imageRect.height)
        tempSurface = pygame.Surface(imageRect.size)  
        gfx.imagerectstore.append(imageRect)
        
        tempSurface.blit(gfx.surface, (0,0), imageRect)
        gfx.imagesurfacestore.append(tempSurface)
        
        gfx.surface.blit(imagebitmap,imageRect)
        updateRect.append(imageRect)
        
        i = i + 1
    #pygame.display.update(updateRect)

def show(currentView):
    updateRect = []
    i=0
    for image_file in currentView.imagefile:
        file = os.path.join(paths.current_image_path, currentView.imagefile[i])
        imagebitmap = gfx.load(file)
        imageRect = imagebitmap.get_rect()
        if currentView.image[i].isAlpha():
            imagebitmap.set_colorkey(imagebitmap.get_at(currentView.image[i].getAlphaPos()))
        
        imageRect = Rect(currentView.imagepos[i][0] + parameters.viewRect.left,currentView.imagepos[i][1]+parameters.viewRect.top,imageRect.width, imageRect.height)
        tempSurface = pygame.Surface(imageRect.size)  
        gfx.imagerectstore.append(imageRect)
        
        tempSurface.blit(gfx.surface, (0,0), imageRect)
        gfx.imagesurfacestore.append(tempSurface)
        
        gfx.surface.blit(imagebitmap,imageRect)
        updateRect.append(imageRect)
        
        i = i + 1
    pygame.display.update(updateRect)
    

def change(pos, file, newPos):
    thefile = file
    currentView = nodedata.currentslide 
    if file == None:
        file = os.path.join(paths.current_image_path, currentView.imagefile[pos])
        imagebitmap = gfx.load(file)
        file = currentView.imagefile[pos]
    else:
        file = os.path.join(paths.current_image_path, file)
        imagebitmap = gfx.load(file)

    if currentView.image[pos].isAlpha():
            imagebitmap.set_colorkey(imagebitmap.get_at(currentView.image[i].getAlphaPos()))

    #if nodedata.hastype('alphaimage') and currentView.alphaimage[pos] != None:
    #    imagebitmap.set_colorkey(imagebitmap.get_at(currentView.alphaimage[pos]))
    
    imageRect = imagebitmap.get_rect()

    if newPos != None:
        currentView.imagepos[pos] = newPos
    
    currentView.imagefile[pos] = thefile
    
    imageRect = Rect(currentView.imagepos[pos][0] + parameters.viewRect.left,currentView.imagepos[pos][1]+parameters.viewRect.top,imageRect.width, imageRect.height)
    
    gfx.surface.blit(gfx.imagesurfacestore[pos],gfx.imagerectstore[pos])
    
    tempSurface = pygame.Surface(imageRect.size)
    tempSurface.blit(gfx.surface, (0,0), imageRect)
    
    gfx.surface.blit(imagebitmap,imageRect)
    gfx.surface.blit(imagebitmap,imageRect.topleft)
    pygame.display.update((gfx.imagerectstore[pos],imageRect))
    
    gfx.imagerectstore[pos] = imageRect
    gfx.imagesurfacestore[pos] = tempSurface
    return changeRectback(imageRect)

def move(pos, newPos):
    currentView = nodedata.currentslide
    file = os.path.join(currentView.imagefile[pos])
    imagebitmap = gfx.load(file)

    if currentView.image[pos].isAlpha():
            imagebitmap.set_colorkey(imagebitmap.get_at(currentView.image[i].getAlphaPos()))
            
    #if nodedata.hastype('alphaimage') and currentView.alphaimage[pos] != None:
    #    imagebitmap.set_colorkey(imagebitmap.get_at(currentView.alphaimage[pos]))
    
    currentView.imagepos[pos] = newPos

    imageRect = imagebitmap.get_rect()
    imageRect = Rect(currentView.imagepos[pos][0] + parameters.viewRect.left,currentView.imagepos[pos][1]+parameters.viewRect.top,imageRect.width, imageRect.height)

    gfx.surface.blit(gfx.imagesurfacestore[pos],gfx.imagerectstore[pos])
    
    tempSurface = pygame.Surface(imageRect.size)
    tempSurface.blit(gfx.surface, (0,0), imageRect)
    
    gfx.surface.blit(imagebitmap,imageRect)
    pygame.display.update((gfx.imagerectstore[pos],imageRect))
    
    gfx.imagerectstore[pos] = imageRect
    gfx.imagesurfacestore[pos] = tempSurface

    return changeRectback(imageRect)

def changeRectback(aRect):
    return Rect( aRect.left- parameters.viewRect.left,aRect.top-parameters.viewRect.top,aRect.width, aRect.height)
    
    


    
    
        
    

