"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#graphics class

import pygame, os, pygame.image, paths
from pygame.locals import *

import parameters


dirtyrects = []
surfacestorage = []
surfacerectstorage = []
imagerectstore = []
imagesurfacestore = []

radiosurfacestorage = []
radiorectstorage = []

checkboxsurfacestorage = []
checkboxrectstorage = []

quittest = 0

    
def initialize():
    global surface, rect
    
    try:
        flags = 0
        if parameters.FULL_SCREEN:
            flags |= parameters.FULLSCREEN
        depth = pygame.display.mode_ok(parameters.SCREENSIZE, flags, parameters.resolution)
        surface = pygame.display.set_mode(parameters.SCREENSIZE, flags, depth)
        rect = surface.get_rect()

        pygame.mouse.set_visible(0)
            
    except pygame.error, msg:
        import messagebox
        messagebox.error('Cannot Initialize Graphics', msg.args[0])
    if not pygame.image.get_extended():
        raise SystemExit, "Requires the extended image loading from SDL_image"

def initializeBackground():
    background = pygame.Surface(rect.size)
    background.fill(parameters.BACKGROUNDCOLOUR)
    surface.blit(background, (0,0))
    pygame.display.flip()

def updateslide(file):
    global slideRect, oldslideSurface
    view = os.path.join(paths.current_slide_path, file)
    bitmap = pygame.image.load(view).convert()
    slideRect = bitmap.get_rect()
    slideRect.center = rect.center
    slideSurface = pygame.Surface(slideRect.size)
    #print slideRect
    oldslideSurface = pygame.Surface(slideRect.size)
    oldslideSurface.blit(surface, (0,0),slideRect) 
    slideSurface.blit(bitmap, (0,0))
    surface.blit(slideSurface, slideRect)
    
    #pygame.display.update(slideRect)

def showslide(file):
    #view = os.path.join('data', file)
    bitmap = pygame.image.load(file).convert()
    slideRect = bitmap.get_rect()
    slideRect.center = rect.center
    slideSurface = pygame.Surface(slideRect.size)
    #print slideRect
    slideSurface.blit(bitmap, (0,0))
    surface.blit(slideSurface, slideRect)
    
    pygame.display.update(slideRect)

def menuButton(visible):
    menubuttonrect = Rect(parameters.MENUBUTTONRECT)
    menuButtonSurface = pygame.Surface(menubuttonrect.size)
    if visible:
        
	menubutton = os.path.join('pyzzledata', 'menudata','menubutton.png')
	menubuttonbitmap = pygame.image.load(menubutton).convert()
        menubuttonbitmap.set_colorkey(menubuttonbitmap.get_at((0,0)))
        surface.blit(menubuttonbitmap, parameters.MENUBUTTONPOS)
        
    else:
	menuButtonSurface.fill(parameters.BACKGROUNDCOLOUR)
        surface.blit(menuButtonSurface, menubuttonrect)
    pygame.display.update(menubuttonrect)

def load(fileName):
    
    #file = os.path.join('data', fileName)
    img = pygame.image.load(fileName)
    #use rle acceleration if no hardware accel
    if not surface.get_flags() & HWSURFACE:
        clear = img.get_colorkey()
        if clear:
            img.set_colorkey(clear, RLEACCEL)
    return img.convert()
    
def dirty2(rect1, rect2):
    if not rect2:
        dirtyrects.append(rect1)
    elif rect.colliderect(rect2):
        dirtyrects.append(rect1.union(rect2))
    else:
        dirtyrects.append(rect1)
        dirtyrects.append(rect2)

def clearRadio():
    while radiosurfacestorage != []:
        radiosurfacestorage.pop()
        radiorectstorage.pop()
