"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#objects class

import pygame, os, pygame.image, paths, cursors, nodedata
from pygame.locals import *
import constants, gfx, parameters,pyzzlemain
from constants import *

objectArray = []
objectArrayRect = []
xpos = 0
inobjects = 0
outobjects = 0
moviepos = None
ismovie = 0
playmovie = 0
firsttime = 0

#adds the object object to the users object array
def append(object):
    global firsttime
    objectArray.append(object)
    if parameters.OBJECT_ARRAY_HIDE_ALPHA > 0 and firsttime != 0:
        rolloutArray()
    
#removes the object object from the users object array
def remove(object):
    for x in objectArray:
        if object == x:
            objectArray.remove(x)
            return 1
    return 0
        
#returns true if user has the object object in there object array       
def probe(object):
    for x in objectArray:
        if object == x:
            return 1
    return 0

def rolloverArray():
    global xpos,objectArrayRect, firsttime
    firsttime = 1
    objectArrayRect = []
    tempSurface = pygame.Surface(parameters.OBJECT_RECT.size)
    tempSurface.fill(parameters.BACKGROUNDCOLOUR)
    gfx.surface.blit(tempSurface,parameters.OBJECT_RECT.topleft)
    x_pos = 0
    for x in objectArray:
        file = os.path.join(paths.current_object_path, x.iconfile)
        imagebitmap = pygame.image.load(file)
        imageRect = imagebitmap.get_rect()
        #setup images rect position
        imageRect.top = parameters.OBJECT_RECT.top
        imageRect.left = parameters.OBJECT_RECT.left + x_pos + parameters.OBJECT_IMAGE_SPACE
        #append the images rect to objectArrayRect
        objectArrayRect.append(imageRect)
        #xpos = xpos + parameters.OBJECTMAXSIZE

        #file = os.path.join(paths.current_object_path, x.iconfile)
        #imagebitmap = gfx.load(file)
        #imageRect = imagebitmap.get_rect()
        
        tempSurface.blit(imagebitmap, (x_pos+parameters.OBJECT_IMAGE_SPACE,0))
        x_pos = x_pos + parameters.OBJECTMAXSIZE

    tempSurface.set_alpha(parameters.OBJECT_ARRAY_SHOW_ALPHA)
    gfx.surface.blit(tempSurface,parameters.OBJECT_RECT.topleft)
    pygame.display.update()


def rolloutArray():
    global xpos,objectArrayRect, firsttime
    firsttime = 1
    objectArrayRect = []
    tempSurface = pygame.Surface(parameters.OBJECT_RECT.size)
    tempSurface.fill(parameters.BACKGROUNDCOLOUR)
    gfx.surface.blit(tempSurface,parameters.OBJECT_RECT.topleft)
    x_pos = 0
    for x in objectArray:
        file = os.path.join(paths.current_object_path, x.iconfile)
        imagebitmap = pygame.image.load(file)
        imageRect = imagebitmap.get_rect()
        #setup images rect position
        imageRect.top = parameters.OBJECT_RECT.top
        imageRect.left = parameters.OBJECT_RECT.left + x_pos + parameters.OBJECT_IMAGE_SPACE
        #append the images rect to objectArrayRect
        objectArrayRect.append(imageRect)
        #xpos = xpos + parameters.OBJECTMAXSIZE

        #file = os.path.join(paths.current_object_path, x.iconfile)
        #imagebitmap = gfx.load(file)
        #imageRect = imagebitmap.get_rect()
        
        tempSurface.blit(imagebitmap, (x_pos+parameters.OBJECT_IMAGE_SPACE,0))
        x_pos = x_pos + parameters.OBJECTMAXSIZE

    tempSurface.set_alpha(parameters.OBJECT_ARRAY_HIDE_ALPHA)
    gfx.surface.blit(tempSurface,parameters.OBJECT_RECT.topleft)
    pygame.display.update()




"""
def rolloutArray():
    
    #clearRectArray()

    tempSurface = pygame.Surface(parameters.OBJECT_RECT.size)
    temp2Surface = pygame.Surface(parameters.OBJECT_RECT.size)
    
    temp2Surface.blit(gfx.surface, (0,0), parameters.OBJECT_RECT)
    
    tempSurface.fill(parameters.BACKGROUNDCOLOUR)
    gfx.surface.blit(tempSurface,parameters.OBJECT_RECT.topleft)

    temp2Surface.set_alpha(parameters.OBJECT_ARRAY_HIDE_ALPHA)
    #tempSurface.fill(parameters.BACKGROUNDCOLOUR)
    gfx.surface.blit(temp2Surface,parameters.OBJECT_RECT.topleft)
    pygame.display.update()
    #showArray()
"""
    

def cursor(mousepos):    
    for x in objectArrayRect:
     if x.collidepoint(mousepos):    
         dummy=1
         
    
     
def show_object(object):
    global inobjects
    inobjects = 1
    nodedata.objectreturnslide = nodedata.currentslide
    nodedata.nextslide = object
