"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

#image functions

import pygame, os, gfx,  gfxcursor, parameters, nodedata, paths
from pygame.locals import *

from gfxcursor import *

def initializecusors():
    global cursor, fwdcursor, leftcursor,left180cursor, rightcursor, right180cursor, grabcursor, fistcursor, arrowcursor, upcursor, downcursor,zipcursor
    global std180_map, std_map, LandR_map, LandRup_map, LandRdown_map, iscursoron, iscursor, tmpmousepos, cursordisabled
    iscursoron = 1
    iscursor = 1
    cursordisabled = 0
    tmpmousepos = (0,0)
    file = os.path.join(paths.current_cursor_path,'fwd.png')
    
    fwdbitmap = gfx.load(file)
    fwdRect = fwdbitmap.get_rect()
    fwdbitmap.set_colorkey(fwdbitmap.get_at(parameters.fwdalphapix))
    fwdcursor = GfxCursor(gfx.surface, fwdbitmap, parameters.fwdhotspot)

    file = os.path.join(paths.current_cursor_path,'fist.png')

    fistbitmap = gfx.load(file)
    fistRect = fistbitmap.get_rect()
    fistbitmap.set_colorkey(fistbitmap.get_at(parameters.fistalphapix))
    fistcursor = GfxCursor(gfx.surface, fistbitmap, parameters.fisthotspot)

    file = os.path.join(paths.current_cursor_path,'grab.png')
    
    grabbitmap = gfx.load(file)
    grabRect = grabbitmap.get_rect()
    grabbitmap.set_colorkey(grabbitmap.get_at(parameters.grabalphapix))
    grabcursor = GfxCursor(gfx.surface, grabbitmap, parameters.grabhotspot)

    file = os.path.join(paths.current_cursor_path,'left.png')
    
    leftbitmap = gfx.load(file)
    leftRect = leftbitmap.get_rect()
    leftbitmap.set_colorkey(leftbitmap.get_at(parameters.leftalphapix))
    leftcursor = GfxCursor(gfx.surface, leftbitmap, parameters.lefthotspot)

    file = os.path.join(paths.current_cursor_path,'right.png')
    
    rightbitmap = gfx.load(file)
    rightRect = rightbitmap.get_rect()
    rightbitmap.set_colorkey(rightbitmap.get_at(parameters.rightalphapix))
    rightcursor = GfxCursor(gfx.surface, rightbitmap, parameters.righthotspot)

    file = os.path.join(paths.current_cursor_path,'right180.png')
    
    right180bitmap = gfx.load(file)
    right180Rect = right180bitmap.get_rect()
    right180bitmap.set_colorkey(right180bitmap.get_at(parameters.right180alphapix))
    right180cursor = GfxCursor(gfx.surface, right180bitmap, parameters.right180hotspot)

    file = os.path.join(paths.current_cursor_path,'left180.png')
    
    left180bitmap = gfx.load(file)
    left180Rect = left180bitmap.get_rect()
    left180bitmap.set_colorkey(left180bitmap.get_at(parameters.left180alphapix))
    left180cursor = GfxCursor(gfx.surface, left180bitmap, parameters.left180hotspot)

    file = os.path.join(paths.current_cursor_path,'up.png')
    
    upbitmap = gfx.load(file)
    upRect = upbitmap.get_rect()
    upbitmap.set_colorkey(upbitmap.get_at(parameters.upalphapix))
    upcursor = GfxCursor(gfx.surface, upbitmap, parameters.uphotspot )

    file = os.path.join(paths.current_cursor_path,'down.png')
    
    downbitmap = gfx.load(file)
    downRect = downbitmap.get_rect()
    downbitmap.set_colorkey(downbitmap.get_at(parameters.downalphapix))
    downcursor = GfxCursor(gfx.surface, downbitmap, parameters.downhotspot)

    file = os.path.join(paths.current_cursor_path,'zip.png')
    
    zipbitmap = gfx.load(file)
    zipRect = zipbitmap.get_rect()
    zipbitmap.set_colorkey(zipbitmap.get_at(parameters.zipalphapix))
    zipcursor = GfxCursor(gfx.surface, zipbitmap, parameters.ziphotspot)

    file = os.path.join(paths.current_cursor_path,'arrow.png')
    
    arrowbitmap = gfx.load(file)
    arrowRect = arrowbitmap.get_rect()
    arrowbitmap.set_colorkey(arrowbitmap.get_at(parameters.arrowalphapix))
    arrowcursor = GfxCursor(gfx.surface, arrowbitmap, parameters.arrowhotspot)

    std180_map = left180cursor, fwdcursor, right180cursor
    std_map = leftcursor, fwdcursor, rightcursor
    LandR_map = leftcursor, rightcursor
    LandRup_map = leftcursor, upcursor, rightcursor
    LandRdown_map  = leftcursor, downcursor, rightcursor
    updown_map = upcursor, downcursor

def enable():
    global iscursor, tmpmousepos,cursordisabled
    cursor.enable()
    iscursor = 1
    cursordisabled = 0
    pygame.mouse.set_pos(tmpmousepos)

def disable():
    global iscursor
    cursor.disable()
    iscursor = 0
    

def change_cursor(cur_zone, current_map, cust_curarray ):
     global cursor, fwdcursor, leftcursor,left180cursor, rightcursor, right180cursor, grabcursor, fistcursor, zipcursor
     global std180_map, std_map, LandR_map, LandRup_map, LandRdown_map, tmpCursor
     
     if not (cur_zone < 0):
          if current_map == 'std':
              cursor = std_map[cur_zone]

          elif current_map == 'std180':

              cursor = std180_map[cur_zone]

          elif current_map == 'LandR':
              cursor = LandR_map[cur_zone]

          elif current_map == 'LandRup':
              cursor = LandRup_map[cur_zone]

          elif current_map == 'LandRdown':
              cursor = LandRdown_map[cur_zone]

          elif current_map == 'updown':
              cursor = updown_map[cur_zone]

          elif current_map == 'custom':
              cursor = get_cursor(cust_curarray[cur_zone])
          elif current_map == 'zip':
             
              cursor = get_cursor(cust_curarray[cur_zone])

     elif cur_zone == -1 or cur_zone == -3:
          
          cursor = fwdcursor
     
     else:
          
          cursor = arrowcursor
          
     nodedata.cursor = cursor
    
         
#this function just returns with the current cursor value, used for the custom maps
def get_cursor(which_cursor):
     global cursor, fwdcursor, leftcursor,left180cursor, rightcursor, right180cursor, grabcursor, zipcursor
     if which_cursor == 'left':
          
          return leftcursor
          
     elif which_cursor == 'right':
         
          return rightcursor
          
     elif which_cursor == 'forward':
         
          return fwdcursor
          
     elif which_cursor == 'noaction':
          
          return fwdcursor
          
     elif which_cursor == 'action':
         
          return grabcursor
          
     elif which_cursor == 'up':
        
          return upcursor
          
     elif which_cursor == 'down':
          
          return downcursor

     elif which_cursor == 'zip':
          
          return zipcursor
          
     elif which_cursor == 'left180':
        
          return left180cursor
          
     elif which_cursor == 'right180':
          
          return right180cursor
