"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle-Cavern.

    Pyzzle-Cavern is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle-Cavern is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

import os
import pygame, parameters
from pygame.locals import *


#General Game Paramters
PYZZLE_VERSION = parameters.VERSION
GAME_NAME = "Pyzzle-"+ PYZZLE_VERSION
#DISPLAYSIZE = parameters.SCREENSIZE 
#SLIDESIZE = parameters.SLIDESIZE 

#predefined hotspot map parameters
TURNDEPTH = parameters.TURNMAPDEPTH
VERTICALDEPTH = parameters.SLIDESIZE[1]/2 
VERTICALDEPTHBOTTOM = VERTICALDEPTH 


# unspecific menu constants
MENUALPHA = 200 
TOPMENUHOTSPOT = 15 
ALPHA_X = 2,2  
FONTCOLOUR = 255, 255, 255 
MENUHEADFONT = os.path.join('pyzzledata','text', 'avgardn.ttf') 
SPEELFONT = os.path.join('pyzzledata','text', 'avgardn.ttf') 
TOPMENUSIZE = 26 
TOPMENUTEXTPOS = 20, 20
RADIO_ON_ALPHA = (3,3)
RADIO_OFF_ALPHA = (3,3)
# MAIN menu constants
MAINMENUCOLOUR = 0, 0, 150 
TOPMENUTEXT = GAME_NAME + ": MENU"
MENUSPEEL_1 = "Pyzzle a free Myst/Riven multiplatform interface engine. Orbis Tertius"
MENUSPEEL_3 = "Pyzzle is distributed under the GPL."
MENUSPEEL_2 = "http://orbistertius.sourceforge.net/ is a demo game created by malefico."
MENUSPEEL_1POS = 20, 300 
MENUSPEEL_2POS = 20, 315
MENUSPEEL_3POS = 20, 330
MENUSPEELSIZE = 14 
MENU_QUIT_BUTTONPOS = 40, 220
MENU_OPTIONS_BUTTONPOS = 40, 180
MENU_SAVE_BUTTONPOS = 40, 140
MENU_LOAD_BUTTONPOS = 40, 100
MAINMENURECT = Rect(100, 100, 550, 400)  
MENUDEPTH = 50, 50

# QUIT menu constants
QUITMENUCOLOUR = 150, 0, 0
QUITMESSAGE = "Quit " +GAME_NAME+"?"
QUTIMESSAGEPOS = 30,10
YES_BUTTON_POS = 50,60
NO_BUTTON_POS = 170,60
QUIT_MENU_SIZE = 300, 150
QUITMENURECT = Rect(330, 200, 300, 150)


#LOAD menu constants
LOADMENUCOLOUR = 150,150, 0 
LOADMESSAGE = GAME_NAME+": LOAD GAME MENU"
LOADMESSAGE_POS = 20, 10
LOAD_GAME_BUTTON_POS = 40, 80
LOAD_MENU_SIZE = 420, 350
LOAD_MENU_POSOTION = 340, 180
LOADMENURECT = Rect(340, 180, 420, 350)


#SAVE menu constants
SAVEMENUCOLOUR = 0, 150, 0 
SAVEMESSAGE = GAME_NAME+": SAVE GAME MENU"
SAVEMESSAGE_POS = 20, 10
SAVE_GAME_BUTTON_POS = 40, 80
SAVE_MENU_SIZE = 420, 350
SAVE_MENU_POSOTION = 320, 150 
SAVEMENURECT = Rect(320,150, 420, 350)


#OPTIONS menu constants
OPTIONSMENUCOLOUR = 150,0,150
OPTIONSMESSAGE = GAME_NAME+": Options"
OPTIONSMESSAGE_POS = 20, 10
RADIO1_POS = 50, 100
RADIO2_POS = 50, 130
RADIO3_POS = 50, 160
RADIO4_POS = 50, 190
RADIO_ZIP_POS = 50, 240

RADIO1_TEXT = 'None'
RADIO2_TEXT = 'Fastest'
RADIO3_TEXT = 'Normal'
RADIO4_TEXT = 'Best'
RADIO_ZIP_TEXT = 'Zip Mode'


TRANS_TITLE_MESSAGE_POS = 50, 60
TRANS_TITLE_MESSAGE = "Transitions"
TRANS_TITLE_MESSAGE_SIZE = 24
OPTIONS_MENU_SIZE = 420, 350
OPTIONS_MENU_POSOTION = 300,100
OPTIONSMENURECT = Rect(295,80,420, 350)

RADIO1_TEXT_POS = 80, 100
RADIO2_TEXT_POS = 80, 130
RADIO3_TEXT_POS = 80, 160
RADIO4_TEXT_POS = 80, 190
RADIO_ZIP_TEXT_POS = 80, 240
RADIO_SIZE = 20

#PROMPT BOX menu constants
PROMPTMENUCOLOUR = 150, 0, 0
PROMPTLOADMESSAGE = "Load game?"
PROMPTSAVEMESSAGE = "Save current game?"
PROMPTSAVEMESSAGEPOS = 20, 17
PROMPTLOADMESSAGEPOS = 20, 10
PROMPT_MENU_SIZE = 300, 150
PROMPT_MENU_POSITION = 420, 300
PROMPTMENURECT = Rect(420, 300, 300, 150)

EXPMESSAGE1 = 'Saving and loading functions are currently NOT working.'
EXPMESSAGE2 = ' '
EXPMESSAGE3 = ' '
EXPPOS1 = 30,120
EXPPOS2 = 30,135
EXPPOS3 = 30,150


######################################################################################

SCREENRECT = Rect(0, 0, parameters.SCREENSIZE[0], parameters.SCREENSIZE[1])
#parameters.viewRect = Rect(0, 0, parameters.SLIDESIZE[0], parameters.SLIDESIZE[1])
#parameters.viewRect.center = SCREENRECT.center #parameters.viewRect is currently setup for the slides to go in the center of the screen
MENU_DISPLAY_RECT = Rect(0, 0, SCREENRECT.width, TOPMENUHOTSPOT) # the stip along the top of the window/screen that displays the menu graphic
QUIT_MENU_PORT_RECT = Rect(0,0, QUIT_MENU_SIZE[0], QUIT_MENU_SIZE[1]) # the rect for the quit menu
SAVE_MENU_PORT_RECT = Rect(parameters.viewRect.left + SAVE_MENU_POSOTION[0], parameters.viewRect.top + SAVE_MENU_POSOTION[1], SAVE_MENU_SIZE[0], SAVE_MENU_SIZE[1]) # the rect for the save menu
LOAD_MENU_PORT_RECT = Rect(parameters.viewRect.left + LOAD_MENU_POSOTION[0], parameters.viewRect.top + LOAD_MENU_POSOTION[1], LOAD_MENU_SIZE[0], LOAD_MENU_SIZE[1]) # the rect for the load menu
OPTIONS_MENU_PORT_RECT = Rect(parameters.viewRect.left + OPTIONS_MENU_POSOTION[0], parameters.viewRect.top + OPTIONS_MENU_POSOTION[1], OPTIONS_MENU_SIZE[0], OPTIONS_MENU_SIZE[1]) # the rect for the load menu
PROMPT_MENU_PORT_RECT = Rect(PROMPT_MENU_POSITION[0],PROMPT_MENU_POSITION[1], PROMPT_MENU_SIZE[0], PROMPT_MENU_SIZE[1]) # the rect for the prompt menu

VIEW_SIZE_Y = parameters.SLIDESIZE[1]
VIEW_SIZE = (parameters.SLIDESIZE[0], parameters.SLIDESIZE[1])


MENU_PORT_RECT = Rect(parameters.viewRect.left + MENUDEPTH[0], parameters.viewRect.top+MENUDEPTH[1], parameters.viewRect.width-2*MENUDEPTH[0],parameters.viewRect.height-2*MENUDEPTH[1])
QUIT_MENU_PORT_RECT.center = MENU_PORT_RECT.center
MENU_BUTTON_RECT = MENU_DISPLAY_RECT
#------------------------------------------------

