"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""
import img, mov, sld, tripwire, nodedata, tripwire 

class Slide:
    def __init__(self, label = 0):
        self.label = label
        self.contains = ['custom']
        self.slidefile = None
        self.navdata = []
        self.custmaps = []
        self.zip_custmaps = []
        self.zip_navdata = []
        self.zip_which_cursor = []
        self.which_cursor = []
        self.transition_override = []
        self.imagefile = []
        self.imagepos = []
        self.image = []
        self.moviefile = []
        self.moviepos = []
        self.state = []
        self.action = None
        self.delay = 0
        self.onEntranceptr = None
        self.onExitFn = None
        self.onExitSlideFn = None
        self.onExitSlideFn = None
        self.text = []
            
    def appendImage(self, image, pos):
        
        if not self.hasType('image'):
            self.contains.append('image')
        image.setPosition(pos)
        image.setSlide(self)
        
        self.imagefile.append(image.getFile())
        self.imagepos.append(pos)
        self.image.append(image)
        
        image.setArraypos(len(self.imagefile)-1)
            
    def appendMovie(self, movie, pos):
        if not self.hasType('movie'):
            self.contains.append('movie')
        self.moviefile.append(movie.getFile())
        self.moviepos.append(pos)
        movie.setPosition(pos)

        movie.setArraypos(len(self.moviefile)-1)
        
    def appendMovieLoop(self, movie, pos):
        if not self.hasType('movieloop'):
            self.contains.append('movieloop')
        self.moviefile.append(movie.getFile())
        self.moviepos.append(pos)
        movie.setPosition(pos)

        movie.setArraypos(len(self.moviefile)-1)

    def updateMovie(self, arraypos, movie, pos = 0):
        self.moviefile[arraypos] = movie.getFile()
        if pos != 0:
            self.moviepos[arraypos] = pos
            
    def updateMovieLoop(self, arraypos, movie, pos = 0):
        self.moviefile[arraypos] = movie.getFile()
        if pos != 0:
            self.moviepos[arraypos] = pos
            
    def updateCursor(self, arraypos, cursor):
        self.which_cursor[arraypos] = cursor
        
    def appendText(self, text):
        if not self.hasType('text'):
            self.contains.append('text')
        self.text.append(text)
        
    def updateText(self, arraypos, text):
        self.text[arraypos] = text
        
    def setNavType(self, navtype):
        self.contains[0] = navtype
        
    def setSlideFile(self, file):
        self.slidefile = file
        
    def updateSlide(self, file):
        sld.change(file) 
        self.slidefile = file
        
    def setNavigation(self, navarray):
        self.navdata = navarray
        
    def setLabel(self, label):
        self.label = label
        
    def getLabel(self):
        return self.label
        
    def onEntrance(self, function):
        if not self.hasType('onEntrance'):
            self.contains.append('onEntrance')
        self.onEntranceFn = function

    def onExit(self, function):
        if not self.hasType('onExit'):
            self.contains.append('onExit')
        self.onExitFn = function
        
    def onExitSlide(self, slide, function):
        if not self.hasType('onExitSlide'):
            self.contains.append('onExitSlide')
        self.onExitSlideFn = function
        self.onExitSlideptr = slide
        
    def appendHotspot(self, nav, map, cursor, transover = 0):
        self.navdata.append(nav)
        self.custmaps.append(map)
        self.which_cursor.append(cursor)
        
        if transover != 0:
            if not self.hasType('transition_override'):
                self.contains.append('transition_override')
            if len(self.navdata) > 1:
                for i in range(len(self.navdata)-1):
                    self.transition_override.append(None)
            self.transition_override.append(transover)
        else:
            if self.hasType('transition_override'):
                self.transition_override.append(None)
            
    def appendZipHotspot(self, nav, map, cursor, transover = 0):

        self.zip_navdata.append(nav)
        self.zip_custmaps.append(map)
        self.zip_which_cursor.append(cursor)
        
        if not self.hasType('zip'):
            self.contains.append('zip')
            if self.contains[0] == 'std':
                self.zip_which_cursor.append('left')
                self.zip_which_cursor.append('forward')
                self.zip_which_cursor.append('right')
                
            elif self.contains[0] == 'std180':
                self.zip_which_cursor.append('left180')
                self.zip_which_cursor.append('forward')
                self.zip_which_cursor.append('right180')

            elif self.contains[0] == 'LandRup':
                self.zip_which_cursor.append('left')
                self.zip_which_cursor.append('up')
                self.zip_which_cursor.append('right')
                
            elif self.contains[0] == 'LandRdown':
                self.zip_which_cursor.append('left')
                self.zip_which_cursor.append('down')
                self.zip_which_cursor.append('right')

            elif self.contains[0] == 'LandR':
                self.zip_which_cursor.append('left')
                self.zip_which_cursor.append('right')

            elif self.contains[0] == 'updown':
                self.zip_which_cursor.append('up')
                self.zip_which_cursor.append('down') 

            elif self.contains[0] == 'custom':
                for i in range(len(self.which_cursor)):
                    self.zip_which_cursor.append(self.which_cursor[i])
                

            for i in range(len(self.navdata)):
                self.zip_navdata.append(self.navdata[i])
            

                                       
        if transover != 0:
            if not self.hasType('transition_override'):
                self.contains.append('transition_override')
            if len(self.navdata) > 1:
                for i in range(len(self.navdata)-1):
                    self.transition_override.append(None)
            self.transition_override.append(transover)
        else:
            if self.hasType('transition_override'):
                self.transition_override.append(None)
        
    def updateMap(self, pos, map):
        self.custmaps[pos] = map
            
    def setState(self, state):
        self.state = state
        
    def setDelay(self, delay):
        self.delay = delay
    def getDelay(self):
        return self.delay
    
    def getState(self):
        return self.state

    def updateState(self, arraypos, state):
        self.state[arraypos] = state
        
    def setAction(self,function):
        if not self.hasType('action'):
            self.contains.append('action')
        self.action = function
        
    def getAction(self):
        return self.action
          
    #Private methods
    def hasType(self, type):
        for i in self.contains:
            if i == type:
                return 1
        return 0
    
    def doOnExitSlide(self):
        if tripwire.slidechange(self, self.onExitSlideptr):
            self.onExitSlideFn()
