"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#nodedata functions
import mov

class Movie:
    def __init__(self, file):
        self.file = file
        self.pos = (0,0)
        
    def setPosition(self,pos):
        self.pos = pos

    def getPosition(self):
        return self.file

    def setFile(self, file):
        self.file = file
        
    def getFile(self):
        return self.file
        
    def play(self, loopflag, cursorflag = 0):
        mov.play(self.arraypos, loopflag, cursorflag)

    def playTrigger(self, function, cursorflag = 0):
        mov.play_trigger(self.arraypos, function, cursorflag)

    def playImage(self, imagefile, offset, movcur = 0):
        mov.play_image(self.arraypos, imagefile, offset, movcur = 0)
        
    #private methods
    def setArraypos(self,pos):
        self.arraypos = pos
