"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""
import img, nodedata
                    
class Image:
    def __init__(self, file, alphapos = 0):
        self.file = file
        self.pos = (0,0)
        self.slide = None
        self.arraypos = 0
        if alphapos != 0:
            self.alphapos = alphapos
            self.isalpha = 1
        else:
            self.alphapos = (0,0)
            self.isalpha = 0

    def set(self, file, pos = 0):
        self.file = file
        self.slide.imagefile[self.arraypos] = file
        if pos != 0:
            self.slide.imagepos[self.arraypos] = pos
        
    def setPosition(self,pos):
        self.pos = pos
    
    def getFile(self):
        return self.file

    def setAlpha(self, alphapos):
        self.alphapos =  alphapos
        self.isaplha = 1

    def isAlpha(self):
        return self.isalpha
    
    def getAlphaPos(self):
        return self.alphapos
    
    def getPosition(self):
        return self.file
    
    def update(self, file, pos = 0):
        self.file = file
        self.slide.imagefile[self.arraypos] = file
        if pos != 0:
            self.slide.imagepos[self.arraypos] = pos
        self.draw()
        
    def draw(self):   
        if self.slide == nodedata.currentslide:
            img.change(self.arraypos, self.file, None)

    def move(self, pos):
        img.move(self.arraypos, newPos)
            
    #private methods        
    def setArraypos(self,pos):
        self.arraypos = pos

    def setSlide(self, slide):
        self.slide = slide
