"""
Copyright 2001-2002 Andrew Jones

This file is part of Pyzzle.

    Pyzzle is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Pyzzle is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Pyzzle; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""

#nodedata functions
import snd

class AmbientSound:
    def __init__(self, file, volume = 1.0):
        self.file = file
        self.volume = volume

    def setFile(self, file):
        self.file = file

    def setVolume(self, volume):
        self.volume = volume
        
    def getVolume(self):
        return self.volume
        
    def getFile(self):
        return self.file
    
    def play(self, volume = 1.0):
        if volume < 1.0:
            self.volume = volume
        snd.playambient(self.file, self.volume)
        
    def stop(self):
        snd.stopambient()

