"""
This file is the Orbis Tertius demo game using Pyzzle's new API.

Note the music was downloaded from www.myst.com
"""
import os, sys

#import the engine
import pyzzle
from pyzzle import *

#demo game imports
import demoConstents

# Customize  pyzzle parameters
parameters.setScreenSize((800,600)) # fullscreen/window size in game
parameters.setSlideSize((640,480))   # Maximum slide size in game
parameters.setResolution(24)         # 24 bits/pixel colour
parameters.setFullScreen(1)          # Run in full screen toggle
parameters.setTestMode(0)            # testing mode toggle, quick 'q' key exit
parameters.setBackgroundColor((0,0,0)) # set the background color to black

parameters.setDefaultTransition(best_transition)
#best_transition, none_transition, fastest_transition
# or normal_transition
                                                 
parameters.setObjectArrayAlpha(70, 190)# transparency amount for hidden objects in array,
                                      #keep at 0 for completely transpatent objects and
                                      #transparency amount for objects in array
                                      
#parameters.disableZipMode() #Uncomment to remove the zip option from your game.
parameters.setZipMode(0) # Start with ZIP mode off

#tell pyzzle which paths to use. Very important
paths.setTextPath(os.path.join('demodata','text'))
paths.setObjectPath(os.path.join('demodata', 'objects'))
paths.setSlidePath(os.path.join('demodata', 'slides'))
paths.setSoundPath(os.path.join('demodata', 'sounds'))
paths.setImagePath(os.path.join('demodata', 'images'))
paths.setMoviePath(os.path.join('demodata', 'movies'))

#define all Slide containers

start   = Slide('slides can now be given a label')
black2  = Slide()
black   = Slide()
view1_1 = Slide() 
view1_2 = Slide()
view1_3 = Slide()
view1_4 = Slide()
view2_1 = Slide()
view2_2 = Slide()
view3_1 = Slide()
view3_2 = Slide()
view3_3 = Slide()
view3_4 = Slide()
view4_1 = Slide()
view4_4 = Slide()
view5_2 = Slide()
view6_1 = Slide()
view6_2 = Slide()
view6_3 = Slide()
view6_4 = Slide()
view6_5 = Slide()

#slides used for objects
letter_object_slide = Slide()
papperclipping_object_slide = Slide()

#define all text containers
text1 = Text('text1')
text2 = Text('text2')
text3 = Text('text3')

#define all object containers
papperclipping_object = Object('paperclip')
letter_object = Object('letter')

#define all image containers
book = Image('blank.png')
clipping = Image('clippingsmall.jpg')
borges = Image('borges-floating.jpg')
#replace the below line with the one behind it to see alpha transparent images in action
alphaimage = Image('blank.png') #alphaimage = Image('testalpha.png', (1,1))

#define all movie containers
staticmovie = Movie('static_01.MPG')
orbismovie = Movie('orbis.mpg')

#define all ambient sound containers
portalsound = AmbientSound('portal1.wav')
ticktwo = AmbientSound('ticktwo.wav')
ticktwosoft = AmbientSound('ticktwosoft.wav')
mech = AmbientSound('Mech.wav')

#define all sound containers
linksound = Sound('Link.wav')
paperturnquick = Sound('paperturnquick.wav')
curtainslide = Sound('windowslide.wav') 

#Logic control function for the 1st slide book
def myBookLogic():    
    if start.getState()[0] == 'bookdown': 
        start.updateState(0, 'bookcover')
        start.updateMap(0, (204,80,222,330))
        book.update('bookcover.jpg')
        
    elif start.getState()[0] == 'bookcover':
        if parameters.getZipMode():
            start.updateCursor(0,zip_cursor)
        start.updateState(0,'bookmovie')
        start.updateMap(0, (387,180,176,128))
        book.update('bookopenstart.jpg', (150,80))
        staticmovie.play(1, 1) # staticmovie.playTrigger(myMovietrigger,1)
        portalsound.play()
    elif start.getState()[0] == 'bookmovie':
        start.updateState(0,'bookdown')               # set all elements back to orginal config
        start.updateMap(0, (213,160,225,119))
        book.set('blank.png', (204,80))
        portalsound.stop()
        linksound.play()
        if not parameters.getZipMode():
            pyzzle.change_slide(black)
        else:
            pyzzle.change_slide(view4_1)  
        start.updateCursor(0,action_cursor)
        
#Logic control function for the curtains
def myCurtainLogic():
    curtainslide.play()
    view3_4.setState(not view3_4.getState())
    
    if view3_4.getState():
        view3_4.updateSlide('room-3-4b.jpg')
        view4_4.setSlideFile('room-4-4b.jpg')   
        view1_4.setSlideFile('room-1-4b.jpg')
        view4_1.setSlideFile('room-4-1b.jpg')
        view3_3.setSlideFile('room-3-3b.jpg')
    else:
        view3_4.updateSlide('room-3-4.jpg')      # if curtains are false
        view4_4.setSlideFile('room-4-4.jpg')     # change current slide image
        view1_4.setSlideFile('room-1-4.jpg')     # update relevent slide images
        view4_1.setSlideFile('room-4-1.jpg')
        view3_3.setSlideFile('room-3-3.jpg')
        
#Logic control function for picking up the news paper clip
def myClippingfn():
    gameobjects.append(papperclipping_object)# add the object to the users object array
    clipping.update('blank.png')#  replace the image with the a 1 pixel transparent image.
                                # The easy way to remove an image    
    view6_3.updateMap(0, (0,0,0,0))# set the action hotspot to a rect with no area.
                                # Making it unclickable
    gameobjects.show_object(papperclipping_object_slide) # show the papperclip slide to the user
                                                        # after it is 'picked up'
                                                        
#Logic control function for exiting view6_5
def view65OnExit():
    if tripwire.slidechange(view6_5,black2) or tripwire.slidechange(view6_5,start) :
        mech.stop()
        linksound.play()
        
#Logic control function for the play_trigger() function in myBookLogic
def myMovietrigger():
    if start.getState()[1]:
        start.updateMovie(0, orbismovie, (180,180))  
        orbismovie.play_trigger(myMovietrigger,1)
    else:
       start.updateMovie(0, staticmovie, (387,180)) 
       staticmovie.play_trigger(myMovietrigger,1)
    start.updateState(1, not start.getState()[1])

# Some helpful rects
LEFTRECT = (0, 0, parameters.TURNMAPDEPTH,parameters.SLIDESIZE[1])
RIGHTRECT = (parameters.SLIDESIZE[0]-parameters.TURNMAPDEPTH, 0,
             parameters.TURNMAPDEPTH,parameters.SLIDESIZE[1])
BOOKCOVER = (209, 75, 222, 330)
BOOKPREVIOUSPAGE = (102, 71, 216, 337)
BOOKNEXTPAGE = (318, 71, 216, 337)


#-----start defining slides--------------------------------
start.setSlideFile('startscreen.jpg') #set slide image file
                    #Slide  rect               cursor
start.appendHotspot(action, (213,160,225,119), action_cursor) #append a hotspot to this slide
start.appendImage(book, (204,80)) #append a image to this slide
start.appendImage(alphaimage, (184,170)) #append a image to this slide
start.appendMovie(staticmovie,(387,180)) #append a movie to this slide
start.setState(['bookdown', 1]) #set some variables for this slide
start.setAction(myBookLogic) # reference to the above logic function myBookLogic()

#delay slides used for transition after the player clicks on a book
black.setNavType(delay) 
black.setDelay(3500)
black.setSlideFile('black.jpg')
black.setNavigation([view4_1]) # delay slides only have one navigation reference

black2.setNavType(delay)
black2.setDelay(3500)
black2.setSlideFile('black.jpg')
black2.setNavigation([start])

view1_1.setNavType(standard) # use the standard hotspot map for this slide
view1_1.setSlideFile('room-1-1.jpg')
view1_1.setNavigation([view1_4, view3_1, view1_2]) # left, forward, right navigation references
view1_1.appendZipHotspot(view4_1, (62,106,111,123), zip_cursor) #set a Zip hotspot map
#Zip hotspots are only used when the player has zipmode selected

view1_2.setNavType(standard)
view1_2.setSlideFile('room-1-2.jpg')
view1_2.setNavigation([view1_1, view5_2, view1_3])

view1_3.setNavType(LandR) # use the turn left and turn right standard hotspot map
view1_3.setSlideFile('room-1-3.jpg')
view1_3.setNavigation([view1_2, view1_4]) #left, right navigation references

view1_4.setNavType(standard)
view1_4.setSlideFile('room-1-4.jpg')
view1_4.setNavigation([view1_3, view3_4, view1_1])

view3_1.setNavType(standard)
view3_1.setSlideFile('room-3-1.jpg')
view3_1.setNavigation([view3_4, view4_1, view3_2])

view3_2.setNavType(LandR)
view3_2.setSlideFile('room-3-2.jpg')
view3_2.setNavigation([view3_1, view3_3])

view3_3.setNavType(standard)
view3_3.setSlideFile('room-3-3.jpg')
view3_3.setNavigation([view3_2, view1_3, view3_4])
view3_3.appendZipHotspot(view5_2, (39,365,67,29), zip_cursor)                     

view3_4.setSlideFile('room-3-4.jpg')
view3_4.appendHotspot(view3_3,LEFTRECT, left_cursor)
view3_4.appendHotspot(view3_1,RIGHTRECT, right_cursor)
view3_4.appendHotspot(action,(100, 0, 200, 480), action_cursor)
view3_4.setState(0)
view3_4.setAction(myCurtainLogic)

view4_1.setNavType(LandR)
view4_1.setNavigation([view4_4, view3_2])
view4_1.setSlideFile('room-4-1.jpg')
view4_1.onEntrance(ticktwo.play)
view4_1.onExit(ticktwosoft.play)

view4_4.setNavType(standard)
view4_4.setSlideFile('room-4-4.jpg')
view4_4.setNavigation([view3_3, view3_4, view3_1])

view5_2.setSlideFile('room-5-2.jpg')
view5_2.appendHotspot(view1_2, (0, 360, 640, 120), down_cursor, fade) 
view5_2.appendHotspot(view6_1, (189, 208, 151, 110), action_cursor, fade)
view5_2.onExitSlide(view6_1, mech.play) # when the slide is exited play the mech music

view6_1.setSlideFile('libro-nodo-1.jpg')
view6_1.appendHotspot(view5_2, (0, 360, 640, 120), down_cursor, fade) 
view6_1.appendHotspot(view6_2, BOOKCOVER, forward_cursor, None)
view6_1.onExitSlide(view5_2, ticktwosoft.play)

view6_2.setSlideFile('libro-nodo-2.jpg')
view6_2.appendHotspot(view5_2, (0, 360, 640, 120), down_cursor, fade) 
view6_2.appendHotspot(view6_1, BOOKPREVIOUSPAGE, left_cursor, None)
view6_2.appendHotspot(view6_3, BOOKNEXTPAGE, right_cursor, None)
view6_2.onExitSlide(view5_2, ticktwosoft.play) # when the slide is exit and the next slide is view5_2
                                               # play the ticktwosoft sound
view6_2.onEntrance(paperturnquick.play) # when the slide is entered play the paperturn sound

view6_3.setSlideFile('libro-nodo-3.jpg')
view6_3.appendHotspot(action, (317,176,130,158), action_cursor, fade) 
view6_3.appendHotspot(view5_2, (0, 360, 640, 120), down_cursor, fade)
view6_3.appendHotspot(view6_2, BOOKPREVIOUSPAGE, left_cursor, None)
view6_3.appendHotspot(view6_4, BOOKNEXTPAGE, right_cursor, None)
view6_3.appendImage(clipping, (308,171))
view6_3.setAction(myClippingfn)
view6_3.onExitSlide(view5_2, ticktwosoft.play)
view6_3.onEntrance(paperturnquick.play)

view6_4.setSlideFile('libro-nodo-5.jpg')
view6_4.appendHotspot(view5_2, (0, 360, 640, 120), down_cursor, fade) 
view6_4.appendHotspot(view6_3, BOOKPREVIOUSPAGE, left_cursor, None)
view6_4.appendHotspot(view6_5, BOOKNEXTPAGE, right_cursor, None)
view6_4.appendImage(borges, (160,100))
view6_4.appendText(text1)
view6_4.appendText(text2)
view6_4.onExitSlide(view5_2, ticktwosoft.play)
view6_4.onEntrance(paperturnquick.play)

view6_5.setSlideFile('libro-nodo-5.jpg')
view6_5.appendHotspot(view5_2, (0, 360, 640, 120), down_cursor, fade)
view6_5.appendHotspot(view6_4, BOOKPREVIOUSPAGE, left_cursor, None)
view6_5.appendHotspot(black2, (343,173,160,146), action_cursor, None) 
view6_5.appendZipHotspot(start, (343,173,160,146), zip_cursor)
view6_5.appendMovieLoop(orbismovie, (343,173))
view6_5.onExitSlide(view5_2, ticktwosoft.play)
view6_5.onExit(view65OnExit) #DEVELOPER NOTE this should be improved with arrays
view6_5.onEntrance(paperturnquick.play)

#These two slides are used for the objects
# note object_return is used to get the player back to the main game
letter_object_slide.setSlideFile('letter_slide.jpg')
letter_object_slide.appendHotspot(object_return, LEFTRECT, down_cursor, fade)  
letter_object_slide.appendHotspot(object_return, RIGHTRECT, down_cursor, fade)

papperclipping_object_slide.setSlideFile('papperclippingslide.jpg')
papperclipping_object_slide.appendHotspot(object_return, LEFTRECT, down_cursor, fade)
papperclipping_object_slide.appendHotspot(object_return, RIGHTRECT, down_cursor, fade)

#--------End defining slides--------------------------------------

#-----Start defining text-----------------------------------------
text1.setString(demoConstents.STRING1)
text1.setFont('texhero.TTF', 15)
text1.setRect((340, 109, 180, 330))

text2.setString(demoConstents.STRING2)
text2.setFont('Missb___.ttf', 12, center_justified)
text2.setRect((130, 315, 160, 150))

text3.setString(demoConstents.STRING3)
text3.setFont('SOULPAPA.TTF', 18, center_justified)
text3.setRect((130, 109, 180, 330))
#-----End defining text-----------------------------------------

#-----Start defining objects--------------------
papperclipping_object.setObject('papperclipping_object.jpg',
                                papperclipping_object_slide)

letter_object.setObject('letter_object.jpg',
                                letter_object_slide)
#-----End defining objects--------------------

#add some objects to the players objects array
gameobjects.append(letter_object)

pyzzle.setFirstSlide(start) # set the 1st slide

#start your game
pyzzle.start()



