/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3u-20000712-1502 (Alpha 3)
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct swig_type_info {
  char  *name;                 
  void *(*converter)(void *);
  char  *str;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGEXPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGEXPORT(void *) SWIG_TypeCast(swig_type_info *, void *);
#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  while (s) {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Cast a pointer (needed for C++ inheritance */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(void *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

#endif

#ifdef __cplusplus
}
#endif



/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include <stdlib.h>
#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(void)              SWIG_MakePtr(char *c, void *, swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  "swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}
/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  unsigned long p;
  register int d;
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;

  if (!obj || (obj == Py_None)) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) Py_DECREF(obj);
      return 0;
    } else {
      if (newref) Py_DECREF(obj);
      goto type_error;
    }
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if (newref) Py_DECREF(obj);
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*)p);
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Take a pointer and convert it to a string */
SWIGRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[32], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type) {
  char result[512];
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, type->name, NULL);
#else
  SWIG_MakePtr(result,ptr,type);
  robj = PyString_FromString(result);
#endif
  return robj;
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

static swig_type_info *swig_types[1];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= __init___.so
  ------------------------------------------------*/
#define SWIG_init    init__init___

#define SWIG_name    "__init___"


int __PyObject_AsArray_Size(PyObject* x);

#ifdef NUMERIC

#define _PyObject_AsArray_Size(x) ((x == Py_None) ? 0 : ((PyArray_Check(x)) ? PyArray_Size(x) : __PyObject_AsArray_Size(x)))

#else /* NUMERIC */

#define _PyObject_AsArray_Size(x) ((x == Py_None) ? 0 : __PyObject_AsArray_Size(x))

#endif /* NUMERIC */


#define _PyObject_As(NAME, BASE) BASE* _PyObject_As##NAME(PyObject* source, PyObject** temp, int* len);

#define _PyObject_AsArray_Cleanup(target, temp) if (temp) Py_XDECREF(temp); else PyMem_Del(target)

_PyObject_As(FloatArray, float)

_PyObject_As(DoubleArray, double)

_PyObject_As(CharArray, signed char)

_PyObject_As(UnsignedCharArray, unsigned char)

_PyObject_As(ShortArray, short)

_PyObject_As(UnsignedShortArray, unsigned short)

_PyObject_As(IntArray, int)

_PyObject_As(UnsignedIntArray, unsigned int)

void* _PyObject_AsArray(GLenum type, PyObject* source, PyObject** temp, int* len);



#define PyErr_XPrint() if (PyErr_Occurred()) PyErr_Print()


#if HAS_DYNAMIC_EXT

#define DECLARE_EXT(PROC_NAME, RET, ERROR_RET, PROTO, CALL)\
RET PROC_NAME PROTO\
{\
	typedef RET (APIENTRY *proc_##PROC_NAME) PROTO;\
	proc_##PROC_NAME proc = (proc_##PROC_NAME)GL_GetProcAddress(#PROC_NAME);\
	if (proc) return proc CALL;\
	PyErr_SetGLerror(GL_INVALID_OPERATION);\
	return ERROR_RET;\
}

#define DECLARE_VOID_EXT(PROC_NAME, PROTO, CALL)\
void PROC_NAME PROTO\
{\
	typedef void (APIENTRY *proc_##PROC_NAME) PROTO;\
	proc_##PROC_NAME proc = (proc_##PROC_NAME)GL_GetProcAddress(#PROC_NAME);\
	if (proc) proc CALL;\
	else PyErr_SetGLerror(GL_INVALID_OPERATION);\
}

#else

#define DECLARE_EXT(PROC_NAME, RET, ERROR_RET, PROTO, CALL)\
RET PROC_NAME PROTO\
{\
	PyErr_SetGLerror(GL_INVALID_OPERATION);\
	return ERROR_RET;\
}

#define DECLARE_VOID_EXT(PROC_NAME, PROTO, CALL)\
void PROC_NAME PROTO\
{\
	PyErr_SetGLerror(GL_INVALID_OPERATION);\
}

#endif


#define _PyTuple_From(NAME, BASE) PyObject* _PyTuple_From##NAME(int len, BASE* data);

_PyTuple_From(UnsignedCharArray, unsigned char)

_PyTuple_From(CharArray, signed char)

_PyTuple_From(UnsignedShortArray, unsigned short)

_PyTuple_From(ShortArray, short)

_PyTuple_From(UnsignedIntArray, unsigned int)

_PyTuple_From(IntArray, int)

_PyTuple_From(FloatArray, float)

_PyTuple_From(DoubleArray, double)


#define _PyObject_From(NAME, BASE) PyObject* _PyObject_From##NAME(int nd, int* dims, BASE* data, int own);

_PyObject_From(UnsignedCharArray, unsigned char)

_PyObject_From(CharArray, signed char)

_PyObject_From(UnsignedShortArray, unsigned short)

_PyObject_From(ShortArray, short)

_PyObject_From(UnsignedIntArray, unsigned int)

_PyObject_From(IntArray, int)

_PyObject_From(FloatArray, float)

_PyObject_From(DoubleArray, double)


PyObject* _PyObject_FromArray(GLenum type, int nd, int *dims, void* data, int own);

void* SetupPixelRead(int rank, GLenum format, GLenum type, int *dims);

void SetupPixelWrite(int rank);

void* SetupRawPixelRead(GLenum format, GLenum type, int n, const int *dims, int* size);

void* _PyObject_AsPointer(PyObject* x);

void init_util();

typedef void *PTR;

typedef struct
{
	void (*_decrement)(void* pointer);
	void (*_decrementPointer)(GLenum pname);
	int (*_incrementLock)(void *pointer);
	int (*_incrementPointerLock)(GLenum pname);
	void (*_acquire)(void* pointer);
	void (*_acquirePointer)(GLenum pname);
#if HAS_DYNAMIC_EXT
	PTR (*GL_GetProcAddress)(const char* name);
#endif
	int (*InitExtension)(const char *name, const char** procs);
	PyObject *_GLerror;
	PyObject *_GLUerror;
}  util_API;



#ifndef GL_VERSION_1_1
PyObject *contexts;

typedef struct
{
	PyObject_HEAD
	GLenum feedback_type;
	GLfloat *feedback_buffer;
	GLuint *selection_buffer;
} PyGLcontext;


static void PyGLcontext_Del(PyObject *self)
{
	PyObject_Del(self);
}


PyTypeObject PyGLcontext_Type =
{
    PyObject_HEAD_INIT(0)
    0,									// ob_size
    "GLcontext",					// tp_name
    sizeof(PyGLcontext),			// tp_basicsize
    0,									// tp_itemsize
    PyGLcontext_Del,				// tp_dealloc
};


PyGLcontext* PyGLcontext_New()
{
	PyGLcontext *self = PyObject_NEW(PyGLcontext, &PyGLcontext_Type);

	self->feedback_buffer = NULL;
	self->selection_buffer = NULL;

	return self;
}


PyGLcontext *GetGLcontext()
{
	if (CurrentContextIsValid())
	{
		PyObject *key = PyInt_FromLong(GetCurrentContext());
		PyGLcontext *context = (PyGLcontext*)PyDict_GetItem(contexts, key);
		if (!context)
		{
			context = PyGLcontext_New();
			PyDict_SetItem(contexts, key, (PyObject*)context);
		}
		Py_DECREF(key);
		return context;
	}
	return NULL;
}

#endif

#define POINTER_COUNT 6

typedef struct
{
	void *pointers[POINTER_COUNT+1];
	int ref_count;
} PointerLock;

PointerLock *PointerLocks = NULL;
int PointerLockCount = 0;

GLenum *PointerTypes = NULL;
int PointerTypeCount = 0;

#ifndef GL_VERSION_1_1
#if !EXT_DEFINES_PROTO || !defined(GL_EXT_vertex_array)
DECLARE_VOID_EXT(glGetPointervEXT, (GLenum pname, void** params)), (GLenum pname, void** params))
#endif

static char *va_proc_names[] =
{
#if !EXT_DEFINES_PROTO || !defined(GL_EXT_vertex_array)
	"glGetPointervEXT",
#endif
	NULL
};

int InitExtension(const char* name, const char** procs);

void glGetPointerv(GLenum pname, void** params)
{
	if (InitExtension("GL_EXT_vertex_array", va_proc_names))
	{
		glGetPointervEXT(pname, params);
	}
}
#endif

/* decrementLock a pointer */
void decrementLock(void* pointer)
{
	if (pointer && PointerLocks)
	{
		int i, j;
		for (i = 0; i < PointerLockCount; i++)
		{
			for (j = 0; j < POINTER_COUNT+1; j++)
			{
				if (PointerLocks[i].pointers[j] == pointer && --PointerLocks[i].ref_count == 0)
				{
					int k;
					PyMem_Free(PointerLocks[i].pointers[0]);
					PointerLockCount--;
					for (k = i; k < PointerLockCount; k++) PointerLocks[k] = PointerLocks[k+1];
					return;
				}
			}
		}
	}
}


/* decrementLock a pointer referenced by glSelectBuffer, glFeedbackBuffer, glColorPointer, etc. */
void decrementPointerLock(GLenum pname)
{
	void* pointer = NULL;
	glGetPointerv(pname, &pointer);
	decrementLock(pointer);
}


void decrementAllLocks()
{
	int i;
	
	for (i = 0; i < PointerTypeCount; i++) decrementPointerLock(PointerTypes[i]);
}


/* increment pointer lock */
int incrementLock(void *pointer)
{
	if (pointer && PointerLocks)
	{
		int i, j;
		
		for (i = 0; i < PointerLockCount; i++)
		{
			for (j = 0; j < POINTER_COUNT+1; j++)
			{
				if (PointerLocks[i].pointers[j] == pointer)
				{
					PointerLocks[i].ref_count++;
					return 1;
				}
			}
		}
	}

	return 0;
}


void addPointerType(GLenum type)
{
	int i;
	
	for (i = 0; i < PointerTypeCount; i++) if (PointerTypes[i] == type) return;
	
	PointerTypes = (PointerTypes) ? PyMem_Resize(PointerTypes, GLenum, ++PointerTypeCount) : PyMem_New(GLenum, PointerTypeCount = 1);
	
	PointerTypes[PointerTypeCount-1] = type;
}


int incrementPointerLock(GLenum pname)
{
	void* pointer = NULL;
	int found;
	
	glGetPointerv(pname, &pointer);
	found = incrementLock(pointer);
	if (found) addPointerType(pname);

	return found;
}


void incrementAllLocks()
{
	int i;
	
	for (i = 0; i < PointerTypeCount; i++) incrementPointerLock(PointerTypes[i]);
}


/* acquire a pointer */
void acquire(void* pointer)
{
	if (pointer)
	{
		int i;
		PointerLock *lock;

		PointerLocks = (PointerLocks) ? PyMem_Resize(PointerLocks, PointerLock, ++PointerLockCount) : PyMem_New(PointerLock, PointerLockCount = 1);
		lock = PointerLocks + PointerLockCount - 1;
		(*lock).pointers[0] = pointer;
		(*lock).ref_count = 1;

		for (i = 1; i < POINTER_COUNT+1; i++) (*lock).pointers[i] = NULL;
	}
}

void acquirePointer(GLenum pname)
{
	void* pointer = NULL;
	glGetPointerv(pname, &pointer);
	acquire(pointer);
	addPointerType(pname);
}

void acquireInterleavedPointer(void* pointer, GLenum pnames[POINTER_COUNT])
{
	if (pointer)
	{
		int i;
		PointerLock *lock;

		PointerLocks = (PointerLocks) ? PyMem_Resize(PointerLocks, PointerLock, ++PointerLockCount) : PyMem_New(PointerLock, PointerLockCount = 1);
		lock = PointerLocks + PointerLockCount - 1;
		(*lock).pointers[0] = pointer;
		(*lock).ref_count = 0;

		for (i = 0; i < POINTER_COUNT; i++)
		{
			(*lock).pointers[i+1] = NULL;
			if (pnames[i])
			{
				glGetPointerv(pnames[i], (*lock).pointers + i + 1);
				if ((*lock).pointers[i+1])
				{
					addPointerType(pnames[i]);
					(*lock).ref_count++;
				}
			}
		}
	}
}

int in_extension_list(const char* name, char *list)
{
	size_t len = strlen(name);
	
	while (list && strlen(list))
	{
		if (strlen(list) >= len && !strncmp(list, name, len)) return 1;
		list = strchr(list, ' ');
		if (!list) return 0;
		list++;
	}

	return 0;
}


const char* GetPlatformExtensionsString();
void* GetExtProc(const char* name);

int has_extension(const char* name)
{
	if (CurrentContextIsValid())
	{
		return in_extension_list(name, (char*)glGetString(GL_EXTENSIONS)) ||
		       in_extension_list(name, (char*)gluGetString(GLU_EXTENSIONS)) ||
		       in_extension_list(name, (char*)GetPlatformExtensionsString());
	}

	return 0;
}


#if HAS_DYNAMIC_EXT
PyObject *ProcAddresses = NULL;

void *GL_GetProcAddress(const char* name)
{
	void *address = NULL;
	if (CurrentContextIsValid())
	{
		PyObject *key = Py_BuildValue("ls", GetCurrentContext(), name);
		PyObject *py_address = PyDict_GetItem(ProcAddresses, key);
		if (py_address) address = PyCObject_AsVoidPtr(py_address);
		Py_DECREF(key);
	}
	return address;
}
#endif

int InitExtension(const char* name, const char** procs)
{
	if (has_extension(name))
	{
		int success = 1;
		void *proc;
		PyObject *key;
#if HAS_DYNAMIC_EXT
		while (*procs)
		{
			key = Py_BuildValue("ls", GetCurrentContext(), *procs);
			if (PyDict_GetItem(ProcAddresses, key)) break;
			proc = (void*)GetExtProc(*procs);
			if (proc)
			{
				PyDict_SetItem(ProcAddresses, key, PyCObject_FromVoidPtr(proc, NULL));
			}
			Py_DECREF(key);
			procs++;
		}
#endif
		return success;
	}
	return 0;
}

static util_API _util_API;

PyObject *GLerror = NULL;
PyObject *GLUerror = NULL;


#define PyErr_SetGLerror(code) PyErr_SetObject(GLerror, Py_BuildValue("is", code, gluErrorString(code)));
#define PyErr_SetGLUerror(code) PyErr_SetObject(GLUerror, Py_BuildValue("is", code, gluErrorString(code)));

int _PyObject_Dimension(PyObject* x, int rank);

#define ERROR_MSG_SEP ", "
#define ERROR_MSG_SEP_LEN 2

int GLErrOccurred()
{
	if (PyErr_Occurred()) return 1;

	if (CurrentContextIsValid())
	{
		GLenum error, *errors = NULL;
		char *msg = NULL;
		const char *this_msg;
		int count = 0;
	
		error = glGetError();

		while (error != GL_NO_ERROR)
		{
			this_msg = gluErrorString(error);
			if (count)
			{
				msg = realloc(msg, (strlen(msg) + strlen(this_msg) + ERROR_MSG_SEP_LEN + 1)*sizeof(char));
				strcat(msg, ERROR_MSG_SEP);
				strcat(msg, this_msg);
				
				errors = realloc(errors, (count + 1)*sizeof(GLenum));
			}
			else
			{
				msg = malloc((strlen(this_msg) + 1)*sizeof(char));
				strcpy(msg, this_msg);
				
				errors = malloc(sizeof(GLenum));
			}
			
			errors[count++] = error;
			error = glGetError();
		}
		
		if (count)
		{
			PyErr_SetObject(GLerror, Py_BuildValue("Os", _PyTuple_FromIntArray(count, (int*)errors), msg));
			free(errors);
			free(msg);
			return 1;
		}
	}

	return 0;
}

 static char _doc_glArrayElement[] = "glArrayElement(i) -> None";
 static char _doc_glBegin[] = "glBegin(mode) -> None";
 static char _doc_glCallList[] = "glCallList(list) -> None";
 static char _doc_glCallLists[] = "glCallLists(lists[]) -> None";
 static char _doc_glColor3b[] = "glColor3b(red, green, blue) -> None";
 static char _doc_glColor3bv[] = "glColor3bv(v) -> None";
 static char _doc_glColor3d[] = "glColor3d(red, green, blue) -> None";
 static char _doc_glColor3dv[] = "glColor3dv(v) -> None";
 static char _doc_glColor3f[] = "glColor3f(red, green, blue) -> None";
 static char _doc_glColor3fv[] = "glColor3fv(v) -> None";
 static char _doc_glColor3i[] = "glColor3i(red, green, blue) -> None";
 static char _doc_glColor3iv[] = "glColor3iv(v) -> None";
 static char _doc_glColor3s[] = "glColor3s(red, green, blue) -> None";
 static char _doc_glColor3sv[] = "glColor3sv(v) -> None";
 static char _doc_glColor3ub[] = "glColor3ub(red, green, blue) -> None";
 static char _doc_glColor3ubv[] = "glColor3ubv(v) -> None";
 static char _doc_glColor3ui[] = "glColor3ui(red, green, blue) -> None";
 static char _doc_glColor3uiv[] = "glColor3uiv(v) -> None";
 static char _doc_glColor3us[] = "glColor3us(red, green, blue) -> None";
 static char _doc_glColor3usv[] = "glColor3usv(v) -> None";
 static char _doc_glColor4b[] = "glColor4b(red, green, blue) -> None";
 static char _doc_glColor4bv[] = "glColor4bv(v) -> None";
 static char _doc_glColor4d[] = "glColor4d(red, green, blue) -> None";
 static char _doc_glColor4dv[] = "glColor4dv(v) -> None";
 static char _doc_glColor4f[] = "glColor4f(red, green, blue) -> None";
 static char _doc_glColor4fv[] = "glColor4fv(v) -> None";
 static char _doc_glColor4i[] = "glColor4i(red, green, blue) -> None";
 static char _doc_glColor4iv[] = "glColor4iv(v) -> None";
 static char _doc_glColor4s[] = "glColor4s(red, green, blue) -> None";
 static char _doc_glColor4sv[] = "glColor4sv(v) -> None";
 static char _doc_glColor4ub[] = "glColor4ub(red, green, blue) -> None";
 static char _doc_glColor4ubv[] = "glColor4ubv(v) -> None";
 static char _doc_glColor4ui[] = "glColor4ui(red, green, blue) -> None";
 static char _doc_glColor4uiv[] = "glColor4uiv(v) -> None";
 static char _doc_glColor4us[] = "glColor4us(red, green, blue) -> None";
 static char _doc_glColor4usv[] = "glColor4usv(v) -> None";
 static char _doc_glEdgeFlag[] = "glEdgeFlag(flag) -> None";
 static char _doc_glEdgeFlagv[] = "glEdgeFlagv(flag) -> None";
 static char _doc_glEvalCoord1d[] = "glEvalCoord1d(u) -> None";
 static char _doc_glEvalCoord1dv[] = "glEvalCoord1dv(v) -> None";
 static char _doc_glEvalCoord1f[] = "glEvalCoord1f(u) -> None";
 static char _doc_glEvalCoord1fv[] = "glEvalCoord1fv(v) -> None";
 static char _doc_glEvalCoord2d[] = "glEvalCoord2d(u, v) -> None";
 static char _doc_glEvalCoord2dv[] = "glEvalCoord2dv(v) -> None";
 static char _doc_glEvalCoord2f[] = "glEvalCoord2f(u, v) -> None";
 static char _doc_glEvalCoord2fv[] = "glEvalCoord2fv(v) -> None";
 static char _doc_glEvalPoint1[] = "glEvalPoint1(i) -> None";
 static char _doc_glEvalPoint2[] = "glEvalPoint2(i, j) -> None";
 static char _doc_glIndexd[] = "glIndexd(c) -> None";
 static char _doc_glIndexdv[] = "glIndexdv(c) -> None";
 static char _doc_glIndexf[] = "glIndexf(d) -> None";
 static char _doc_glIndexfv[] = "glIndexfv(c) -> None";
 static char _doc_glIndexi[] = "glIndexi(c) -> None";
 static char _doc_glIndexiv[] = "glIndexiv(c) -> None";
 static char _doc_glIndexs[] = "glIndexs(c) -> None";
 static char _doc_glIndexsv[] = "glIndexsv(c) -> None";
 static char _doc_glIndexub[] = "glIndexub(c) -> None";
 static char _doc_glIndexubv[] = "glIndexubv(c) -> None";
 static char _doc_glMaterialf[] = "glMaterialf(face, pname, param) -> None";
 static char _doc_glMaterialfv[] = "glMaterialfv(face, pname, params[]) -> None";
 static char _doc_glMateriali[] = "glMateriali(face, pname, param) -> None";
 static char _doc_glMaterialiv[] = "glMaterialiv(face, pname, params[]) -> None";
 static char _doc_glNormal3b[] = "glNormal3b(nx, ny, nz) -> None";
 static char _doc_glNormal3bv[] = "glNormal3bv(v) -> None";
 static char _doc_glNormal3d[] = "glNormal3d(nx, ny, nz) -> None";
 static char _doc_glNormal3dv[] = "glNormal3dv(v) -> None";
 static char _doc_glNormal3f[] = "glNormal3f(nx, ny, nz) -> None";
 static char _doc_glNormal3fv[] = "glNormal3fv(v) -> None";
 static char _doc_glNormal3i[] = "glNormal3i(nx, ny, nz) -> None";
 static char _doc_glNormal3iv[] = "glNormal3iv(v) -> None";
 static char _doc_glNormal3s[] = "glNormal3s(nx, ny, nz) -> None";
 static char _doc_glNormal3sv[] = "glNormal3sv(v) -> None";
 static char _doc_glTexCoord1d[] = "glTexCoord1d(s) -> None";
 static char _doc_glTexCoord1dv[] = "glTexCoord1dv(v) -> None";
 static char _doc_glTexCoord1f[] = "glTexCoord1f(s) -> None";
 static char _doc_glTexCoord1fv[] = "glTexCoord1fv(v) -> None";
 static char _doc_glTexCoord1i[] = "glTexCoord1i(s) -> None";
 static char _doc_glTexCoord1iv[] = "glTexCoord1iv(v) -> None";
 static char _doc_glTexCoord1s[] = "glTexCoord1s(s) -> None";
 static char _doc_glTexCoord1sv[] = "glTexCoord1sv(v) -> None";
 static char _doc_glTexCoord2d[] = "glTexCoord2d(s, t) -> None";
 static char _doc_glTexCoord2dv[] = "glTexCoord2dv(v) -> None";
 static char _doc_glTexCoord2f[] = "glTexCoord2f(s, t) -> None";
 static char _doc_glTexCoord2fv[] = "glTexCoord2fv(v) -> None";
 static char _doc_glTexCoord2i[] = "glTexCoord2i(s, t) -> None";
 static char _doc_glTexCoord2iv[] = "glTexCoord2iv(v) -> None";
 static char _doc_glTexCoord2s[] = "glTexCoord2s(s, t) -> None";
 static char _doc_glTexCoord2sv[] = "glTexCoord2sv(v) -> None";
 static char _doc_glTexCoord3d[] = "glTexCoord3d(s, t, r) -> None";
 static char _doc_glTexCoord3dv[] = "glTexCoord3dv(v) -> None";
 static char _doc_glTexCoord3f[] = "glTexCoord3f(s, t, r) -> None";
 static char _doc_glTexCoord3fv[] = "glTexCoord3fv(v) -> None";
 static char _doc_glTexCoord3i[] = "glTexCoord3i(s, t, r) -> None";
 static char _doc_glTexCoord3iv[] = "glTexCoord3iv(v) -> None";
 static char _doc_glTexCoord3s[] = "glTexCoord3s(s, t, r) -> None";
 static char _doc_glTexCoord3sv[] = "glTexCoord3sv(v) -> None";
 static char _doc_glTexCoord4d[] = "glTexCoord4d(s, t, r, q) -> None";
 static char _doc_glTexCoord4dv[] = "glTexCoord4dv(v) -> None";
 static char _doc_glTexCoord4f[] = "glTexCoord4f(s, t, r, q) -> None";
 static char _doc_glTexCoord4fv[] = "glTexCoord4fv(v) -> None";
 static char _doc_glTexCoord4i[] = "glTexCoord4i(s, t, r, q) -> None";
 static char _doc_glTexCoord4iv[] = "glTexCoord4iv(v) -> None";
 static char _doc_glTexCoord4s[] = "glTexCoord4s(s, t, r, q) -> None";
 static char _doc_glTexCoord4sv[] = "glTexCoord4sv(v) -> None";
 static char _doc_glVertex2d[] = "glVertex2d(x, y) -> None";
 static char _doc_glVertex2dv[] = "glVertex2dv(v) -> None";
 static char _doc_glVertex2f[] = "glVertex2f(x, y) -> None";
 static char _doc_glVertex2fv[] = "glVertex2fv(v) -> None";
 static char _doc_glVertex2i[] = "glVertex2i(x, y) -> None";
 static char _doc_glVertex2iv[] = "glVertex2iv(v) -> None";
 static char _doc_glVertex2s[] = "glVertex2s(x, y) -> None";
 static char _doc_glVertex2sv[] = "glVertex2sv(v) -> None";
 static char _doc_glVertex3d[] = "glVertex3d(x, y, z) -> None";
 static char _doc_glVertex3dv[] = "glVertex3dv(v) -> None";
 static char _doc_glVertex3f[] = "glVertex3f(x, y, z) -> None";
 static char _doc_glVertex3fv[] = "glVertex3fv(v) -> None";
 static char _doc_glVertex3i[] = "glVertex3i(x, y, z) -> None";
 static char _doc_glVertex3iv[] = "glVertex3iv(v) -> None";
 static char _doc_glVertex3s[] = "glVertex3s(x, y, z) -> None";
 static char _doc_glVertex3sv[] = "glVertex3sv(v) -> None";
 static char _doc_glVertex4d[] = "glVertex4d(x, y, z, w) -> None";
 static char _doc_glVertex4dv[] = "glVertex4dv(v) -> None";
 static char _doc_glVertex4f[] = "glVertex4f(x, y, z, w) -> None";
 static char _doc_glVertex4fv[] = "glVertex4fv(v) -> None";
 static char _doc_glVertex4i[] = "glVertex4i(x, y, z, w) -> None";
 static char _doc_glVertex4iv[] = "glVertex4iv(v) -> None";
 static char _doc_glVertex4s[] = "glVertex4s(x, y, z, w) -> None";
 static char _doc_glVertex4sv[] = "glVertex4sv(v) -> None";
 static char _doc___has_extension[] = "Private function:  use appropriate extension initialization function instead.";
 static char _doc_glAccum[] = "glAccum(op, value) -> None";
 static char _doc_glAlphaFunc[] = "glAlphaFunc(func, ref) -> None";

PyObject* _glAreTexturesResident(GLsizei n, const GLuint *textures)
{
	GLboolean *residences = PyMem_New(GLboolean, n);
	PyObject *result;
	
	glAreTexturesResident(n, textures, residences);
	result = _PyTuple_FromUnsignedCharArray(n, residences);
	
	PyMem_Del(residences);
	return result;
}
 static char _doc_glAreTexturesResident[] = "glAreTexturesResident(textures[]) -> residences";
 static char _doc_glBindTexture[] = "glBindTexture(target, texture) -> None";
 static char _doc_glBitmap[] = "glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap) -> None";
 static char _doc_glBlendFunc[] = "glBlendFunc(sfactor, dfactor) -> None";
 static char _doc_glClear[] = "glClear(mask) -> None";
 static char _doc_glClearAccum[] = "glClearAccum(red, green, blue, alpha) -> None";
 static char _doc_glClearColor[] = "glClearColor(red, green, blue, alpha) -> None";
 static char _doc_glClearDepth[] = "glClearDepth(depth) -> None";
 static char _doc_glClearIndex[] = "glClearIndex(c) -> None";
 static char _doc_glClearStencil[] = "glClearStencil(s) -> None";
 static char _doc_glClipPlane[] = "glClipPlane(plane, equation[]) -> None";
 static char _doc_glColorMask[] = "glColorMask(red, gree, blue, alpha) -> None";
 static char _doc_glColorMaterial[] = "glColorMaterial(face, mode) -> None";

void _glColorPointer(GLint size, GLenum type, GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_COLOR_ARRAY_POINTER);
	acquire(pointer);
	glColorPointer(size, type, stride, pointer);
}
 static char _doc_glColorPointer[] = "glColorPointer(size, type, stride, pointer) -> None";
 static char _doc_glColorPointerub[] = "glColorPointerub(pointer[][]) -> None";
 static char _doc_glColorPointerb[] = "glColorPointerb(pointer[][]) -> None";
 static char _doc_glColorPointerus[] = "glColorPointerus(pointer[][]) -> None";
 static char _doc_glColorPointers[] = "glColorPointers(pointer[][]) -> None";
 static char _doc_glColorPointerui[] = "glColorPointerui(pointer[][]) -> None";
 static char _doc_glColorPointeri[] = "glColorPointeri(pointer[][]) -> None";
 static char _doc_glColorPointerf[] = "glColorPointerf(pointer[][]) -> None";
 static char _doc_glColorPointerd[] = "glColorPointerd(pointer[][]) -> None";
 static char _doc_glCopyPixels[] = "glCopyPixels(x, y, width, height, type) -> None";
 static char _doc_glCopyTexImage1D[] = "glCopyTexImage1D(target, level, internalFormat, x, y, width, border) -> None";
 static char _doc_glCopyTexImage2D[] = "glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border) -> None";
 static char _doc_glCopyTexSubImage1D[] = "glCopyTexSubImage1D(target, level, xoffset, x, y, width) -> None";
 static char _doc_glCopyTexSubImage2D[] = "glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height) -> None";
 static char _doc_glCullFace[] = "glCullFace(mode) -> None";
 static char _doc_glDeleteLists[] = "glDeleteLists(list, range) -> None";
 static char _doc_glDeleteTextures[] = "glDeleteTextures(textures[]) -> None";
 static char _doc_glDepthFunc[] = "glDepthFunc(func) -> None";
 static char _doc_glDepthMask[] = "glDepthMask(flag) -> None";
 static char _doc_glDepthRange[] = "glDepthRange(zNear, zFar) -> None";
 static char _doc_glDisable[] = "glDisable(cap) -> None";
 static char _doc_glDisableClientState[] = "glDisableClientState(array) -> None";
 static char _doc_glDrawArrays[] = "glDrawArrays(mode, first, count) -> None";
 static char _doc_glDrawBuffer[] = "glDrawBuffer(mode) -> None";
 static char _doc_glDrawElements[] = "glDrawElements(mode, count, type, indices) -> None";
 static char _doc_glDrawElementsub[] = "glDrawElementsub(mode, indices[]) -> None";
 static char _doc_glDrawElementsus[] = "glDrawElementsus(mode, indices[]) -> None";
 static char _doc_glDrawElementsui[] = "glDrawElementsui(mode, indices[]) -> None";
 static char _doc_glDrawPixels[] = "glDrawPixels(width, height, format, type, pixels) -> None";

void _glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* pixels)
{
	SetupPixelWrite(2);
	glDrawPixels(width, height, format, type, pixels);
}
 static char _doc_glDrawPixelsub[] = "glDrawPixelsub(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelsb[] = "glDrawPixelsb(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelsus[] = "glDrawPixelsus(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelss[] = "glDrawPixelss(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelsui[] = "glDrawPixelsui(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelsi[] = "glDrawPixelsi(format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glDrawPixelsf[] = "glDrawPixelsf(format, pixels[][] | pixels[][][]) -> None";

void _glEdgeFlagPointer(GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_EDGE_FLAG_ARRAY_POINTER);
	acquire(pointer);
	glEdgeFlagPointer(stride, pointer);
}
 static char _doc_glEdgeFlagPointer[] = "glEdgeFlagPointer(stride, pointer) -> None";
 static char _doc_glEdgeFlagPointerb[] = "glEdgeFlagPointerb(pointer[]) -> None";
 static char _doc_glEnable[] = "glEnable(cap) -> None";
 static char _doc_glEnableClientState[] = "glEnableClientState(array) -> None";
 static char _doc_glEnd[] = "glEnd() -> None";
 static char _doc_glEndList[] = "glEndList() -> None";
 static char _doc_glEvalMesh1[] = "glEvalMesh1(mode, i1, i2) -> None";
 static char _doc_glEvalMesh2[] = "glEvalMesh2(mode, i1, i2, j1, j2) -> None";

void _glFeedbackBuffer(GLsizei size, GLenum type)
{
	GLfloat *buffer = (size > 0) ? PyMem_New(GLfloat, size) : NULL;
#ifndef GL_VERSION_1_1
	PyGLcontext *context = GetGLcontext();
	context->feedback_type = type;
	context->feedback_buffer = buffer;
#endif
	glFeedbackBuffer(size, type, buffer);
}
 static char _doc_glFeedbackBuffer[] = "glFeedbackBuffer(size, type) -> None";
 static char _doc_glFinish[] = "glFinish() -> None";
 static char _doc_glFlush[] = "glFlush() -> None";
 static char _doc_glFogf[] = "glFogf(pname, param) -> None";
 static char _doc_glFogfv[] = "glFogfv(pname, params[]) -> None";
 static char _doc_glFogi[] = "glFogi(pname, param) -> None";
 static char _doc_glFogiv[] = "glFogiv(pname, params[]) -> None";
 static char _doc_glFrontFace[] = "glFrontFace(mode) -> None";
 static char _doc_glFrustum[] = "glFrustum(left, right, bottom, top, zNear, zFar) -> None";
 static char _doc_glGenLists[] = "glGenLists(range) -> listBase";

PyObject* _glGenTextures(GLsizei n)
{
	GLuint* textures;
	PyObject* result;
	
	textures = PyMem_New(GLuint, n);
	glGenTextures(n, textures);
	result = _PyTuple_FromUnsignedIntArray(n, textures);

	PyMem_Del(textures);
	return result;
}
 static char _doc_glGenTextures[] = "glGenTextures(n) -> textures";
 static char _doc_glGetBooleanv[] = "glGetBooleanv(pname) -> params";
 static char _doc_glGetClipPlane[] = "glGetClipPlane(plane) -> equation";
 static char _doc_glGetDoublev[] = "glGetDoublev(pname) -> params";
 static char _doc_glGetFloatv[] = "glGetFloatv(pname) -> params";
 static char _doc_glGetIntegerv[] = "glGetIntegerv(pname) -> params";
 static char _doc_glGetLightfv[] = "glGetLightfv(light, pname) -> params";
 static char _doc_glGetLightiv[] = "glGetLightiv(light, pname) -> params";

int _calcMapSizes(GLenum target, GLenum query, int *dimension, int *cp_size, int *v_size, int order[2])
{
	switch (target)
	{
	case GL_MAP1_INDEX:
	case GL_MAP1_TEXTURE_COORD_1:
		*dimension = 1;
		*cp_size = 1;
		break;
	case GL_MAP1_TEXTURE_COORD_2:
		*dimension = 1;
		*cp_size = 2;
		break;
	case GL_MAP1_NORMAL:
	case GL_MAP1_TEXTURE_COORD_3:
	case GL_MAP1_VERTEX_3:
		*dimension = 1;
		*cp_size = 3;
		break;
	case GL_MAP1_COLOR_4:
	case GL_MAP1_TEXTURE_COORD_4:
	case GL_MAP1_VERTEX_4:
		*dimension = 1;
		*cp_size = 4;
		break;
	case GL_MAP2_INDEX:
	case GL_MAP2_TEXTURE_COORD_1:
		*dimension = 2;
		*cp_size = 1;
		break;
	case GL_MAP2_TEXTURE_COORD_2:
		*dimension = 2;
		*cp_size = 2;
		break;
	case GL_MAP2_NORMAL:
	case GL_MAP2_TEXTURE_COORD_3:
	case GL_MAP2_VERTEX_3:
		*dimension = 2;
		*cp_size = 3;
		break;
	case GL_MAP2_COLOR_4:
	case GL_MAP2_TEXTURE_COORD_4:
	case GL_MAP2_VERTEX_4:
		*dimension = 2;
		*cp_size = 4;
		break;
	default:
		PyErr_SetString(PyExc_Exception, "Unknown target.");
		return 0;
	}

	switch (query)
	{
	case GL_COEFF:
		glGetMapiv(target, GL_ORDER, order);
		*v_size = (*cp_size)*order[0]*((*dimension == 2) ? order[1] : 1);
		break;
	case GL_ORDER:
		*v_size = *dimension;
		break;
	case GL_DOMAIN:
		*v_size = 2*(*dimension);
		break;
	default:
		PyErr_SetString(PyExc_Exception, "Unknown query.");
		return 0;
	}
	
	return 1;
}

 PyObject* _glGetMapdv(GLenum target, GLenum query) { 	int dimension, cp_size, v_size; 	GLint order[2]; 	double* v; 	PyObject* result; 	int dims[3];  	if (!_calcMapSizes(target, query, &dimension, &cp_size, &v_size, order)) return NULL;  	v = PyMem_New(double, v_size); 	glGetMapdv(target, query, v);  	if (query == GL_COEFF) 	{ 		if (dimension == 2) 		{ 			dims[0] = order[1]; 			dims[1] = order[0]; 			dims[2] = cp_size; 		} 		else 		{ 			dims[0] = order[0]; 			dims[1] = cp_size; 		} 		result = _PyObject_FromDoubleArray(dimension + 1, dims, v, 1); 	} 	else 	{ 		result = _PyTuple_FromDoubleArray(v_size, v); 		PyMem_Del(v); 	}  	return result; }
 PyObject* _glGetMapfv(GLenum target, GLenum query) { 	int dimension, cp_size, v_size; 	GLint order[2]; 	float* v; 	PyObject* result; 	int dims[3];  	if (!_calcMapSizes(target, query, &dimension, &cp_size, &v_size, order)) return NULL;  	v = PyMem_New(float, v_size); 	glGetMapfv(target, query, v);  	if (query == GL_COEFF) 	{ 		if (dimension == 2) 		{ 			dims[0] = order[1]; 			dims[1] = order[0]; 			dims[2] = cp_size; 		} 		else 		{ 			dims[0] = order[0]; 			dims[1] = cp_size; 		} 		result = _PyObject_FromFloatArray(dimension + 1, dims, v, 1); 	} 	else 	{ 		result = _PyTuple_FromFloatArray(v_size, v); 		PyMem_Del(v); 	}  	return result; }
 PyObject* _glGetMapiv(GLenum target, GLenum query) { 	int dimension, cp_size, v_size; 	GLint order[2]; 	int* v; 	PyObject* result; 	int dims[3];  	if (!_calcMapSizes(target, query, &dimension, &cp_size, &v_size, order)) return NULL;  	v = PyMem_New(int, v_size); 	glGetMapiv(target, query, v);  	if (query == GL_COEFF) 	{ 		if (dimension == 2) 		{ 			dims[0] = order[1]; 			dims[1] = order[0]; 			dims[2] = cp_size; 		} 		else 		{ 			dims[0] = order[0]; 			dims[1] = cp_size; 		} 		result = _PyObject_FromIntArray(dimension + 1, dims, v, 1); 	} 	else 	{ 		result = _PyTuple_FromIntArray(v_size, v); 		PyMem_Del(v); 	}  	return result; }
 static char _doc_glGetMapdv[] = "glGetMapdv(target, query) -> values";
 static char _doc_glGetMapfv[] = "glGetMapfv(target, query) -> values";
 static char _doc_glGetMapiv[] = "glGetMapiv(target, query) -> values";
 static char _doc_glGetMaterialfv[] = "glGetMaterialfv(face, pname) -> params";
 static char _doc_glGetMaterialiv[] = "glGetMaterialiv(face, pname) -> params";
 PyObject* _glGetPixelMapfv(GLenum map) { 	int i; 	GLint size; 	GLfloat* values; 	PyObject* result;  	glGetIntegerv(GL_PIXEL_MAP_I_TO_I_SIZE - GL_PIXEL_MAP_I_TO_I + map, &size); 	values = PyMem_New(GLfloat, size); 	glGetPixelMapfv(map, values);  	result = PyTuple_New(size); 	for (i = 0; i < size; i++) PyTuple_SetItem(result, i, PyFloat_FromDouble(values[i])); 	PyMem_Del(values);  	return result; }
 PyObject* _glGetPixelMapuiv(GLenum map) { 	int i; 	GLint size; 	GLuint* values; 	PyObject* result;  	glGetIntegerv(GL_PIXEL_MAP_I_TO_I_SIZE - GL_PIXEL_MAP_I_TO_I + map, &size); 	values = PyMem_New(GLuint, size); 	glGetPixelMapuiv(map, values);  	result = PyTuple_New(size); 	for (i = 0; i < size; i++) PyTuple_SetItem(result, i, PyLong_FromUnsignedLong(values[i])); 	PyMem_Del(values);  	return result; }
 PyObject* _glGetPixelMapusv(GLenum map) { 	int i; 	GLint size; 	GLushort* values; 	PyObject* result;  	glGetIntegerv(GL_PIXEL_MAP_I_TO_I_SIZE - GL_PIXEL_MAP_I_TO_I + map, &size); 	values = PyMem_New(GLushort, size); 	glGetPixelMapusv(map, values);  	result = PyTuple_New(size); 	for (i = 0; i < size; i++) PyTuple_SetItem(result, i, PyInt_FromLong(values[i])); 	PyMem_Del(values);  	return result; }
 static char _doc_glGetPixelMapfv[] = "glGetPixelMapfv(map) -> values";
 static char _doc_glGetPixelMapuiv[] = "glGetPixelMapuiv(map) -> values";
 static char _doc_glGetPixelMapusv[] = "glGetPixelMapusv(map) -> values";

PyObject* _glGetPolygonStipple()
{
	PyObject* result;
	int size;
	GLint dims[] = {32, 32};
	void* data = SetupRawPixelRead(GL_BITMAP, GL_UNSIGNED_BYTE, 2, dims, &size);
	if (!data) return NULL;
	
	glGetPolygonStipple(data);
	result = PyString_FromStringAndSize((const char*)data, size);
	PyMem_Del(data);

	return result;
}
 static char _doc_glGetPolygonStipple[] = "glGetPolygonStipple() -> packed stipple";

PyObject* glGetPolygonStippleub()
{
	int dims[] = {32, 32};
	GLubyte packed[128];
	GLubyte unpacked[1024];
	int i, j;
	
	glPixelStorei(GL_PACK_SWAP_BYTES, 0);
	glPixelStorei(GL_PACK_LSB_FIRST, 1);

	glGetPolygonStipple(packed);
	
	for (i = 0; i < 128; i++) for (j = 0; j < 8; j++) unpacked[8*i + j] = (packed[i] >> j) & 1;
	
	return _PyObject_FromUnsignedCharArray(2, dims, unpacked, 0);
}
 static char _doc_glGetPolygonStippleub[] = "glGetPolygonStippleub() -> stipple[][]";
 static char _doc_glGetString[] = "glGetString(name) -> string";
 static char _doc_glGetTexEnvfv[] = "glGetTexEnvfv(target, pname) -> params";
 static char _doc_glGetTexEnviv[] = "glGetTexEnviv(target, pname) -> params";
 static char _doc_glGetTexGendv[] = "glGetTexGendv(coord, pname) -> params";
 static char _doc_glGetTexGenfv[] = "glGetTexGenfv(coord, pname) -> params";
 static char _doc_glGetTexGeniv[] = "glGetTexGeniv(coord, pname) -> params";

#ifndef GL_SGIS_texture4D
#define GL_TEXTURE_4D_SGIS                0x8134
#define GL_TEXTURE_4DSIZE_SGIS            0x8136
#endif

#ifndef GL_VERSION_1_2
#define GL_TEXTURE_3D				0x806F
#define GL_TEXTURE_DEPTH			0x8071
#endif

/* figure out the rank of the image and the dimensions */
int get_tex_dims(GLenum target, GLint level, int dims[4])
{
	int rank = 0;

	/* just cascade through the switch, retrieving the apropriate sizes */
	switch (target)
	{
	case GL_TEXTURE_4D_SGIS:
		glGetTexLevelParameteriv(target, level, GL_TEXTURE_4DSIZE_SGIS, dims + rank++);
	case GL_TEXTURE_3D:
		glGetTexLevelParameteriv(target, level, GL_TEXTURE_DEPTH, dims + rank++);
	case GL_TEXTURE_2D:
		glGetTexLevelParameteriv(target, level, GL_TEXTURE_HEIGHT, dims + rank++);
	case GL_TEXTURE_1D:
		glGetTexLevelParameteriv(target, level, GL_TEXTURE_HEIGHT, dims + rank++);
	}
	
	return rank;
}

PyObject* _glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type)
{
	PyObject* result;
	int size;
	GLint dims[4];
	int rank;
	void* data = NULL;
	
	rank = get_tex_dims(target, level, dims);
	
	data = SetupRawPixelRead(format, type, rank, dims, &size);
	if (!data) return NULL;
	
	glGetTexImage(target, level, format, type, data);
	result = PyString_FromStringAndSize((const char*)data, size);
	PyMem_Del(data);

	return result;
}
 static char _doc_glGetTexImage[] = "glGetTexImage(target, level, format, type) -> pixels";

PyObject* __glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type)
{
	int dims[5], rank;
	void* data;

	rank = get_tex_dims(target, level, dims);
	
	data = SetupPixelRead(rank, format, type, dims);
	if (!data) return NULL;
	
	glGetTexImage(target, level, format, type, data);
	
	return _PyObject_FromArray(type, (dims[rank] == 1) ? rank-1 : rank, dims, data, 1);
}
 static char _doc_glGetTexImageub[] = "glGetTexImageub(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImageb[] = "glGetTexImageb(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImageus[] = "glGetTexImageus(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImages[] = "glGetTexImages(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImageui[] = "glGetTexImageui(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImagei[] = "glGetTexImagei(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImagef[] = "glGetTexImagef(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexImaged[] = "glGetTexImagef(target, level, format) -> pixels[][] | pixels[][][]";
 static char _doc_glGetTexLevelParameterfv[] = "glGetTexLevelParameterfv(target, level, pname) -> params";
 static char _doc_glGetTexLevelParameteriv[] = "glGetTexLevelParameteriv(target, level, pname) -> params";
 static char _doc_glGetTexParameterfv[] = "glGetTexParameterfv(target, pname) -> params";
 static char _doc_glGetTexParameteriv[] = "glGetTexParameteriv(target, pname) -> params";
 static char _doc_glHint[] = "glHint(target, mode) -> None";
 static char _doc_glIndexMask[] = "glIndexMask(mask) -> None";

void _glIndexPointer(GLenum type, GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_INDEX_ARRAY_POINTER);
	acquire(pointer);
	glIndexPointer(type, stride, pointer);
}
 static char _doc_glIndexPointer[] = "glIndexPointer(type, stride, pointer) -> None";
 static char _doc_glIndexPointerub[] = "glIndexPointerub(pointer[]) -> None";
 static char _doc_glIndexPointerb[] = "glIndexPointerub(pointer[]) -> None";
 static char _doc_glIndexPointers[] = "glIndexPointers(pointer[]) -> None";
 static char _doc_glIndexPointeri[] = "glIndexPointeri(pointer[]) -> None";
 static char _doc_glIndexPointerf[] = "glIndexPointerf(pointer[]) -> None";
 static char _doc_glIndexPointerd[] = "glIndexPointerd(pointer[]) -> None";
 static char _doc_glInitNames[] = "glInitNames() -> None";

#ifndef GL_SUN_triangle_list
#define GL_R1UI_V3F_SUN 0x85C4
#define GL_R1UI_C4UB_V3F_SUN 0x85C5
#define GL_R1UI_C3F_V3F_SUN 0x85C6
#define GL_R1UI_N3F_V3F_SUN 0x85C7
#define GL_R1UI_C4F_N3F_V3F_SUN 0x85C8
#define GL_R1UI_T2F_V3F_SUN 0x85C9
#define GL_R1UI_T2F_N3F_V3F_SUN 0x85CA
#define GL_R1UI_T2F_C4F_N3F_V3F_SUN 0x85CB

#define GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN 0x85C3
#endif

#ifndef GL_EXT_index_array_formats
#define GL_IUI_V2F_EXT                    0x81AD
#define GL_IUI_V3F_EXT                    0x81AE
#define GL_IUI_N3F_V2F_EXT                0x81AF
#define GL_IUI_N3F_V3F_EXT                0x81B0
#define GL_T2F_IUI_V2F_EXT                0x81B1
#define GL_T2F_IUI_V3F_EXT                0x81B2
#define GL_T2F_IUI_N3F_V2F_EXT            0x81B3
#define GL_T2F_IUI_N3F_V3F_EXT            0x81B4
#endif

void _glInterleavedArrays(GLenum format, GLsizei stride, GLvoid *pointer)
{
	GLenum p[POINTER_COUNT];
	
	decrementPointerLock(p[0] = GL_VERTEX_ARRAY_POINTER);
	
	switch (format)
	{
	case GL_C3F_V3F:
	case GL_C4F_N3F_V3F:
	case GL_C4UB_V2F:
	case GL_C4UB_V3F:
	case GL_T2F_C3F_V3F:
	case GL_T2F_C4F_N3F_V3F:
	case GL_T2F_C4UB_V3F:
	case GL_T4F_C4F_N3F_V4F:
	case GL_R1UI_C4UB_V3F_SUN:
	case GL_R1UI_C3F_V3F_SUN:
	case GL_R1UI_C4F_N3F_V3F_SUN:
	case GL_R1UI_T2F_C4F_N3F_V3F_SUN:
		decrementPointerLock(p[1] = GL_COLOR_ARRAY_POINTER);
		break;
	default:
		p[1] = 0;
	}

	switch (format)
	{
	case GL_N3F_V3F:
	case GL_C4F_N3F_V3F:
	case GL_T2F_N3F_V3F:
	case GL_T2F_C4F_N3F_V3F:
	case GL_T4F_C4F_N3F_V4F:
	case GL_R1UI_N3F_V3F_SUN:
	case GL_R1UI_C4F_N3F_V3F_SUN:
	case GL_R1UI_T2F_N3F_V3F_SUN:
	case GL_R1UI_T2F_C4F_N3F_V3F_SUN:
	case GL_IUI_N3F_V2F_EXT:
	case GL_IUI_N3F_V3F_EXT:
	case GL_T2F_IUI_N3F_V2F_EXT:
	case GL_T2F_IUI_N3F_V3F_EXT:
		decrementPointerLock(p[2] = GL_NORMAL_ARRAY_POINTER);
		break;
	default:
		p[2] = 0;
	}

	switch (format)
	{
	case GL_T2F_V3F:
	case GL_T4F_V4F:
	case GL_T2F_C4UB_V3F:
	case GL_T2F_C3F_V3F:
	case GL_T2F_N3F_V3F:
	case GL_T2F_C4F_N3F_V3F:
	case GL_T4F_C4F_N3F_V4F:
	case GL_R1UI_T2F_V3F_SUN:
	case GL_R1UI_T2F_N3F_V3F_SUN:
	case GL_R1UI_T2F_C4F_N3F_V3F_SUN:
	case GL_T2F_IUI_V2F_EXT:
	case GL_T2F_IUI_V3F_EXT:
	case GL_T2F_IUI_N3F_V2F_EXT:
	case GL_T2F_IUI_N3F_V3F_EXT:
		decrementPointerLock(p[3] = GL_TEXTURE_COORD_ARRAY_POINTER);
		break;
	default:
		p[3] = 0;
	}

	switch (format)
	{
	case GL_R1UI_V3F_SUN:
	case GL_R1UI_C4UB_V3F_SUN:
	case GL_R1UI_C3F_V3F_SUN:
	case GL_R1UI_N3F_V3F_SUN:
	case GL_R1UI_C4F_N3F_V3F_SUN:
	case GL_R1UI_T2F_V3F_SUN:
	case GL_R1UI_T2F_N3F_V3F_SUN:
	case GL_R1UI_T2F_C4F_N3F_V3F_SUN:
		decrementPointerLock(p[4] = GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN);
		break;
	default:
		p[4] = 0;
	}

	switch (format)
	{
	case GL_IUI_V2F_EXT:
	case GL_IUI_V3F_EXT:
	case GL_IUI_N3F_V2F_EXT:
	case GL_IUI_N3F_V3F_EXT:
	case GL_T2F_IUI_V2F_EXT:
	case GL_T2F_IUI_V3F_EXT:
	case GL_T2F_IUI_N3F_V2F_EXT:
	case GL_T2F_IUI_N3F_V3F_EXT:
		decrementPointerLock(p[5] = GL_INDEX_ARRAY_POINTER);
		break;
	default:
		p[5] = 0;
	}

	glInterleavedArrays(format, stride, pointer);
	acquireInterleavedPointer(pointer, p);
}
 static char _doc_glInterleavedArrays[] = "glInterleavedArrays(format, stride, pointer) -> None";
 static char _doc_glIsEnabled[] = "glIsEnabled(cap) -> None";
 static char _doc_glIsList[] = "glIsList(list) -> boolean";
 static char _doc_glIsTexture[] = "glIsTexture(texture) -> boolean";
 static char _doc_glLightModelf[] = "glLightModelf(pname, param) -> None";
 static char _doc_glLightModelfv[] = "glLightModelfv(pname, params) -> None";
 static char _doc_glLightModeli[] = "glLightModeli(pname, param) -> None";
 static char _doc_glLightModeliv[] = "glLightModeliv(pname, params) -> None";
 static char _doc_glLightf[] = "glLightf(light, pname, param) -> None";
 static char _doc_glLightfv[] = "glLightfv(light, pname, params) -> None";
 static char _doc_glLighti[] = "glLighti(light, pname, param) -> None";
 static char _doc_glLightiv[] = "glLightiv(light, pname, params) -> None";
 static char _doc_glLineStipple[] = "glLineStipple(factor, pattern) -> None";
 static char _doc_glLineWidth[] = "glLineWidth(width) -> None";
 static char _doc_glListBase[] = "glListBase(base) -> None";
 static char _doc_glLoadIdentity[] = "glLoadIdentity() -> None";
 static char _doc_glLoadMatrixd[] = "glLoadMatrixd(matrix) -> None";
 static char _doc_glLoadMatrixf[] = "glLoadMatrixf(matrix) -> None";
 static char _doc_glLoadName[] = "glLoadName(name) -> None";
 static char _doc_glLogicOp[] = "glLogicOp(opcode) -> None";
 static char _doc_glMap1d[] = "glMap1d(target, u1, u2, points[][]) -> None";
 static char _doc_glMap1f[] = "glMap1f(target, u1, u2, points[][]) -> None";

#define _glMap2d(target, u1, u2, uorder, v1, v2, vstride, vorder, points) glMap2d(target, u1, u2, vstride*vorder, uorder, v1, v2, vstride, vorder, points) 
 static char _doc_glMap2d[] = "glMap2d(target, u1, u2, v1, v2, points[][][]) -> None";

#define _glMap2f(target, u1, u2, uorder, v1, v2, vstride, vorder, points) glMap2f(target, u1, u2, vstride*vorder, uorder, v1, v2, vstride, vorder, points) 
 static char _doc_glMap2f[] = "glMap2f(target, u1, u2, v1, v2, points[][][]) -> None";
 static char _doc_glMapGrid1d[] = "glMapGrid1d(un, u1, u2) -> None";
 static char _doc_glMapGrid1f[] = "glMapGrid1f(un, u1, u2) -> None";
 static char _doc_glMapGrid2d[] = "glMapGrid2d(un, u1, u2, vn, v1, v2) -> None";
 static char _doc_glMapGrid2f[] = "glMapGrid2f(un, u1, u2, vn, v1, v2) -> None";
 static char _doc_glMatrixMode[] = "glMatrixMode(mode) -> None";
 static char _doc_glMultMatrixd[] = "glMultMatrixd(v) -> None";
 static char _doc_glMultMatrixf[] = "glMultMatrixf(v) -> None";
 static char _doc_glNewList[] = "glNewList(list, mode) -> None";

void _glNormalPointer(GLenum type, GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_NORMAL_ARRAY_POINTER);
	acquire(pointer);
	glNormalPointer(type, stride, pointer);
}
 static char _doc_glNormalPointer[] = "glNormalPointer(size, type, stride, pointer) -> None";
 static char _doc_glNormalPointerb[] = "glNormalPointerub(pointer[][3]) -> None";
 static char _doc_glNormalPointers[] = "glNormalPointers(pointer[][3]) -> None";
 static char _doc_glNormalPointeri[] = "glNormalPointeri(pointer[][3]) -> None";
 static char _doc_glNormalPointerf[] = "glNormalPointerf(pointer[][3]) -> None";
 static char _doc_glNormalPointerd[] = "glNormalPointerd(pointer[][3]) -> None";
 static char _doc_glOrtho[] = "glOrtho(left, right, bottom, top, zNear, zFar) -> None";
 static char _doc_glPassThrough[] = "glPassThrough(token) -> None";
 static char _doc_glPixelMapfv[] = "glPixelMapfv(map, values) -> None";
 static char _doc_glPixelMapuiv[] = "glPixelMapuiv(map, values) -> None";
 static char _doc_glPixelMapusv[] = "glPixelMapusv(map, values) -> None";
 static char _doc_glPixelStoref[] = "glPixelStoref(pname, param) -> None";
 static char _doc_glPixelStorei[] = "glPixelStorei(pname, param) -> None";
 static char _doc_glPixelTransferf[] = "glPixelTransferf(name, param) -> None";
 static char _doc_glPixelTransferi[] = "glPixelTransferi(name, param) -> None";
 static char _doc_glPixelZoom[] = "glPixelZoom(xfactor, yfactor) -> None";
 static char _doc_glPointSize[] = "glPointSize(size) -> None";
 static char _doc_glPolygonMode[] = "glPolygonMode(face, mode) -> None";
 static char _doc_glPolygonOffset[] = "glPolygonOffset(factor, units) -> None";
 static char _doc_glPolygonStipple[] = "glPolygonStipple(mask) -> None";

void glPolygonStippleub (const GLubyte *mask)
{
	GLubyte packed[128];
	int i, j;
	
	glPixelStorei(GL_UNPACK_SWAP_BYTES, 0);
	glPixelStorei(GL_UNPACK_LSB_FIRST, 1);

	for (i = 0; i < 128; i++)
	{
		packed[i] = 0;
		for (j = 0; j < 8; j++) packed[i] += mask[8*i + j] << j;
	}
	
	glPolygonStipple(packed);
}
 static char _doc_glPolygonStippleub[] = "glPolygonStippleub(mask[][]) -> None";
 static char _doc_glPopAttrib[] = "glPopAttrib() -> None";

void _glPopClientAttrib()
{
	decrementAllLocks();
	glPopClientAttrib();
}
 static char _doc_glPopClientAttrib[] = "glPopClientAttrib() -> None";
 static char _doc_glPopMatrix[] = "glPopMatrix() -> None";
 static char _doc_glPopName[] = "glPopName() -> None";
 static char _doc_glPrioritizeTextures[] = "glPrioritizeTextures(textures[], priorities[]) -> None";
 static char _doc_glPushAttrib[] = "glPushAttrib(mask) -> None";

#ifndef GL_CLIENT_VERTEX_ARRAY_BIT
#define GL_CLIENT_VERTEX_ARRAY_BIT        0x00000002
#endif

void _glPushClientAttrib (GLbitfield mask)
{
	mask |= GL_CLIENT_VERTEX_ARRAY_BIT;

	incrementAllLocks();
	glPushClientAttrib(mask);
}

 static char _doc_glPushClientAttrib[] = "glPushClientAttrib(mask) -> None";
 static char _doc_glPushMatrix[] = "glPushMatrix() -> None";
 static char _doc_glPushName[] = "glPushName(name) -> None";
 static char _doc_glRasterPos2d[] = "glRasterPos2d(x, y) -> None";
 static char _doc_glRasterPos2dv[] = "glRasterPos2dv(v) -> None";
 static char _doc_glRasterPos2f[] = "glRasterPos2f(x, y) -> None";
 static char _doc_glRasterPos2fv[] = "glRasterPos2fv(v) -> None";
 static char _doc_glRasterPos2i[] = "glRasterPos2i(x, y) -> None";
 static char _doc_glRasterPos2iv[] = "glRasterPos2iv(v) -> None";
 static char _doc_glRasterPos2s[] = "glRasterPos2s(x, y) -> None";
 static char _doc_glRasterPos2sv[] = "glRasterPos2sv(v) -> None";
 static char _doc_glRasterPos3d[] = "glRasterPos3d(x, y, z) -> None";
 static char _doc_glRasterPos3dv[] = "glRasterPos3dv(v) -> None";
 static char _doc_glRasterPos3f[] = "glRasterPos3f(x, y, z) -> None";
 static char _doc_glRasterPos3fv[] = "glRasterPos3fv(v) -> None";
 static char _doc_glRasterPos3i[] = "glRasterPos3i(x, y, z) -> None";
 static char _doc_glRasterPos3iv[] = "glRasterPos3iv(v) -> None";
 static char _doc_glRasterPos3s[] = "glRasterPos3s(x, y, z) -> None";
 static char _doc_glRasterPos3sv[] = "glRasterPos3sv(v) -> None";
 static char _doc_glRasterPos4d[] = "glRasterPos4d(x, y, z, w) -> None";
 static char _doc_glRasterPos4dv[] = "glRasterPos4dv(v) -> None";
 static char _doc_glRasterPos4f[] = "glRasterPos4f(x, y, z, w) -> None";
 static char _doc_glRasterPos4fv[] = "glRasterPos4fv(v) -> None";
 static char _doc_glRasterPos4i[] = "glRasterPos4i(x, y, z, w) -> None";
 static char _doc_glRasterPos4iv[] = "glRasterPos4iv(v) -> None";
 static char _doc_glRasterPos4s[] = "glRasterPos4s(x, y, z, w) -> None";
 static char _doc_glRasterPos4sv[] = "glRasterPos4sv(v) -> None";
 static char _doc_glReadBuffer[] = "glReadBuffer(mode) -> None";

PyObject* _glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type)
{
	PyObject* result;
	int size;
	GLint dims[2];
	void* data = NULL;
	
	dims[0] = width;
	dims[1] = height;
	data = SetupRawPixelRead(format, type, 2, dims, &size);
	if (!data) return NULL;
	
	glReadPixels(x, y, width, height, format, type, data);
	result = PyString_FromStringAndSize((const char*)data, size);
	PyMem_Del(data);

	return result;
}
 static char _doc_glReadPixels[] = "glReadPixels(x, y, width, height, format, type) -> pixels";

PyObject* __glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type)
{
	int dims[3];
	void* data;

	dims[0] = width;
	dims[1] = height;

	data = SetupPixelRead(2, format, type, dims);
	if (!data) return NULL;

	glReadPixels(x, y, width, height, format, type, data);
	
	return _PyObject_FromArray(type, (dims[2] == 1) ? 2 : 3, dims, data, 1);
}
 static char _doc_glReadPixelsub[] = "glReadPixelsub(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsb[] = "glReadPixelsb(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsus[] = "glReadPixelsus(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelss[] = "glReadPixelss(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsui[] = "glReadPixelsui(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsi[] = "glReadPixelsi(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsf[] = "glReadPixelsf(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glReadPixelsd[] = "glReadPixelsd(x, y, width, height, format) -> pixels[][] | pixels[][][]";
 static char _doc_glRectd[] = "glRectd(x1, y1, x2, y2) -> None";
 static char _doc_glRectdv[] = "glRectdv(p1, p2) -> None";
 static char _doc_glRectf[] = "glRectf(x1, y1, x2, y2) -> None";
 static char _doc_glRectfv[] = "glRectfv(p1, p2) -> None";
 static char _doc_glRecti[] = "glRecti(x1, y1, x2, y2) -> None";
 static char _doc_glRectiv[] = "glRectiv(p1, p2) -> None";
 static char _doc_glRects[] = "glRects(x1, y1, x2, y2) -> None";
 static char _doc_glRectsv[] = "glRectsv(p1, p2) -> None";

typedef struct
{
	PyObject_HEAD
	GLint count;
	GLint vertex_len;
	GLfloat* buffer;
	GLint* pos;
} PyFeedbackBuffer;


static int PyFeedbackBuffer_Length(PyObject *self)
{
	return ((PyFeedbackBuffer*)self)->count;
}


static PyObject *PyFeedbackBuffer_GetItem(PyObject *self, int i)
{
	PyObject *result;
	int pos = ((PyFeedbackBuffer*)self)->pos[i], dims[2];
	GLenum token;
	GLint vertex_count;
	
	if (i < 0) i += ((PyFeedbackBuffer*)self)->count;

	/* Throw an exception if index is out of bounds */
	if (i < 0 || i >= ((PyFeedbackBuffer*)self)->count)
	{
		PyErr_SetString(PyExc_IndexError, "Index out of range.");
		return NULL;
	}

	result = PyTuple_New(2);
	PyTuple_SetItem(result, 0, PyLong_FromUnsignedLong(token = (GLenum)((PyFeedbackBuffer*)self)->buffer[pos++]));
	if (token == GL_PASS_THROUGH_TOKEN)
	{
		/* pass through has a single value */
		PyTuple_SetItem(result, 1, PyFloat_FromDouble(((PyFeedbackBuffer*)self)->buffer[pos]));
	}
	else
	{
		/* figure out how many vertices there are */
		switch (token)
		{
		case GL_POINT_TOKEN:
		case GL_BITMAP_TOKEN:
		case GL_DRAW_PIXEL_TOKEN:
		case GL_COPY_PIXEL_TOKEN:
			vertex_count = 1;
			break;
		case GL_LINE_TOKEN:
		case GL_LINE_RESET_TOKEN:
			vertex_count = 2;
			break;
		case GL_POLYGON_TOKEN:
			vertex_count = (GLint)((PyFeedbackBuffer*)self)->buffer[pos++];
			break;
		default:
			Py_DECREF(result);
			PyErr_SetString(PyExc_Exception, "Unknown token found in feedback buffer.");
			return NULL;
		}
		
		dims[0] = vertex_count;
		dims[1] = ((PyFeedbackBuffer*)self)->vertex_len;
		PyTuple_SetItem(result, 1, _PyObject_FromFloatArray(2, dims, ((PyFeedbackBuffer*)self)->buffer + pos, 0));
	}

	return result;
}


static void PyFeedbackBuffer_Del(PyObject *self)
{
	PyMem_Del(((PyFeedbackBuffer*)self)->buffer);
	PyMem_Del(((PyFeedbackBuffer*)self)->pos);
    PyObject_Del(self);
}


static PySequenceMethods PyFeedbackBuffer_SequenceMethods =
{
    PyFeedbackBuffer_Length,	/* sq_length */
    NULL,						/* nb_add */
    NULL,						/* nb_multiply */
    PyFeedbackBuffer_GetItem,	/* sq_item */
};


PyTypeObject PyFeedbackBuffer_Type =
{
    PyObject_HEAD_INIT(0)
    0,									/* ob_size */
    "FeedbackBuffer",					/* tp_name */
    sizeof(PyFeedbackBuffer),			/* tp_basicsize */
    0,									/* tp_itemsize */
    PyFeedbackBuffer_Del,				/* tp_dealloc */
    NULL,								/* tp_print */
    NULL,								/* tp_getattr */
    NULL,								/* tp_setattr */
    NULL,								/* tp_compare */
    NULL,								/* tp_repr */
    NULL,								/* tp_as_number */
    &PyFeedbackBuffer_SequenceMethods,	/* tp_as_sequence */
};


PyObject* PyFeedbackBuffer_New(GLint value_count)
{
	int len;
	GLboolean rgba_mode;
	GLenum type;
	PyFeedbackBuffer *result = PyObject_NEW(PyFeedbackBuffer, &PyFeedbackBuffer_Type);
	
	/* Get the buffer type and color mode so we can calculate the length of a vertex */
#ifdef GL_VERSION_1_1
	glGetPointerv(GL_FEEDBACK_BUFFER_POINTER, (void**)&result->buffer);
	glGetIntegerv(GL_FEEDBACK_BUFFER_TYPE, (GLint*)&type);
#else
	PyGLcontext *context = GetGLcontext();
	result->buffer = context->feedback_buffer;
	type = context->feedback_type;
#endif
	glGetBooleanv(GL_RGBA_MODE, &rgba_mode);
	glFeedbackBuffer(0, type, NULL);

	/* glRenderMode returns the actual length of the buffer not the number of elements */
	result->pos = NULL;

	/* Calculate the length of a vertex */
	#define COLOR_LEN ((rgba_mode) ? 4 : 1)

	switch (type)
	{
	case GL_2D:
		result->vertex_len = 2;
		break;
	case GL_3D:
		result->vertex_len = 3;
		break;
	case GL_3D_COLOR:
		result->vertex_len = 3 + COLOR_LEN;
		break;
	case GL_3D_COLOR_TEXTURE:
		result->vertex_len = 7 + COLOR_LEN;
		break;
	case GL_4D_COLOR_TEXTURE:
		result->vertex_len = 8 + COLOR_LEN;
		break;
	default:
		Py_DECREF(result);
		PyErr_SetString(PyExc_Exception, "Unknown vertex type in feedback buffer.");
		return NULL;
	}

	/* Go through the buffer and find the position of each item */
	for (len = 0; len < value_count;)
	{
		if (result->pos) result->pos = PyMem_Resize(result->pos, GLint, ++result->count); else result->pos = PyMem_New(GLint, result->count = 1);

		result->pos[result->count-1] = len;

		switch ((GLenum)result->buffer[len++])
		{
		case GL_POINT_TOKEN:
		case GL_BITMAP_TOKEN:
		case GL_DRAW_PIXEL_TOKEN:
		case GL_COPY_PIXEL_TOKEN:
			len += result->vertex_len;
			break;
		case GL_LINE_TOKEN:
		case GL_LINE_RESET_TOKEN:
			len += 2*result->vertex_len;
			break;
		case GL_POLYGON_TOKEN:
			len += (int)result->buffer[len++]*result->vertex_len;
			break;
		case GL_PASS_THROUGH_TOKEN:
			len++;
			break;
		default:
			Py_DECREF(result);
			PyErr_SetString(PyExc_Exception, "Unknown token found in feedback buffer.");
			return NULL;
		};
	}
	
	
	return (PyObject*)result;
}


typedef struct
{
	PyObject_HEAD
	GLint count;
	GLuint* buffer;
	GLint* pos;
} PySelectBuffer;


static int PySelectBuffer_Length(PyObject *self)
{
	return ((PySelectBuffer*)self)->count;
}


static PyObject *PySelectBuffer_GetItem(PyObject *self, int i)
{
	PyObject *result, *names;
	int pos = ((PySelectBuffer*)self)->pos[i], j;
	GLint name_count;
	
	if (i < 0) i += ((PySelectBuffer*)self)->count;

	/* Throw an exception if out of bounds */
	if (i < 0 || i >= ((PySelectBuffer*)self)->count)
	{
		PyErr_SetString(PyExc_IndexError, "Index out of range.");
		return NULL;
	}

	/* Create the element */
	result = PyTuple_New(3);

	PyTuple_SetItem(result, 2, names = PyTuple_New(name_count = ((PySelectBuffer*)self)->buffer[pos++]));

	PyTuple_SetItem(result, 0, PyLong_FromUnsignedLong(((PySelectBuffer*)self)->buffer[pos++]));
	PyTuple_SetItem(result, 1, PyLong_FromUnsignedLong(((PySelectBuffer*)self)->buffer[pos++]));
		
	for (j = 0; j < name_count; j++, pos++) PyTuple_SetItem(names, j, PyLong_FromUnsignedLong(((PySelectBuffer*)self)->buffer[pos]));
	
	return result;
}


static void PySelectBuffer_Del(PyObject *self)
{
	PyMem_Del(((PySelectBuffer*)self)->buffer);
	PyMem_Del(((PySelectBuffer*)self)->pos);
    PyObject_Del(self);
}


static PySequenceMethods PySelectBuffer_SequenceMethods =
{
    PySelectBuffer_Length,		/* sq_length */
    NULL,						/* nb_add */
    NULL,						/* nb_multiply */
    PySelectBuffer_GetItem,		/* sq_item */
};


PyTypeObject PySelectBuffer_Type =
{
    PyObject_HEAD_INIT(0)
    0,									/* ob_size */
    "SelectBuffer",						/* tp_name */
    sizeof(PySelectBuffer),				/* tp_basicsize */
    0,									/* tp_itemsize */
    PySelectBuffer_Del,					/* tp_dealloc */
    NULL,								/* tp_print */
    NULL,								/* tp_getattr */
    NULL,								/* tp_setattr */
    NULL,								/* tp_compare */
    NULL,								/* tp_repr */
    NULL,								/* tp_as_number */
    &PySelectBuffer_SequenceMethods,	/* tp_as_sequence */
};

/* Work around for GL bug (Microsoft?) */
static GLuint null_select_buffer[1];


PyObject* PySelectBuffer_New(GLint count)
{
	int len, i;
	PySelectBuffer *result = PyObject_NEW(PySelectBuffer, &PySelectBuffer_Type);
	
#ifdef GL_VERSION_1_1
	glGetPointerv(GL_SELECTION_BUFFER_POINTER, (void**)&result->buffer);
#else
	PyGLcontext *context = GetGLcontext();
	result->buffer = context->selection_buffer;
	context->selection_buffer = null_select_buffer;
#endif
	glSelectBuffer(0, null_select_buffer);

	result->count = count;
	result->pos = PyMem_New(GLint, count);

	/* Go through the buffer and find the location of each item, so random access is possible */
	/* Calculate the total length at the same time */
	for (len = i = 0; i < count; i++)
	{
		result->pos[i] = len;
		len += 3 + result->buffer[len];
	}
	
	return (PyObject*)result;
}

PyObject* _glRenderMode (GLenum mode)
{
	GLint previous_mode, count;

	glGetIntegerv(GL_RENDER_MODE, &previous_mode);
	count = glRenderMode(mode);
	
	/* count == -1 means that there wasn't enough space in the buffer */
	/* Sould this be an exception? */
	if (count > -1) switch (previous_mode)
	{
	case GL_SELECT:
		return PySelectBuffer_New(count);
	case GL_FEEDBACK:
		return PyFeedbackBuffer_New(count);
	}
	
	Py_INCREF(Py_None);
	return Py_None;
}
 static char _doc_glRenderMode[] = "glRenderMode(mode) -> None | FeedbackBuffer | SelectBuffer";
 static char _doc_glRotated[] = "glRotated(angle, x, y, z) -> None";
 static char _doc_glRotatef[] = "glRotatef(angle, x, y, z) -> None";
 static char _doc_glScaled[] = "glScaled(x, y, z) -> None";
 static char _doc_glScalef[] = "glScalef(x, y, z) -> None";
 static char _doc_glScissor[] = "glScissor(x, y, width, height) -> None";

void _glSelectBuffer(GLsizei size)
{
	GLuint *buffer = (size > 0) ? PyMem_New(GLuint, size) : null_select_buffer;
#ifndef GL_VERSION_1_1
	PyGLcontext *context = GetGLcontext();
	context->selection_buffer = buffer;
#endif
	glSelectBuffer(size, buffer);
}
 static char _doc_glSelectBuffer[] = "glSelectBuffer(size) -> None";
 static char _doc_glShadeModel[] = "glShadeModel(mode) -> None";
 static char _doc_glStencilFunc[] = "glStencilFunc(func, ref, mask) -> None";
 static char _doc_glStencilMask[] = "glStencilMask(mask) -> None";
 static char _doc_glStencilOp[] = "glStencilOp(fail, zfail, zpass) -> None";

void _glTexCoordPointer(GLint size, GLenum type, GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_TEXTURE_COORD_ARRAY);
	acquire(pointer);
	glTexCoordPointer(size, type, stride, pointer);
}
 static char _doc_glTexCoordPointer[] = "glTexCoordPointer(size, type, stride, pointer) -> None";
 static char _doc_glTexCoordPointerb[] = "glTexCoordPointerub(pointer[][]) -> None";
 static char _doc_glTexCoordPointers[] = "glTexCoordPointers(pointer[][]) -> None";
 static char _doc_glTexCoordPointeri[] = "glTexCoordPointeri(pointer[][]) -> None";
 static char _doc_glTexCoordPointerf[] = "glTexCoordPointerf(pointer[][]) -> None";
 static char _doc_glTexCoordPointerd[] = "glTexCoordPointerd(pointer[][]) -> None";
 static char _doc_glTexEnvf[] = "glTexEnvf(target, pname, param) -> None";
 static char _doc_glTexEnvfv[] = "glTexEnvfv(target, pname, v) -> None";
 static char _doc_glTexEnvi[] = "glTexEnvi(target, pname, param) -> None";
 static char _doc_glTexEnviv[] = "glTexEnviv(target, pname, v) -> None";
 static char _doc_glTexGend[] = "glTexGend(coord, pname, param) -> None";
 static char _doc_glTexGendv[] = "glTexGendv(coord, pname, v) -> None";
 static char _doc_glTexGenf[] = "glTexGenf(coord, pname, param) -> None";
 static char _doc_glTexGenfv[] = "glTexGenfv(coord, pname, v) -> None";
 static char _doc_glTexGeni[] = "glTexGeni(coord, pname, param) -> None";
 static char _doc_glTexGeniv[] = "glTexGeniv(coord, pname, v) -> None";
 static char _doc_glTexImage1D[] = "glTexImage1D(target, level, internalFormat, width, border, format, type, pixels) -> None";

void _glTexImage1D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid* pixels)
{
	SetupPixelWrite(1);
	glTexImage1D(target, level, internalFormat, width, border, format, type, pixels);
}
 static char _doc_glTexImage1Dub[] = "glTexImage1Dub(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Db[] = "glTexImage1Db(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Dus[] = "glTexImage1Dus(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Ds[] = "glTexImage1Ds(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Dui[] = "glTexImage1Dui(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Di[] = "glTexImage1Di(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage1Df[] = "glTexImage1Df(target, level, internalFormat, border, format, pixels[] | pixels[][]) -> None";
 static char _doc_glTexImage2D[] = "glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) -> None";

void _glTexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid* pixels)
{
	SetupPixelWrite(2);
	glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
}
 static char _doc_glTexImage2Dub[] = "glTexImage2Dub(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Db[] = "glTexImage2Db(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Dus[] = "glTexImage2Dus(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Ds[] = "glTexImage2Ds(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Dui[] = "glTexImage2Dui(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Di[] = "glTexImage2Di(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexImage2Df[] = "glTexImage2Df(target, level, internalFormat, border, format, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexParameterf[] = "glTexParameterf(target, pname, param) -> None";
 static char _doc_glTexParameterfv[] = "glTexParameterfv(target, pname, v) -> None";
 static char _doc_glTexParameteri[] = "glTexParameteri(target, pname, param) -> None";
 static char _doc_glTexParameteriv[] = "glTexParameteriv(target, pname, v) -> None";
 static char _doc_glTexSubImage1D[] = "glTexSubImage1D(target, level, xoffset, width, format, type, pixels) -> None";

void _glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid* pixels)
{
	SetupPixelWrite(1);
	glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
}
 static char _doc_glTexSubImage1Dub[] = "glTexSubImage1Dub(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Db[] = "glTexSubImage1Db(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Dus[] = "glTexSubImage1Dus(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Ds[] = "glTexSubImage1Ds(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Dui[] = "glTexSubImage1Dui(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Di[] = "glTexSubImage1Di(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage1Df[] = "glTexSubImage1Df(target, level, xoffset, format, type, pixels[] | pixels[][]) -> None";
 static char _doc_glTexSubImage2D[] = "glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) -> None";

void _glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* pixels)
{
	SetupPixelWrite(2);
	glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}
 static char _doc_glTexSubImage2Dub[] = "glTexSubImage2Dub(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Db[] = "glTexSubImage2Db(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Dus[] = "glTexSubImage2Dus(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Ds[] = "glTexSubImage2Ds(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Dui[] = "glTexSubImage2Dui(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Di[] = "glTexSubImage2Di(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTexSubImage2Df[] = "glTexSubImage2Df(target, level, xoffset, yoffset, format, type, pixels[][] | pixels[][][]) -> None";
 static char _doc_glTranslated[] = "glTranslated(x, y, z) -> None";
 static char _doc_glTranslatef[] = "glTranslatef(x, y, z) -> None";

void _glVertexPointer(GLint size, GLenum type, GLsizei stride, GLvoid *pointer)
{
	decrementPointerLock(GL_VERTEX_ARRAY_POINTER);
	acquire(pointer);
	glVertexPointer(size, type, stride, pointer);
}
 static char _doc_glVertexPointer[] = "glVertexPointer(size, type, stride, pointer) -> None";
 static char _doc_glVertexPointerb[] = "glVertexPointerub(pointer[][]) -> None";
 static char _doc_glVertexPointers[] = "glVertexPointers(pointer[][]) -> None";
 static char _doc_glVertexPointeri[] = "glVertexPointeri(pointer[][]) -> None";
 static char _doc_glVertexPointerf[] = "glVertexPointerf(pointer[][]) -> None";
 static char _doc_glVertexPointerd[] = "glVertexPointerd(pointer[][]) -> None";
 static char _doc_glViewport[] = "glViewport(x, y, width, height) -> None";
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_glArrayElement(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glArrayElement",&arg0)) return NULL;
    {
        glArrayElement(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glBegin(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glBegin",&arg0)) return NULL;
    {
        glBegin(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCallList(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glCallList",&arg0)) return NULL;
    {
        glCallList(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCallLists(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLenum arg1 ;
    GLuint *arg2 ;
    PyObject *temp_lists ;
    PyObject * obj2  = 0 ;
    
    {
    }
    {
        arg1 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"O:glCallLists",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsUnsignedIntArray(obj2, &temp_lists, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_AsArray_Size(obj2); 
    }
    {
        glCallLists(arg0,arg1,(GLuint const *)arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_lists); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3b(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte arg0 ;
    GLbyte arg1 ;
    GLbyte arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glColor3b",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLbyte ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLbyte ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLbyte ) PyString_AsString(obj2)[0];
	}
}
{ 	glColor3b(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3bv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3bv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsCharArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3bv((GLbyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glColor3d",&arg0,&arg1,&arg2)) return NULL;
    {
        glColor3d(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glColor3f",&arg0,&arg1,&arg2)) return NULL;
    {
        glColor3f(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glColor3i",&arg0,&arg1,&arg2)) return NULL;
    {
        glColor3i(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glColor3s",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{ 	glColor3s(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3ub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte arg0 ;
    GLubyte arg1 ;
    GLubyte arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glColor3ub",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLubyte ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLubyte ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLubyte ) PyString_AsString(obj2)[0];
	}
}
{ 	glColor3ub(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3ubv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3ubv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedCharArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3ubv((GLubyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3ui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLuint arg1 ;
    GLuint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glColor3ui",&arg0,&arg1,&arg2)) return NULL;
    {
        glColor3ui(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3uiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3uiv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedIntArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3uiv((GLuint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor3us(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLushort arg0 ;
    GLushort arg1 ;
    GLushort arg2 ;
    
    if(!PyArg_ParseTuple(args,"hhh:glColor3us",&arg0,&arg1,&arg2)) return NULL;
    {
        glColor3us(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor3usv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLushort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor3usv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedShortArray(obj0, &temp_v, NULL); 
    }
    {
        glColor3usv((GLushort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4b(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte arg0 ;
    GLbyte arg1 ;
    GLbyte arg2 ;
    GLbyte arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glColor4b",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLbyte ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLbyte ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLbyte ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLbyte ) PyString_AsString(obj3)[0];
        }
    }
    {
        glColor4b(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4bv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4bv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsCharArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4bv((GLbyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glColor4d",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glColor4d(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glColor4f",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glColor4f(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glColor4i",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glColor4i(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    GLshort arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glColor4s",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLshort ) PyString_AsString(obj3)[0];
        }
    }
    {
        glColor4s(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4ub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte arg0 ;
    GLubyte arg1 ;
    GLubyte arg2 ;
    GLubyte arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glColor4ub",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLubyte ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLubyte ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLubyte ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLubyte ) PyString_AsString(obj3)[0];
        }
    }
    {
        glColor4ub(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4ubv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4ubv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedCharArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4ubv((GLubyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4ui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLuint arg1 ;
    GLuint arg2 ;
    GLuint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glColor4ui",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glColor4ui(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4uiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4uiv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedIntArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4uiv((GLuint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glColor4us(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLushort arg0 ;
    GLushort arg1 ;
    GLushort arg2 ;
    GLushort arg3 ;
    
    if(!PyArg_ParseTuple(args,"hhhh:glColor4us",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glColor4us(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColor4usv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLushort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glColor4usv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedShortArray(obj0, &temp_v, NULL); 
    }
    {
        glColor4usv((GLushort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glEdgeFlag(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLboolean arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEdgeFlag",&obj0)) return NULL;
    {
        arg0 = (PyObject_IsTrue(obj0)) ? GL_TRUE : GL_FALSE;
    }
    {
        glEdgeFlag(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEdgeFlagv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLboolean *arg0 ;
    PyObject *temp_flag ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEdgeFlagv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedCharArray(obj0, &temp_flag, NULL); 
    }
    {
        glEdgeFlagv((GLboolean const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_flag); 
    }
    return resultobj;
}


static PyObject *_wrap_glEvalCoord1d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    
    if(!PyArg_ParseTuple(args,"d:glEvalCoord1d",&arg0)) return NULL;
    {
        glEvalCoord1d(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalCoord1dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEvalCoord1dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glEvalCoord1dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glEvalCoord1f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glEvalCoord1f",&arg0)) return NULL;
    {
        glEvalCoord1f(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalCoord1fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEvalCoord1fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glEvalCoord1fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glEvalCoord2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    
    if(!PyArg_ParseTuple(args,"dd:glEvalCoord2d",&arg0,&arg1)) return NULL;
    {
        glEvalCoord2d(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalCoord2dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEvalCoord2dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glEvalCoord2dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glEvalCoord2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glEvalCoord2f",&arg0,&arg1)) return NULL;
    {
        glEvalCoord2f(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalCoord2fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glEvalCoord2fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glEvalCoord2fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glEvalPoint1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glEvalPoint1",&arg0)) return NULL;
    {
        glEvalPoint1(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalPoint2(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glEvalPoint2",&arg0,&arg1)) return NULL;
    {
        glEvalPoint2(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    
    if(!PyArg_ParseTuple(args,"d:glIndexd",&arg0)) return NULL;
    {
        glIndexd(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexdv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_c ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexdv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_c, NULL); 
    }
    {
        glIndexdv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_c); 
    }
    return resultobj;
}


static PyObject *_wrap_glIndexf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glIndexf",&arg0)) return NULL;
    {
        glIndexf(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_c ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexfv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_c, NULL); 
    }
    {
        glIndexfv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_c); 
    }
    return resultobj;
}


static PyObject *_wrap_glIndexi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glIndexi",&arg0)) return NULL;
    {
        glIndexi(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_c ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexiv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_c, NULL); 
    }
    {
        glIndexiv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_c); 
    }
    return resultobj;
}


static PyObject *_wrap_glIndexs(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexs",&obj0)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
/* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{ 	glIndexs(arg0);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexsv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_c ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexsv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_c, NULL); 
    }
    {
        glIndexsv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_c); 
    }
    return resultobj;
}


static PyObject *_wrap_glIndexub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexub",&obj0)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLubyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
/* what is a GLshort's size? */
		arg0 = (GLubyte ) PyString_AsString(obj0)[0];
	}
}
{ 	glIndexub(arg0);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexubv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte *arg0 ;
    PyObject *temp_c ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glIndexubv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedCharArray(obj0, &temp_c, NULL); 
    }
    {
        glIndexubv((GLubyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_c); 
    }
    return resultobj;
}


static PyObject *_wrap_glMaterialf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iif:glMaterialf",&arg0,&arg1,&arg2)) return NULL;
    {
        glMaterialf(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMaterialfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_params ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glMaterialfv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_params, NULL); 
    }
    {
        glMaterialfv(arg0,arg1,(GLfloat const *)arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_params); 
    }
    return resultobj;
}


static PyObject *_wrap_glMateriali(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glMateriali",&arg0,&arg1,&arg2)) return NULL;
    {
        glMateriali(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMaterialiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint *arg2 ;
    PyObject *temp_params ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glMaterialiv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsIntArray(obj2, &temp_params, NULL); 
    }
    {
        glMaterialiv(arg0,arg1,(GLint const *)arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_params); 
    }
    return resultobj;
}


static PyObject *_wrap_glNormal3b(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte arg0 ;
    GLbyte arg1 ;
    GLbyte arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glNormal3b",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLbyte ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLbyte ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLbyte )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLbyte ) PyString_AsString(obj2)[0];
	}
}
{ 	glNormal3b(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormal3bv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbyte *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glNormal3bv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsCharArray(obj0, &temp_v, NULL); 
    }
    {
        glNormal3bv((GLbyte const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glNormal3d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glNormal3d",&arg0,&arg1,&arg2)) return NULL;
    {
        glNormal3d(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormal3dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glNormal3dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glNormal3dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glNormal3f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glNormal3f",&arg0,&arg1,&arg2)) return NULL;
    {
        glNormal3f(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormal3fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glNormal3fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glNormal3fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glNormal3i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glNormal3i",&arg0,&arg1,&arg2)) return NULL;
    {
        glNormal3i(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormal3iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glNormal3iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glNormal3iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glNormal3s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glNormal3s",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{ 	glNormal3s(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormal3sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glNormal3sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glNormal3sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord1d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    
    if(!PyArg_ParseTuple(args,"d:glTexCoord1d",&arg0)) return NULL;
    {
        glTexCoord1d(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord1dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord1dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord1dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord1f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glTexCoord1f",&arg0)) return NULL;
    {
        glTexCoord1f(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord1fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord1fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord1fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord1i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glTexCoord1i",&arg0)) return NULL;
    {
        glTexCoord1i(arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord1iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord1iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord1iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord1s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord1s",&obj0)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
/* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{ 	glTexCoord1s(arg0);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord1sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord1sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord1sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    
    if(!PyArg_ParseTuple(args,"dd:glTexCoord2d",&arg0,&arg1)) return NULL;
    {
        glTexCoord2d(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord2dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord2dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord2dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glTexCoord2f",&arg0,&arg1)) return NULL;
    {
        glTexCoord2f(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord2fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord2fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord2fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord2i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glTexCoord2i",&arg0,&arg1)) return NULL;
    {
        glTexCoord2i(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord2iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord2iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord2iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord2s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glTexCoord2s",&obj0,&obj1)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        glTexCoord2s(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord2sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord2sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord2sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord3d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glTexCoord3d",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexCoord3d(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord3dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord3dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord3dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord3f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glTexCoord3f",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexCoord3f(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord3fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord3fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord3fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord3i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glTexCoord3i",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexCoord3i(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord3iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord3iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord3iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord3s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glTexCoord3s",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{ 	glTexCoord3s(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord3sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord3sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord3sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord4d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glTexCoord4d",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glTexCoord4d(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord4dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord4dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord4dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord4f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glTexCoord4f",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glTexCoord4f(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord4fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord4fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord4fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord4i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glTexCoord4i",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glTexCoord4i(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord4iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord4iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord4iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoord4s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    GLshort arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glTexCoord4s",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLshort ) PyString_AsString(obj3)[0];
        }
    }
    {
        glTexCoord4s(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoord4sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glTexCoord4sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glTexCoord4sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    
    if(!PyArg_ParseTuple(args,"dd:glVertex2d",&arg0,&arg1)) return NULL;
    {
        glVertex2d(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex2dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex2dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex2dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glVertex2f",&arg0,&arg1)) return NULL;
    {
        glVertex2f(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex2fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex2fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex2fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex2i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glVertex2i",&arg0,&arg1)) return NULL;
    {
        glVertex2i(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex2iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex2iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex2iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex2s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glVertex2s",&obj0,&obj1)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        glVertex2s(arg0,arg1);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex2sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex2sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex2sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex3d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glVertex3d",&arg0,&arg1,&arg2)) return NULL;
    {
        glVertex3d(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex3dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex3dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex3dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex3f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glVertex3f",&arg0,&arg1,&arg2)) return NULL;
    {
        glVertex3f(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex3fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex3fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex3fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex3i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glVertex3i",&arg0,&arg1,&arg2)) return NULL;
    {
        glVertex3i(arg0,arg1,arg2);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex3iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex3iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex3iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex3s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glVertex3s",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{ 	glVertex3s(arg0,arg1,arg2);
 	if (PyErr_Occurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex3sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex3sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex3sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex4d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glVertex4d",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glVertex4d(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex4dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex4dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex4dv((GLdouble const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex4f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glVertex4f",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glVertex4f(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex4fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex4fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex4fv((GLfloat const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex4i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glVertex4i",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glVertex4i(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex4iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex4iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex4iv((GLint const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glVertex4s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    GLshort arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glVertex4s",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLshort ) PyString_AsString(obj3)[0];
        }
    }
    {
        glVertex4s(arg0,arg1,arg2,arg3);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertex4sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glVertex4sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glVertex4sv((GLshort const *)arg0);
        if (PyErr_Occurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap___has_extension(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"s:__has_extension",&arg0)) return NULL;
    {
        result = (int )has_extension((char const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_glAccum(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glAccum",&arg0,&arg1)) return NULL;
    {
        glAccum(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glAlphaFunc(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLclampf arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glAlphaFunc",&arg0,&arg1)) return NULL;
    {
        glAlphaFunc(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glAreTexturesResident(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLuint *arg1 ;
    PyObject *temp_textures ;
    PyObject * obj1  = 0 ;
    PyObject *result ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"O:glAreTexturesResident",&obj1)) return NULL;
    if (obj1)
    {
        arg1 = _PyObject_AsUnsignedIntArray(obj1, &temp_textures, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_AsArray_Size(obj1); 
    }
    {
        result = (PyObject *)_glAreTexturesResident(arg0,(GLuint const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    {
        _PyObject_AsArray_Cleanup(arg1, temp_textures); 
    }
    return resultobj;
}


static PyObject *_wrap_glBindTexture(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLuint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glBindTexture",&arg0,&arg1)) return NULL;
    {
        glBindTexture(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glBitmap(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    GLfloat arg4 ;
    GLfloat arg5 ;
    GLubyte *arg6 ;
    PyObject *temp_bitmap ;
    PyObject * obj6  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiffffO:glBitmap",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&obj6)) return NULL;
    {
        arg6 = _PyObject_AsUnsignedCharArray(obj6, &temp_bitmap, NULL); 
    }
    {
        glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,(GLubyte const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_bitmap); 
    }
    return resultobj;
}


static PyObject *_wrap_glBlendFunc(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glBlendFunc",&arg0,&arg1)) return NULL;
    {
        glBlendFunc(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClear(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbitfield arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glClear",&arg0)) return NULL;
    {
        glClear(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClearAccum(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glClearAccum",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glClearAccum(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClearColor(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLclampf arg0 ;
    GLclampf arg1 ;
    GLclampf arg2 ;
    GLclampf arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glClearColor",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glClearColor(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClearDepth(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLclampd arg0 ;
    
    if(!PyArg_ParseTuple(args,"d:glClearDepth",&arg0)) return NULL;
    {
        glClearDepth(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClearIndex(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glClearIndex",&arg0)) return NULL;
    {
        glClearIndex(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClearStencil(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glClearStencil",&arg0)) return NULL;
    {
        glClearStencil(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glClipPlane(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLdouble *arg1 ;
    PyObject *temp_equation ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glClipPlane",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsDoubleArray(obj1, &temp_equation, NULL); 
    }
    {
        glClipPlane(arg0,(GLdouble const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_equation); 
    }
    return resultobj;
}


static PyObject *_wrap_glColorMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLboolean arg0 ;
    GLboolean arg1 ;
    GLboolean arg2 ;
    GLboolean arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glColorMask",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        arg0 = (PyObject_IsTrue(obj0)) ? GL_TRUE : GL_FALSE;
    }
    {
        arg1 = (PyObject_IsTrue(obj1)) ? GL_TRUE : GL_FALSE;
    }
    {
        arg2 = (PyObject_IsTrue(obj2)) ? GL_TRUE : GL_FALSE;
    }
    {
        arg3 = (PyObject_IsTrue(obj3)) ? GL_TRUE : GL_FALSE;
    }
    {
        glColorMask(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColorMaterial(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glColorMaterial",&arg0,&arg1)) return NULL;
    {
        glColorMaterial(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glColorPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    void *arg3 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiO:glColorPointer",&arg0,&arg1,&arg2,&obj3)) return NULL;
    {
        arg3 = _PyObject_AsPointer(obj3);
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLubyte *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_UNSIGNED_BYTE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerub",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedCharArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLbyte *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_BYTE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerb",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsCharArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLushort *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_UNSIGNED_SHORT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerus",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedShortArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointers(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLshort *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_SHORT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointers",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsShortArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLuint *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_UNSIGNED_INT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerui",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedIntArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointeri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLint *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_INT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointeri",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsIntArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLfloat *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_FLOAT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerf",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsFloatArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glColorPointerd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLdouble *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_DOUBLE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glColorPointerd",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsDoubleArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glColorPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glCopyPixels(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    
    if(!PyArg_ParseTuple(args,"iiiii:glCopyPixels",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        glCopyPixels(arg0,arg1,arg2,arg3,arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCopyTexImage1D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLsizei arg5 ;
    GLint arg6 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiii:glCopyTexImage1D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6)) return NULL;
    {
        glCopyTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCopyTexImage2D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLsizei arg5 ;
    GLsizei arg6 ;
    GLint arg7 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiii:glCopyTexImage2D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7)) return NULL;
    {
        glCopyTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCopyTexSubImage1D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLsizei arg5 ;
    
    if(!PyArg_ParseTuple(args,"iiiiii:glCopyTexSubImage1D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        glCopyTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCopyTexSubImage2D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLint arg5 ;
    GLsizei arg6 ;
    GLsizei arg7 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiii:glCopyTexSubImage2D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7)) return NULL;
    {
        glCopyTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glCullFace(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glCullFace",&arg0)) return NULL;
    {
        glCullFace(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDeleteLists(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLsizei arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glDeleteLists",&arg0,&arg1)) return NULL;
    {
        glDeleteLists(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDeleteTextures(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLuint *arg1 ;
    PyObject *temp_textures ;
    PyObject * obj1  = 0 ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"O:glDeleteTextures",&obj1)) return NULL;
    if (obj1)
    {
        arg1 = _PyObject_AsUnsignedIntArray(obj1, &temp_textures, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_AsArray_Size(obj1); 
    }
    {
        glDeleteTextures(arg0,(GLuint const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_textures); 
    }
    return resultobj;
}


static PyObject *_wrap_glDepthFunc(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glDepthFunc",&arg0)) return NULL;
    {
        glDepthFunc(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDepthMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLboolean arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glDepthMask",&obj0)) return NULL;
    {
        arg0 = (PyObject_IsTrue(obj0)) ? GL_TRUE : GL_FALSE;
    }
    {
        glDepthMask(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDepthRange(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLclampd arg0 ;
    GLclampd arg1 ;
    
    if(!PyArg_ParseTuple(args,"dd:glDepthRange",&arg0,&arg1)) return NULL;
    {
        glDepthRange(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDisable(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glDisable",&arg0)) return NULL;
    {
        glDisable(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDisableClientState(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glDisableClientState",&arg0)) return NULL;
    {
        glDisableClientState(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDrawArrays(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glDrawArrays",&arg0,&arg1,&arg2)) return NULL;
    {
        glDrawArrays(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDrawBuffer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glDrawBuffer",&arg0)) return NULL;
    {
        glDrawBuffer(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDrawElements(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    void *arg3 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiO:glDrawElements",&arg0,&arg1,&arg2,&obj3)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj3 == Py_None) arg3 = NULL; else
        {
            str = PyObject_Str(obj3);
            PyString_AsStringAndSize(str, (char**)&arg3, &len);
            Py_DECREF(str);
        }
    }
    {
        glDrawElements(arg0,arg1,arg2,(void const *)arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDrawElementsub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLubyte *arg3 ;
    PyObject *temp_indices ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg2 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawElementsub",&arg0,&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedCharArray(obj3, &temp_indices, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj3); 
    }
    {
        glDrawElements(arg0,arg1,arg2,(GLubyte const *)arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg3, temp_indices); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawElementsus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLushort *arg3 ;
    PyObject *temp_indices ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg2 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawElementsus",&arg0,&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedShortArray(obj3, &temp_indices, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj3); 
    }
    {
        glDrawElements(arg0,arg1,arg2,(GLushort const *)arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg3, temp_indices); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawElementsui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLuint *arg3 ;
    PyObject *temp_indices ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg2 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawElementsui",&arg0,&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsUnsignedIntArray(obj3, &temp_indices, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj3); 
    }
    {
        glDrawElements(arg0,arg1,arg2,(GLuint const *)arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg3, temp_indices); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixels(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    void *arg4 ;
    PyObject * obj4  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiiO:glDrawPixels",&arg0,&arg1,&arg2,&arg3,&obj4)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj4 == Py_None) arg4 = NULL; else
        {
            str = PyObject_Str(obj4);
            PyString_AsStringAndSize(str, (char**)&arg4, &len);
            Py_DECREF(str);
        }
    }
    {
        glDrawPixels(arg0,arg1,arg2,arg3,(void const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLubyte *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsub",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsUnsignedCharArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLubyte const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLbyte *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsb",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsCharArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLbyte const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLushort *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsus",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsUnsignedShortArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLushort const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelss(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLshort *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelss",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsShortArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLshort const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLuint *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsui",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsUnsignedIntArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLuint const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLint *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsi",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsIntArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLint const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glDrawPixelsf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLsizei arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    GLfloat *arg4 ;
    PyObject *temp_pixels ;
    PyObject * obj4  = 0 ;
    
    {
    }
    {
    }
    {
        arg3 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iO:glDrawPixelsf",&arg2,&obj4)) return NULL;
    if (obj4)
    {
        arg4 = _PyObject_AsFloatArray(obj4, &temp_pixels, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_Dimension(obj4, 1); 
    }
    {
        arg1 = (GLsizei)_PyObject_Dimension(obj4, 0); 
    }
    {
        _glDrawPixels(arg0,arg1,arg2,arg3,(GLfloat const *)arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg4, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glEdgeFlagPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    void *arg1 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glEdgeFlagPointer",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsPointer(obj1);
    }
    {
        _glEdgeFlagPointer(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glEdgeFlagPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLbyte *arg1 ;
    PyObject * obj1  = 0 ;
    
    {
        arg0 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glEdgeFlagPointerb",&obj1)) return NULL;
    if (obj1)
    {
        arg1 = _PyObject_AsCharArray(obj1, NULL, NULL); 
    }
    {
        _glEdgeFlagPointer(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glEnable(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glEnable",&arg0)) return NULL;
    {
        glEnable(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEnableClientState(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glEnableClientState",&arg0)) return NULL;
    {
        glEnableClientState(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEnd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glEnd")) return NULL;
    {
        glEnd();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEndList(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glEndList")) return NULL;
    {
        glEndList();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalMesh1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glEvalMesh1",&arg0,&arg1,&arg2)) return NULL;
    {
        glEvalMesh1(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glEvalMesh2(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    
    if(!PyArg_ParseTuple(args,"iiiii:glEvalMesh2",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        glEvalMesh2(arg0,arg1,arg2,arg3,arg4);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFeedbackBuffer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glFeedbackBuffer",&arg0,&arg1)) return NULL;
    {
        _glFeedbackBuffer(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFinish(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glFinish")) return NULL;
    {
        glFinish();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFlush(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glFlush")) return NULL;
    {
        glFlush();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFogf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glFogf",&arg0,&arg1)) return NULL;
    {
        glFogf(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFogfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat *arg1 ;
    PyObject *temp_v ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glFogfv",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsFloatArray(obj1, &temp_v, NULL); 
    }
    {
        glFogfv(arg0,(GLfloat const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glFogi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glFogi",&arg0,&arg1)) return NULL;
    {
        glFogi(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFogiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint *arg1 ;
    PyObject *temp_v ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glFogiv",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsIntArray(obj1, &temp_v, NULL); 
    }
    {
        glFogiv(arg0,(GLint const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glFrontFace(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glFrontFace",&arg0)) return NULL;
    {
        glFrontFace(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glFrustum(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    GLdouble arg4 ;
    GLdouble arg5 ;
    
    if(!PyArg_ParseTuple(args,"dddddd:glFrustum",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        glFrustum(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glGenLists(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLuint result ;
    
    if(!PyArg_ParseTuple(args,"i:glGenLists",&arg0)) return NULL;
    {
        result = (GLuint )glGenLists(arg0);
        if (GLErrOccurred()) return NULL; 
    }    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_glGenTextures(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"i:glGenTextures",&arg0)) return NULL;
    {
        result = (PyObject *)_glGenTextures(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetBooleanv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    unsigned char *arg1 ;
    unsigned char temp_params[16] ;
    
    {
        int i; 	arg1 = temp_params; 	for (i = 0; i < 16; i++) arg1[i] = 255; 
    }
    if(!PyArg_ParseTuple(args,"i:glGetBooleanv",&arg0)) return NULL;
    {
        glGetBooleanv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 16 && arg1[n] != 255; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg1[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromUnsignedCharArray(2, dims, arg1, 0); 		break; 	default: 		resultobj = _PyTuple_FromUnsignedCharArray(n, arg1); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetClipPlane(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    double *arg1 ;
    double temp_equation[4] ;
    
    {
        int i; 	arg1 = temp_equation; 	for (i = 0; i < 4; i++) arg1[i] = -DBL_MAX; 
    }
    if(!PyArg_ParseTuple(args,"i:glGetClipPlane",&arg0)) return NULL;
    {
        glGetClipPlane(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg1[n] != -DBL_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg1[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromDoubleArray(2, dims, arg1, 0); 		break; 	default: 		resultobj = _PyTuple_FromDoubleArray(n, arg1); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetDoublev(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    double *arg1 ;
    double temp_params[16] ;
    
    {
        int i; 	arg1 = temp_params; 	for (i = 0; i < 16; i++) arg1[i] = -DBL_MAX; 
    }
    if(!PyArg_ParseTuple(args,"i:glGetDoublev",&arg0)) return NULL;
    {
        glGetDoublev(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 16 && arg1[n] != -DBL_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg1[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromDoubleArray(2, dims, arg1, 0); 		break; 	default: 		resultobj = _PyTuple_FromDoubleArray(n, arg1); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetFloatv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    float *arg1 ;
    float temp_params[16] ;
    
    {
        int i; 	arg1 = temp_params; 	for (i = 0; i < 16; i++) arg1[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"i:glGetFloatv",&arg0)) return NULL;
    {
        glGetFloatv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 16 && arg1[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg1[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg1, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg1); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetIntegerv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    int *arg1 ;
    int temp_params[16] ;
    
    {
        int i; 	arg1 = temp_params; 	for (i = 0; i < 16; i++) arg1[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"i:glGetIntegerv",&arg0)) return NULL;
    {
        glGetIntegerv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 16 && arg1[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg1[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg1, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg1); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetLightfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    float *arg2 ;
    float temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetLightfv",&arg0,&arg1)) return NULL;
    {
        glGetLightfv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetLightiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    int *arg2 ;
    int temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetLightiv",&arg0,&arg1)) return NULL;
    {
        glGetLightiv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetMapdv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"ii:glGetMapdv",&arg0,&arg1)) return NULL;
    {
        result = (PyObject *)_glGetMapdv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetMapfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"ii:glGetMapfv",&arg0,&arg1)) return NULL;
    {
        result = (PyObject *)_glGetMapdv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetMapiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"ii:glGetMapiv",&arg0,&arg1)) return NULL;
    {
        result = (PyObject *)_glGetMapiv(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetMaterialfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    float *arg2 ;
    float temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetMaterialfv",&arg0,&arg1)) return NULL;
    {
        glGetMaterialfv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetMaterialiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    int *arg2 ;
    int temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetMaterialiv",&arg0,&arg1)) return NULL;
    {
        glGetMaterialiv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetPixelMapfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"i:glGetPixelMapfv",&arg0)) return NULL;
    {
        result = (PyObject *)_glGetPixelMapfv(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetPixelMapuiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"i:glGetPixelMapuiv",&arg0)) return NULL;
    {
        result = (PyObject *)_glGetPixelMapuiv(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetPixelMapusv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"i:glGetPixelMapusv",&arg0)) return NULL;
    {
        result = (PyObject *)_glGetPixelMapusv(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetPolygonStipple(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,":glGetPolygonStipple")) return NULL;
    {
        result = (PyObject *)_glGetPolygonStipple();
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetPolygonStippleub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,":glGetPolygonStippleub")) return NULL;
    {
        result = (PyObject *)glGetPolygonStippleub();
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetString(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLubyte *result ;
    
    if(!PyArg_ParseTuple(args,"i:glGetString",&arg0)) return NULL;
    {
        result = (GLubyte *)glGetString(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        if (result) resultobj = PyString_FromString(result); else Py_INCREF(resultobj = Py_None);
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexEnvfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    float *arg2 ;
    float temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexEnvfv",&arg0,&arg1)) return NULL;
    {
        glGetTexEnvfv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexEnviv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    int *arg2 ;
    int temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexEnviv",&arg0,&arg1)) return NULL;
    {
        glGetTexEnviv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexGendv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    double *arg2 ;
    double temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -DBL_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexGendv",&arg0,&arg1)) return NULL;
    {
        glGetTexGendv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -DBL_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromDoubleArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromDoubleArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexGenfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    float *arg2 ;
    float temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexGenfv",&arg0,&arg1)) return NULL;
    {
        glGetTexGenfv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexGeniv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    int *arg2 ;
    int temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexGeniv",&arg0,&arg1)) return NULL;
    {
        glGetTexGeniv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImage(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"iiii:glGetTexImage",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        result = (PyObject *)_glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImageub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImageub",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImageb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImageb",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImageus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImageus",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImages(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImages",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImageui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImageui",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImagei(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImagei",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImagef(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImagef",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexImaged(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    GLenum arg3 ;
    PyObject *result ;
    
    {
        arg3 = GL_DOUBLE;
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexImaged",&arg0,&arg1,&arg2)) return NULL;
    {
        result = (PyObject *)__glGetTexImage(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexLevelParameterfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    float *arg3 ;
    float temp_params[4] ;
    
    {
        int i; 	arg3 = temp_params; 	for (i = 0; i < 4; i++) arg3[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexLevelParameterfv",&arg0,&arg1,&arg2)) return NULL;
    {
        glGetTexLevelParameterfv(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg3[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg3[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg3, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg3); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexLevelParameteriv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLenum arg2 ;
    int *arg3 ;
    int temp_params[4] ;
    
    {
        int i; 	arg3 = temp_params; 	for (i = 0; i < 4; i++) arg3[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"iii:glGetTexLevelParameteriv",&arg0,&arg1,&arg2)) return NULL;
    {
        glGetTexLevelParameteriv(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg3[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg3[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg3, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg3); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexParameterfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    float *arg2 ;
    float temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = -FLT_MAX; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexParameterfv",&arg0,&arg1)) return NULL;
    {
        glGetTexParameterfv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != -FLT_MAX; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyFloat_FromDouble(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromFloatArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromFloatArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glGetTexParameteriv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    int *arg2 ;
    int temp_params[4] ;
    
    {
        int i; 	arg2 = temp_params; 	for (i = 0; i < 4; i++) arg2[i] = INT_MIN; 
    }
    if(!PyArg_ParseTuple(args,"ii:glGetTexParameteriv",&arg0,&arg1)) return NULL;
    {
        glGetTexParameteriv(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        int n, dims[2]; 	Py_XDECREF(resultobj); 	for (n = 0; n < 4 && arg2[n] != INT_MIN; n++); 	switch (n) 	{
            case 0: 		Py_INCREF(Py_None); 		resultobj = Py_None; 		break; 	case 1: 		resultobj = PyInt_FromLong(arg2[0]); 		break; 	case 16: 		dims[0] = 4; 		dims[1] = 4; 		resultobj = _PyObject_FromIntArray(2, dims, arg2, 0); 		break; 	default: 		resultobj = _PyTuple_FromIntArray(n, arg2); 	
        } 
    }
    return resultobj;
}


static PyObject *_wrap_glHint(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glHint",&arg0,&arg1)) return NULL;
    {
        glHint(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glIndexMask",&arg0)) return NULL;
    {
        glIndexMask(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glIndexPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    void *arg2 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glIndexPointer",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsPointer(obj2);
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointerub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLubyte *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_UNSIGNED_BYTE;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointerub",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsUnsignedCharArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLbyte *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_BYTE;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointerb",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsCharArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointers(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLshort *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_SHORT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointers",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsShortArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointeri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLint *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_INT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointeri",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsIntArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointerf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLfloat *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_FLOAT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointerf",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsFloatArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIndexPointerd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLdouble *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_DOUBLE;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glIndexPointerd",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsDoubleArray(obj2, NULL, NULL); 
    }
    {
        _glIndexPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glInitNames(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glInitNames")) return NULL;
    {
        glInitNames();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glInterleavedArrays(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    void *arg2 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glInterleavedArrays",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsPointer(obj2);
    }
    {
        _glInterleavedArrays(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glIsEnabled(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLboolean result ;
    
    if(!PyArg_ParseTuple(args,"i:glIsEnabled",&arg0)) return NULL;
    {
        result = (GLboolean )glIsEnabled(arg0);
        if (GLErrOccurred()) return NULL; 
    }    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_glIsList(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLboolean result ;
    
    if(!PyArg_ParseTuple(args,"i:glIsList",&arg0)) return NULL;
    {
        result = (GLboolean )glIsList(arg0);
        if (GLErrOccurred()) return NULL; 
    }    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_glIsTexture(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLboolean result ;
    
    if(!PyArg_ParseTuple(args,"i:glIsTexture",&arg0)) return NULL;
    {
        result = (GLboolean )glIsTexture(arg0);
        if (GLErrOccurred()) return NULL; 
    }    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_glLightModelf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glLightModelf",&arg0,&arg1)) return NULL;
    {
        glLightModelf(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLightModelfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat *arg1 ;
    PyObject *temp_v ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glLightModelfv",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsFloatArray(obj1, &temp_v, NULL); 
    }
    {
        glLightModelfv(arg0,(GLfloat const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLightModeli(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glLightModeli",&arg0,&arg1)) return NULL;
    {
        glLightModeli(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLightModeliv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint *arg1 ;
    PyObject *temp_v ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iO:glLightModeliv",&arg0,&obj1)) return NULL;
    {
        arg1 = _PyObject_AsIntArray(obj1, &temp_v, NULL); 
    }
    {
        glLightModeliv(arg0,(GLint const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLightf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iif:glLightf",&arg0,&arg1,&arg2)) return NULL;
    {
        glLightf(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLightfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glLightfv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_v, NULL); 
    }
    {
        glLightfv(arg0,arg1,(GLfloat const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLighti(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glLighti",&arg0,&arg1,&arg2)) return NULL;
    {
        glLighti(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLightiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glLightiv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsIntArray(obj2, &temp_v, NULL); 
    }
    {
        glLightiv(arg0,arg1,(GLint const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLineStipple(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLushort arg1 ;
    
    if(!PyArg_ParseTuple(args,"ih:glLineStipple",&arg0,&arg1)) return NULL;
    {
        glLineStipple(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLineWidth(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glLineWidth",&arg0)) return NULL;
    {
        glLineWidth(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glListBase(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glListBase",&arg0)) return NULL;
    {
        glListBase(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLoadIdentity(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glLoadIdentity")) return NULL;
    {
        glLoadIdentity();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLoadMatrixd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glLoadMatrixd",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glLoadMatrixd((GLdouble const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLoadMatrixf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glLoadMatrixf",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glLoadMatrixf((GLfloat const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glLoadName(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glLoadName",&arg0)) return NULL;
    {
        glLoadName(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glLogicOp(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glLogicOp",&arg0)) return NULL;
    {
        glLogicOp(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMap1d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLdouble *arg5 ;
    PyObject *temp_points ;
    PyObject * obj5  = 0 ;
    
    {
    }
    {
    }
    if(!PyArg_ParseTuple(args,"iddO:glMap1d",&arg0,&arg1,&arg2,&obj5)) return NULL;
    if (obj5)
    {
        arg5 = _PyObject_AsDoubleArray(obj5, &temp_points, NULL); 
    }
    {
        arg3 = (GLint)_PyObject_Dimension(obj5, 1); 
    }
    {
        arg4 = (GLint)_PyObject_Dimension(obj5, 0); 
    }
    {
        glMap1d(arg0,arg1,arg2,arg3,arg4,(GLdouble const *)arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg5, temp_points); 
    }
    return resultobj;
}


static PyObject *_wrap_glMap1f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLint arg3 ;
    GLint arg4 ;
    GLfloat *arg5 ;
    PyObject *temp_points ;
    PyObject * obj5  = 0 ;
    
    {
    }
    {
    }
    if(!PyArg_ParseTuple(args,"iffO:glMap1f",&arg0,&arg1,&arg2,&obj5)) return NULL;
    if (obj5)
    {
        arg5 = _PyObject_AsFloatArray(obj5, &temp_points, NULL); 
    }
    {
        arg3 = (GLint)_PyObject_Dimension(obj5, 1); 
    }
    {
        arg4 = (GLint)_PyObject_Dimension(obj5, 0); 
    }
    {
        glMap1f(arg0,arg1,arg2,arg3,arg4,(GLfloat const *)arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg5, temp_points); 
    }
    return resultobj;
}


static PyObject *_wrap_glMap2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLint arg3 ;
    GLdouble arg4 ;
    GLdouble arg5 ;
    GLint arg6 ;
    GLint arg7 ;
    GLdouble *arg8 ;
    PyObject *temp_points ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
    }
    if(!PyArg_ParseTuple(args,"iddddO:glMap2d",&arg0,&arg1,&arg2,&arg4,&arg5,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsDoubleArray(obj8, &temp_points, NULL); 
    }
    {
        arg3 = (GLint)_PyObject_Dimension(obj8, 0); 
    }
    {
        arg6 = (GLint)_PyObject_Dimension(obj8, 2); 
    }
    {
        arg7 = (GLint)_PyObject_Dimension(obj8, 1); 
    }
    {
        _glMap2d(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLdouble const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_points); 
    }
    return resultobj;
}


static PyObject *_wrap_glMap2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLint arg3 ;
    GLfloat arg4 ;
    GLfloat arg5 ;
    GLint arg6 ;
    GLint arg7 ;
    GLfloat *arg8 ;
    PyObject *temp_points ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
    }
    if(!PyArg_ParseTuple(args,"iffffO:glMap2f",&arg0,&arg1,&arg2,&arg4,&arg5,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsFloatArray(obj8, &temp_points, NULL); 
    }
    {
        arg3 = (GLint)_PyObject_Dimension(obj8, 0); 
    }
    {
        arg6 = (GLint)_PyObject_Dimension(obj8, 2); 
    }
    {
        arg7 = (GLint)_PyObject_Dimension(obj8, 1); 
    }
    {
        _glMap2f(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLfloat const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_points); 
    }
    return resultobj;
}


static PyObject *_wrap_glMapGrid1d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"idd:glMapGrid1d",&arg0,&arg1,&arg2)) return NULL;
    {
        glMapGrid1d(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMapGrid1f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iff:glMapGrid1f",&arg0,&arg1,&arg2)) return NULL;
    {
        glMapGrid1f(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMapGrid2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLint arg3 ;
    GLdouble arg4 ;
    GLdouble arg5 ;
    
    if(!PyArg_ParseTuple(args,"iddidd:glMapGrid2d",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        glMapGrid2d(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMapGrid2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLint arg3 ;
    GLfloat arg4 ;
    GLfloat arg5 ;
    
    if(!PyArg_ParseTuple(args,"iffiff:glMapGrid2f",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        glMapGrid2f(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMatrixMode(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glMatrixMode",&arg0)) return NULL;
    {
        glMatrixMode(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glMultMatrixd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glMultMatrixd",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glMultMatrixd((GLdouble const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glMultMatrixf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glMultMatrixf",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glMultMatrixf((GLfloat const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glNewList(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glNewList",&arg0,&arg1)) return NULL;
    {
        glNewList(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glNormalPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    void *arg2 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glNormalPointer",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsPointer(obj2);
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glNormalPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLbyte *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_BYTE;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glNormalPointerb",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsCharArray(obj2, NULL, NULL); 
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glNormalPointers(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLshort *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_SHORT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glNormalPointers",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsShortArray(obj2, NULL, NULL); 
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glNormalPointeri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLint *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_INT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glNormalPointeri",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsIntArray(obj2, NULL, NULL); 
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glNormalPointerf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLfloat *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_FLOAT;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glNormalPointerf",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsFloatArray(obj2, NULL, NULL); 
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glNormalPointerd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLdouble *arg2 ;
    PyObject * obj2  = 0 ;
    
    {
        arg0 = GL_DOUBLE;
    }
    {
        arg1 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glNormalPointerd",&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsDoubleArray(obj2, NULL, NULL); 
    }
    {
        _glNormalPointer(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glOrtho(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    GLdouble arg4 ;
    GLdouble arg5 ;
    
    if(!PyArg_ParseTuple(args,"dddddd:glOrtho",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        glOrtho(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPassThrough(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glPassThrough",&arg0)) return NULL;
    {
        glPassThrough(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPixelMapfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_values ;
    PyObject * obj2  = 0 ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"iO:glPixelMapfv",&arg0,&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_values, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj2); 
    }
    {
        glPixelMapfv(arg0,arg1,(GLfloat const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_values); 
    }
    return resultobj;
}


static PyObject *_wrap_glPixelMapuiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLuint *arg2 ;
    PyObject *temp_values ;
    PyObject * obj2  = 0 ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"iO:glPixelMapuiv",&arg0,&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsUnsignedIntArray(obj2, &temp_values, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj2); 
    }
    {
        glPixelMapuiv(arg0,arg1,(GLuint const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_values); 
    }
    return resultobj;
}


static PyObject *_wrap_glPixelMapusv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLsizei arg1 ;
    GLushort *arg2 ;
    PyObject *temp_values ;
    PyObject * obj2  = 0 ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"iO:glPixelMapusv",&arg0,&obj2)) return NULL;
    if (obj2)
    {
        arg2 = _PyObject_AsUnsignedShortArray(obj2, &temp_values, NULL); 
    }
    {
        arg1 = (GLsizei)_PyObject_AsArray_Size(obj2); 
    }
    {
        glPixelMapusv(arg0,arg1,(GLushort const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_values); 
    }
    return resultobj;
}


static PyObject *_wrap_glPixelStoref(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glPixelStoref",&arg0,&arg1)) return NULL;
    {
        glPixelStoref(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPixelStorei(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glPixelStorei",&arg0,&arg1)) return NULL;
    {
        glPixelStorei(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPixelTransferf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"if:glPixelTransferf",&arg0,&arg1)) return NULL;
    {
        glPixelTransferf(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPixelTransferi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glPixelTransferi",&arg0,&arg1)) return NULL;
    {
        glPixelTransferi(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPixelZoom(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glPixelZoom",&arg0,&arg1)) return NULL;
    {
        glPixelZoom(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPointSize(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    
    if(!PyArg_ParseTuple(args,"f:glPointSize",&arg0)) return NULL;
    {
        glPointSize(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPolygonMode(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glPolygonMode",&arg0,&arg1)) return NULL;
    {
        glPolygonMode(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPolygonOffset(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glPolygonOffset",&arg0,&arg1)) return NULL;
    {
        glPolygonOffset(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPolygonStipple(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    void *arg0 ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glPolygonStipple",&obj0)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj0 == Py_None) arg0 = NULL; else
        {
            str = PyObject_Str(obj0);
            PyString_AsStringAndSize(str, (char**)&arg0, &len);
            Py_DECREF(str);
        }
    }
    {
        glPolygonStipple((void const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPolygonStippleub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLubyte *arg0 ;
    PyObject *temp_mask ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glPolygonStippleub",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsUnsignedCharArray(obj0, &temp_mask, NULL); 
    }
    {
        glPolygonStippleub((GLubyte const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_mask); 
    }
    return resultobj;
}


static PyObject *_wrap_glPopAttrib(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glPopAttrib")) return NULL;
    {
        glPopAttrib();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPopClientAttrib(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glPopClientAttrib")) return NULL;
    {
        _glPopClientAttrib();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPopMatrix(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glPopMatrix")) return NULL;
    {
        glPopMatrix();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPopName(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glPopName")) return NULL;
    {
        glPopName();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPrioritizeTextures(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    GLuint *arg1 ;
    GLclampf *arg2 ;
    PyObject *temp_textures ;
    PyObject * obj1  = 0 ;
    PyObject *temp_priorities ;
    PyObject * obj2  = 0 ;
    
    {
    }
    if(!PyArg_ParseTuple(args,"OO:glPrioritizeTextures",&obj1,&obj2)) return NULL;
    {
        arg1 = _PyObject_AsUnsignedIntArray(obj1, &temp_textures, NULL); 
    }
    if (obj2)
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_priorities, NULL); 
    }
    {
        arg0 = (GLsizei)_PyObject_AsArray_Size(obj1); 
    }
    {
        glPrioritizeTextures(arg0,(GLuint const *)arg1,(GLclampf const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg1, temp_textures); 
    }
    {
        _PyObject_AsArray_Cleanup(arg2, temp_priorities); 
    }
    return resultobj;
}


static PyObject *_wrap_glPushAttrib(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbitfield arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glPushAttrib",&arg0)) return NULL;
    {
        glPushAttrib(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPushClientAttrib(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLbitfield arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glPushClientAttrib",&arg0)) return NULL;
    {
        _glPushClientAttrib(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPushMatrix(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":glPushMatrix")) return NULL;
    {
        glPushMatrix();
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glPushName(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glPushName",&arg0)) return NULL;
    {
        glPushName(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos2d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    
    if(!PyArg_ParseTuple(args,"dd:glRasterPos2d",&arg0,&arg1)) return NULL;
    {
        glRasterPos2d(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos2dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos2dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos2dv((GLdouble const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos2f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    
    if(!PyArg_ParseTuple(args,"ff:glRasterPos2f",&arg0,&arg1)) return NULL;
    {
        glRasterPos2f(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos2fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos2fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos2fv((GLfloat const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos2i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    
    if(!PyArg_ParseTuple(args,"ii:glRasterPos2i",&arg0,&arg1)) return NULL;
    {
        glRasterPos2i(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos2iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos2iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos2iv((GLint const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos2s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glRasterPos2s",&obj0,&obj1)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        glRasterPos2s(arg0,arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos2sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos2sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos2sv((GLshort const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos3d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glRasterPos3d",&arg0,&arg1,&arg2)) return NULL;
    {
        glRasterPos3d(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos3dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos3dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos3dv((GLdouble const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos3f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glRasterPos3f",&arg0,&arg1,&arg2)) return NULL;
    {
        glRasterPos3f(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos3fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos3fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos3fv((GLfloat const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos3i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glRasterPos3i",&arg0,&arg1,&arg2)) return NULL;
    {
        glRasterPos3i(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos3iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos3iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos3iv((GLint const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos3s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOO:glRasterPos3s",&obj0,&obj1,&obj2)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
/* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{ 	glRasterPos3s(arg0,arg1,arg2);
 	if (GLErrOccurred()) return NULL; }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos3sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos3sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos3sv((GLshort const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos4d(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glRasterPos4d",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRasterPos4d(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos4dv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos4dv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos4dv((GLdouble const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos4f(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glRasterPos4f",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRasterPos4f(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos4fv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos4fv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos4fv((GLfloat const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos4i(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glRasterPos4i",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRasterPos4i(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos4iv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos4iv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos4iv((GLint const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glRasterPos4s(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    GLshort arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glRasterPos4s",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLshort ) PyString_AsString(obj3)[0];
        }
    }
    {
        glRasterPos4s(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRasterPos4sv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    PyObject *temp_v ;
    PyObject * obj0  = 0 ;
    
    if(!PyArg_ParseTuple(args,"O:glRasterPos4sv",&obj0)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_v, NULL); 
    }
    {
        glRasterPos4sv((GLshort const *)arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glReadBuffer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glReadBuffer",&arg0)) return NULL;
    {
        glReadBuffer(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glReadPixels(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"iiiiii:glReadPixels",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    {
        result = (PyObject *)_glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsub",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsb",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsus",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelss(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelss",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsui",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsi",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsf",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glReadPixelsd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    PyObject *result ;
    
    {
        arg5 = GL_DOUBLE;
    }
    if(!PyArg_ParseTuple(args,"iiiii:glReadPixelsd",&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        result = (PyObject *)__glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glRectd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glRectd",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRectd(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRectdv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble *arg0 ;
    GLdouble *arg1 ;
    PyObject *temp_p1 ;
    PyObject * obj0  = 0 ;
    PyObject *temp_p2 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glRectdv",&obj0,&obj1)) return NULL;
    {
        arg0 = _PyObject_AsDoubleArray(obj0, &temp_p1, NULL); 
    }
    {
        arg1 = _PyObject_AsDoubleArray(obj1, &temp_p2, NULL); 
    }
    {
        glRectdv((GLdouble const *)arg0,(GLdouble const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_p1); 
    }
    {
        _PyObject_AsArray_Cleanup(arg1, temp_p2); 
    }
    return resultobj;
}


static PyObject *_wrap_glRectf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glRectf",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRectf(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRectfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat *arg0 ;
    GLfloat *arg1 ;
    PyObject *temp_p1 ;
    PyObject * obj0  = 0 ;
    PyObject *temp_p2 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glRectfv",&obj0,&obj1)) return NULL;
    {
        arg0 = _PyObject_AsFloatArray(obj0, &temp_p1, NULL); 
    }
    {
        arg1 = _PyObject_AsFloatArray(obj1, &temp_p2, NULL); 
    }
    {
        glRectfv((GLfloat const *)arg0,(GLfloat const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_p1); 
    }
    {
        _PyObject_AsArray_Cleanup(arg1, temp_p2); 
    }
    return resultobj;
}


static PyObject *_wrap_glRecti(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glRecti",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRecti(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRectiv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint *arg0 ;
    GLint *arg1 ;
    PyObject *temp_p1 ;
    PyObject * obj0  = 0 ;
    PyObject *temp_p2 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glRectiv",&obj0,&obj1)) return NULL;
    {
        arg0 = _PyObject_AsIntArray(obj0, &temp_p1, NULL); 
    }
    {
        arg1 = _PyObject_AsIntArray(obj1, &temp_p2, NULL); 
    }
    {
        glRectiv((GLint const *)arg0,(GLint const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_p1); 
    }
    {
        _PyObject_AsArray_Cleanup(arg1, temp_p2); 
    }
    return resultobj;
}


static PyObject *_wrap_glRects(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort arg0 ;
    GLshort arg1 ;
    GLshort arg2 ;
    GLshort arg3 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:glRects",&obj0,&obj1,&obj2,&obj3)) return NULL;
    {
        if (PyInt_Check(obj0) || PyLong_Check(obj0))
        {
            arg0 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj0)));
        }
        else if (PyString_Check (obj0))
        {
            /* what is a GLshort's size? */
		arg0 = (GLshort ) PyString_AsString(obj0)[0];
	}
}
{
	if (PyInt_Check(obj1) || PyLong_Check(obj1))
	{
		arg1 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj1)));
	}
	else if (PyString_Check (obj1))
	{
		/* what is a GLshort's size? */
            arg1 = (GLshort ) PyString_AsString(obj1)[0];
        }
    }
    {
        if (PyInt_Check(obj2) || PyLong_Check(obj2))
        {
            arg2 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj2)));
        }
        else if (PyString_Check (obj2))
        {
            /* what is a GLshort's size? */
		arg2 = (GLshort ) PyString_AsString(obj2)[0];
	}
}
{
	if (PyInt_Check(obj3) || PyLong_Check(obj3))
	{
		arg3 = (GLshort )(PyInt_AsLong( PyNumber_Int(obj3)));
	}
	else if (PyString_Check (obj3))
	{
		/* what is a GLshort's size? */
            arg3 = (GLshort ) PyString_AsString(obj3)[0];
        }
    }
    {
        glRects(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRectsv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLshort *arg0 ;
    GLshort *arg1 ;
    PyObject *temp_p1 ;
    PyObject * obj0  = 0 ;
    PyObject *temp_p2 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:glRectsv",&obj0,&obj1)) return NULL;
    {
        arg0 = _PyObject_AsShortArray(obj0, &temp_p1, NULL); 
    }
    {
        arg1 = _PyObject_AsShortArray(obj1, &temp_p2, NULL); 
    }
    {
        glRectsv((GLshort const *)arg0,(GLshort const *)arg1);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg0, temp_p1); 
    }
    {
        _PyObject_AsArray_Cleanup(arg1, temp_p2); 
    }
    return resultobj;
}


static PyObject *_wrap_glRenderMode(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"i:glRenderMode",&arg0)) return NULL;
    {
        result = (PyObject *)_glRenderMode(arg0);
        if (GLErrOccurred()) return NULL; 
    }{
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_glRotated(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    GLdouble arg3 ;
    
    if(!PyArg_ParseTuple(args,"dddd:glRotated",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRotated(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glRotatef(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    GLfloat arg3 ;
    
    if(!PyArg_ParseTuple(args,"ffff:glRotatef",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glRotatef(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glScaled(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glScaled",&arg0,&arg1,&arg2)) return NULL;
    {
        glScaled(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glScalef(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glScalef",&arg0,&arg1,&arg2)) return NULL;
    {
        glScalef(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glScissor(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glScissor",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glScissor(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glSelectBuffer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLsizei arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glSelectBuffer",&arg0)) return NULL;
    {
        _glSelectBuffer(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glShadeModel(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glShadeModel",&arg0)) return NULL;
    {
        glShadeModel(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glStencilFunc(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLuint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glStencilFunc",&arg0,&arg1,&arg2)) return NULL;
    {
        glStencilFunc(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glStencilMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLuint arg0 ;
    
    if(!PyArg_ParseTuple(args,"i:glStencilMask",&arg0)) return NULL;
    {
        glStencilMask(arg0);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glStencilOp(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLenum arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glStencilOp",&arg0,&arg1,&arg2)) return NULL;
    {
        glStencilOp(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    void *arg3 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiO:glTexCoordPointer",&arg0,&arg1,&arg2,&obj3)) return NULL;
    {
        arg3 = _PyObject_AsPointer(obj3);
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLbyte *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_BYTE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glTexCoordPointerb",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsCharArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointers(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLshort *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_SHORT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glTexCoordPointers",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsShortArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointeri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLint *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_INT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glTexCoordPointeri",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsIntArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointerf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLfloat *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_FLOAT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glTexCoordPointerf",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsFloatArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexCoordPointerd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLdouble *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_DOUBLE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glTexCoordPointerd",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsDoubleArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glTexCoordPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glTexEnvf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iif:glTexEnvf",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexEnvf(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexEnvfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexEnvfv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_v, NULL); 
    }
    {
        glTexEnvfv(arg0,arg1,(GLfloat const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexEnvi(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glTexEnvi",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexEnvi(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexEnviv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexEnviv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsIntArray(obj2, &temp_v, NULL); 
    }
    {
        glTexEnviv(arg0,arg1,(GLint const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexGend(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"iid:glTexGend",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexGend(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexGendv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLdouble *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexGendv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsDoubleArray(obj2, &temp_v, NULL); 
    }
    {
        glTexGendv(arg0,arg1,(GLdouble const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexGenf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iif:glTexGenf",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexGenf(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexGenfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexGenfv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_v, NULL); 
    }
    {
        glTexGenfv(arg0,arg1,(GLfloat const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexGeni(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glTexGeni",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexGeni(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexGeniv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexGeniv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsIntArray(obj2, &temp_v, NULL); 
    }
    {
        glTexGeniv(arg0,arg1,(GLint const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    void *arg7 ;
    PyObject * obj7  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiiO:glTexImage1D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&obj7)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj7 == Py_None) arg7 = NULL; else
        {
            str = PyObject_Str(obj7);
            PyString_AsStringAndSize(str, (char**)&arg7, &len);
            Py_DECREF(str);
        }
    }
    {
        glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(void const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexImage1Dub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLubyte *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Dub",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsUnsignedCharArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLubyte const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Db(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLbyte *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Db",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsCharArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLbyte const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Dus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLushort *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Dus",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsUnsignedShortArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLushort const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Ds(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLshort *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Ds",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsShortArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLshort const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Dui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLuint *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Dui",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsUnsignedIntArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLuint const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Di(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLint *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Di",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsIntArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLint const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage1Df(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLint arg4 ;
    GLenum arg5 ;
    GLenum arg6 ;
    GLfloat *arg7 ;
    PyObject *temp_pixels ;
    PyObject * obj7  = 0 ;
    
    {
    }
    {
        arg6 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage1Df",&arg0,&arg1,&arg2,&arg4,&arg5,&obj7)) return NULL;
    if (obj7)
    {
        arg7 = _PyObject_AsFloatArray(obj7, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj7, 0); 
    }
    {
        _glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,(GLfloat const *)arg7);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg7, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    void *arg8 ;
    PyObject * obj8  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiiiO:glTexImage2D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&obj8)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj8 == Py_None) arg8 = NULL; else
        {
            str = PyObject_Str(obj8);
            PyString_AsStringAndSize(str, (char**)&arg8, &len);
            Py_DECREF(str);
        }
    }
    {
        glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(void const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexImage2Dub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLubyte *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Dub",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedCharArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLubyte const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Db(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLbyte *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Db",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsCharArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLbyte const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Dus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLushort *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Dus",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedShortArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLushort const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Ds(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLshort *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Ds",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsShortArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLshort const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Dui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLuint *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Dui",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedIntArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLuint const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Di(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLint *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Di",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsIntArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLint const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexImage2Df(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLsizei arg4 ;
    GLint arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLfloat *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexImage2Df",&arg0,&arg1,&arg2,&arg5,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsFloatArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLfloat const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexParameterf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"iif:glTexParameterf",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexParameterf(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexParameterfv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLfloat *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexParameterfv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsFloatArray(obj2, &temp_v, NULL); 
    }
    {
        glTexParameterfv(arg0,arg1,(GLfloat const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexParameteri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint arg2 ;
    
    if(!PyArg_ParseTuple(args,"iii:glTexParameteri",&arg0,&arg1,&arg2)) return NULL;
    {
        glTexParameteri(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexParameteriv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLenum arg1 ;
    GLint *arg2 ;
    PyObject *temp_v ;
    PyObject * obj2  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiO:glTexParameteriv",&arg0,&arg1,&obj2)) return NULL;
    {
        arg2 = _PyObject_AsIntArray(obj2, &temp_v, NULL); 
    }
    {
        glTexParameteriv(arg0,arg1,(GLint const *)arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg2, temp_v); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    void *arg6 ;
    PyObject * obj6  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiO:glTexSubImage1D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&obj6)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj6 == Py_None) arg6 = NULL; else
        {
            str = PyObject_Str(obj6);
            PyString_AsStringAndSize(str, (char**)&arg6, &len);
            Py_DECREF(str);
        }
    }
    {
        glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(void const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Dub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLubyte *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Dub",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsUnsignedCharArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLubyte const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Db(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLbyte *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Db",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsCharArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLbyte const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Dus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLushort *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Dus",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsUnsignedShortArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLushort const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Ds(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLshort *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Ds",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsShortArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLshort const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Dui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLuint *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Dui",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsUnsignedIntArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLuint const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Di(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLint *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Di",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsIntArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLint const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage1Df(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLsizei arg3 ;
    GLenum arg4 ;
    GLenum arg5 ;
    GLfloat *arg6 ;
    PyObject *temp_pixels ;
    PyObject * obj6  = 0 ;
    
    {
    }
    {
        arg5 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iiiiO:glTexSubImage1Df",&arg0,&arg1,&arg2,&arg4,&obj6)) return NULL;
    if (obj6)
    {
        arg6 = _PyObject_AsFloatArray(obj6, &temp_pixels, NULL); 
    }
    {
        arg3 = (GLsizei)_PyObject_Dimension(obj6, 0); 
    }
    {
        _glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,(GLfloat const *)arg6);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg6, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2D(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    void *arg8 ;
    PyObject * obj8  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiiiiiiO:glTexSubImage2D",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&obj8)) return NULL;
    {
        int len;
        PyObject* str;
        if (obj8 == Py_None) arg8 = NULL; else
        {
            str = PyObject_Str(obj8);
            PyString_AsStringAndSize(str, (char**)&arg8, &len);
            Py_DECREF(str);
        }
    }
    {
        glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(void const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Dub(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLubyte *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Dub",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedCharArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLubyte const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Db(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLbyte *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_BYTE;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Db",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsCharArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLbyte const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Dus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLushort *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Dus",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedShortArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLushort const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Ds(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLshort *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_SHORT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Ds",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsShortArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLshort const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Dui(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLuint *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_UNSIGNED_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Dui",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsUnsignedIntArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLuint const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Di(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLint *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_INT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Di",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsIntArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLint const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTexSubImage2Df(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLenum arg0 ;
    GLint arg1 ;
    GLint arg2 ;
    GLint arg3 ;
    GLsizei arg4 ;
    GLsizei arg5 ;
    GLenum arg6 ;
    GLenum arg7 ;
    GLfloat *arg8 ;
    PyObject *temp_pixels ;
    PyObject * obj8  = 0 ;
    
    {
    }
    {
    }
    {
        arg7 = GL_FLOAT;
    }
    if(!PyArg_ParseTuple(args,"iiiiiO:glTexSubImage2Df",&arg0,&arg1,&arg2,&arg3,&arg6,&obj8)) return NULL;
    if (obj8)
    {
        arg8 = _PyObject_AsFloatArray(obj8, &temp_pixels, NULL); 
    }
    {
        arg4 = (GLsizei)_PyObject_Dimension(obj8, 1); 
    }
    {
        arg5 = (GLsizei)_PyObject_Dimension(obj8, 0); 
    }
    {
        _glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,(GLfloat const *)arg8);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        _PyObject_AsArray_Cleanup(arg8, temp_pixels); 
    }
    return resultobj;
}


static PyObject *_wrap_glTranslated(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLdouble arg0 ;
    GLdouble arg1 ;
    GLdouble arg2 ;
    
    if(!PyArg_ParseTuple(args,"ddd:glTranslated",&arg0,&arg1,&arg2)) return NULL;
    {
        glTranslated(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glTranslatef(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLfloat arg0 ;
    GLfloat arg1 ;
    GLfloat arg2 ;
    
    if(!PyArg_ParseTuple(args,"fff:glTranslatef",&arg0,&arg1,&arg2)) return NULL;
    {
        glTranslatef(arg0,arg1,arg2);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_glVertexPointer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    void *arg3 ;
    PyObject * obj3  = 0 ;
    
    if(!PyArg_ParseTuple(args,"iiiO:glVertexPointer",&arg0,&arg1,&arg2,&obj3)) return NULL;
    {
        arg3 = _PyObject_AsPointer(obj3);
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glVertexPointerb(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLbyte *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_BYTE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glVertexPointerb",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsCharArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glVertexPointers(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLshort *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_SHORT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glVertexPointers",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsShortArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glVertexPointeri(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLint *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_INT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glVertexPointeri",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsIntArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glVertexPointerf(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLfloat *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_FLOAT;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glVertexPointerf",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsFloatArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glVertexPointerd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLenum arg1 ;
    GLsizei arg2 ;
    GLdouble *arg3 ;
    PyObject * obj3  = 0 ;
    
    {
    }
    {
        arg1 = GL_DOUBLE;
    }
    {
        arg2 = 0;
    }
    if(!PyArg_ParseTuple(args,"O:glVertexPointerd",&obj3)) return NULL;
    if (obj3)
    {
        arg3 = _PyObject_AsDoubleArray(obj3, NULL, NULL); 
    }
    {
        arg0 = (GLint)_PyObject_Dimension(obj3, 1); 
    }
    {
        _glVertexPointer(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
    }
    return resultobj;
}


static PyObject *_wrap_glViewport(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    GLint arg0 ;
    GLint arg1 ;
    GLsizei arg2 ;
    GLsizei arg3 ;
    
    if(!PyArg_ParseTuple(args,"iiii:glViewport",&arg0,&arg1,&arg2,&arg3)) return NULL;
    {
        glViewport(arg0,arg1,arg2,arg3);
        if (GLErrOccurred()) return NULL; 
    }    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyMethodDef __init___Methods[] = {
	 {"glArrayElement", _wrap_glArrayElement, METH_VARARGS , _doc_glArrayElement},
	 {"glBegin", _wrap_glBegin, METH_VARARGS , _doc_glBegin},
	 {"glCallList", _wrap_glCallList, METH_VARARGS , _doc_glCallList},
	 {"glCallLists", _wrap_glCallLists, METH_VARARGS , _doc_glCallLists},
	 {"glColor3b", _wrap_glColor3b, METH_VARARGS , _doc_glColor3b},
	 {"glColor3bv", _wrap_glColor3bv, METH_VARARGS , _doc_glColor3bv},
	 {"glColor3d", _wrap_glColor3d, METH_VARARGS , _doc_glColor3d},
	 {"glColor3dv", _wrap_glColor3dv, METH_VARARGS , _doc_glColor3dv},
	 {"glColor3f", _wrap_glColor3f, METH_VARARGS , _doc_glColor3f},
	 {"glColor3fv", _wrap_glColor3fv, METH_VARARGS , _doc_glColor3fv},
	 {"glColor3i", _wrap_glColor3i, METH_VARARGS , _doc_glColor3i},
	 {"glColor3iv", _wrap_glColor3iv, METH_VARARGS , _doc_glColor3iv},
	 {"glColor3s", _wrap_glColor3s, METH_VARARGS , _doc_glColor3s},
	 {"glColor3sv", _wrap_glColor3sv, METH_VARARGS , _doc_glColor3sv},
	 {"glColor3ub", _wrap_glColor3ub, METH_VARARGS , _doc_glColor3ub},
	 {"glColor3ubv", _wrap_glColor3ubv, METH_VARARGS , _doc_glColor3ubv},
	 {"glColor3ui", _wrap_glColor3ui, METH_VARARGS , _doc_glColor3ui},
	 {"glColor3uiv", _wrap_glColor3uiv, METH_VARARGS , _doc_glColor3uiv},
	 {"glColor3us", _wrap_glColor3us, METH_VARARGS , _doc_glColor3us},
	 {"glColor3usv", _wrap_glColor3usv, METH_VARARGS , _doc_glColor3usv},
	 {"glColor4b", _wrap_glColor4b, METH_VARARGS , _doc_glColor4b},
	 {"glColor4bv", _wrap_glColor4bv, METH_VARARGS , _doc_glColor4bv},
	 {"glColor4d", _wrap_glColor4d, METH_VARARGS , _doc_glColor4d},
	 {"glColor4dv", _wrap_glColor4dv, METH_VARARGS , _doc_glColor4dv},
	 {"glColor4f", _wrap_glColor4f, METH_VARARGS , _doc_glColor4f},
	 {"glColor4fv", _wrap_glColor4fv, METH_VARARGS , _doc_glColor4fv},
	 {"glColor4i", _wrap_glColor4i, METH_VARARGS , _doc_glColor4i},
	 {"glColor4iv", _wrap_glColor4iv, METH_VARARGS , _doc_glColor4iv},
	 {"glColor4s", _wrap_glColor4s, METH_VARARGS , _doc_glColor4s},
	 {"glColor4sv", _wrap_glColor4sv, METH_VARARGS , _doc_glColor4sv},
	 {"glColor4ub", _wrap_glColor4ub, METH_VARARGS , _doc_glColor4ub},
	 {"glColor4ubv", _wrap_glColor4ubv, METH_VARARGS , _doc_glColor4ubv},
	 {"glColor4ui", _wrap_glColor4ui, METH_VARARGS , _doc_glColor4ui},
	 {"glColor4uiv", _wrap_glColor4uiv, METH_VARARGS , _doc_glColor4uiv},
	 {"glColor4us", _wrap_glColor4us, METH_VARARGS , _doc_glColor4us},
	 {"glColor4usv", _wrap_glColor4usv, METH_VARARGS , _doc_glColor4usv},
	 {"glEdgeFlag", _wrap_glEdgeFlag, METH_VARARGS , _doc_glEdgeFlag},
	 {"glEdgeFlagv", _wrap_glEdgeFlagv, METH_VARARGS , _doc_glEdgeFlagv},
	 {"glEvalCoord1d", _wrap_glEvalCoord1d, METH_VARARGS , _doc_glEvalCoord1d},
	 {"glEvalCoord1dv", _wrap_glEvalCoord1dv, METH_VARARGS , _doc_glEvalCoord1dv},
	 {"glEvalCoord1f", _wrap_glEvalCoord1f, METH_VARARGS , _doc_glEvalCoord1f},
	 {"glEvalCoord1fv", _wrap_glEvalCoord1fv, METH_VARARGS , _doc_glEvalCoord1fv},
	 {"glEvalCoord2d", _wrap_glEvalCoord2d, METH_VARARGS , _doc_glEvalCoord2d},
	 {"glEvalCoord2dv", _wrap_glEvalCoord2dv, METH_VARARGS , _doc_glEvalCoord2dv},
	 {"glEvalCoord2f", _wrap_glEvalCoord2f, METH_VARARGS , _doc_glEvalCoord2f},
	 {"glEvalCoord2fv", _wrap_glEvalCoord2fv, METH_VARARGS , _doc_glEvalCoord2fv},
	 {"glEvalPoint1", _wrap_glEvalPoint1, METH_VARARGS , _doc_glEvalPoint1},
	 {"glEvalPoint2", _wrap_glEvalPoint2, METH_VARARGS , _doc_glEvalPoint2},
	 {"glIndexd", _wrap_glIndexd, METH_VARARGS , _doc_glIndexd},
	 {"glIndexdv", _wrap_glIndexdv, METH_VARARGS , _doc_glIndexdv},
	 {"glIndexf", _wrap_glIndexf, METH_VARARGS , _doc_glIndexf},
	 {"glIndexfv", _wrap_glIndexfv, METH_VARARGS , _doc_glIndexfv},
	 {"glIndexi", _wrap_glIndexi, METH_VARARGS , _doc_glIndexi},
	 {"glIndexiv", _wrap_glIndexiv, METH_VARARGS , _doc_glIndexiv},
	 {"glIndexs", _wrap_glIndexs, METH_VARARGS , _doc_glIndexs},
	 {"glIndexsv", _wrap_glIndexsv, METH_VARARGS , _doc_glIndexsv},
	 {"glIndexub", _wrap_glIndexub, METH_VARARGS , _doc_glIndexub},
	 {"glIndexubv", _wrap_glIndexubv, METH_VARARGS , _doc_glIndexubv},
	 {"glMaterialf", _wrap_glMaterialf, METH_VARARGS , _doc_glMaterialf},
	 {"glMaterialfv", _wrap_glMaterialfv, METH_VARARGS , _doc_glMaterialfv},
	 {"glMateriali", _wrap_glMateriali, METH_VARARGS , _doc_glMateriali},
	 {"glMaterialiv", _wrap_glMaterialiv, METH_VARARGS , _doc_glMaterialiv},
	 {"glNormal3b", _wrap_glNormal3b, METH_VARARGS , _doc_glNormal3b},
	 {"glNormal3bv", _wrap_glNormal3bv, METH_VARARGS , _doc_glNormal3bv},
	 {"glNormal3d", _wrap_glNormal3d, METH_VARARGS , _doc_glNormal3d},
	 {"glNormal3dv", _wrap_glNormal3dv, METH_VARARGS , _doc_glNormal3dv},
	 {"glNormal3f", _wrap_glNormal3f, METH_VARARGS , _doc_glNormal3f},
	 {"glNormal3fv", _wrap_glNormal3fv, METH_VARARGS , _doc_glNormal3fv},
	 {"glNormal3i", _wrap_glNormal3i, METH_VARARGS , _doc_glNormal3i},
	 {"glNormal3iv", _wrap_glNormal3iv, METH_VARARGS , _doc_glNormal3iv},
	 {"glNormal3s", _wrap_glNormal3s, METH_VARARGS , _doc_glNormal3s},
	 {"glNormal3sv", _wrap_glNormal3sv, METH_VARARGS , _doc_glNormal3sv},
	 {"glTexCoord1d", _wrap_glTexCoord1d, METH_VARARGS , _doc_glTexCoord1d},
	 {"glTexCoord1dv", _wrap_glTexCoord1dv, METH_VARARGS , _doc_glTexCoord1dv},
	 {"glTexCoord1f", _wrap_glTexCoord1f, METH_VARARGS , _doc_glTexCoord1f},
	 {"glTexCoord1fv", _wrap_glTexCoord1fv, METH_VARARGS , _doc_glTexCoord1fv},
	 {"glTexCoord1i", _wrap_glTexCoord1i, METH_VARARGS , _doc_glTexCoord1i},
	 {"glTexCoord1iv", _wrap_glTexCoord1iv, METH_VARARGS , _doc_glTexCoord1iv},
	 {"glTexCoord1s", _wrap_glTexCoord1s, METH_VARARGS , _doc_glTexCoord1s},
	 {"glTexCoord1sv", _wrap_glTexCoord1sv, METH_VARARGS , _doc_glTexCoord1sv},
	 {"glTexCoord2d", _wrap_glTexCoord2d, METH_VARARGS , _doc_glTexCoord2d},
	 {"glTexCoord2dv", _wrap_glTexCoord2dv, METH_VARARGS , _doc_glTexCoord2dv},
	 {"glTexCoord2f", _wrap_glTexCoord2f, METH_VARARGS , _doc_glTexCoord2f},
	 {"glTexCoord2fv", _wrap_glTexCoord2fv, METH_VARARGS , _doc_glTexCoord2fv},
	 {"glTexCoord2i", _wrap_glTexCoord2i, METH_VARARGS , _doc_glTexCoord2i},
	 {"glTexCoord2iv", _wrap_glTexCoord2iv, METH_VARARGS , _doc_glTexCoord2iv},
	 {"glTexCoord2s", _wrap_glTexCoord2s, METH_VARARGS , _doc_glTexCoord2s},
	 {"glTexCoord2sv", _wrap_glTexCoord2sv, METH_VARARGS , _doc_glTexCoord2sv},
	 {"glTexCoord3d", _wrap_glTexCoord3d, METH_VARARGS , _doc_glTexCoord3d},
	 {"glTexCoord3dv", _wrap_glTexCoord3dv, METH_VARARGS , _doc_glTexCoord3dv},
	 {"glTexCoord3f", _wrap_glTexCoord3f, METH_VARARGS , _doc_glTexCoord3f},
	 {"glTexCoord3fv", _wrap_glTexCoord3fv, METH_VARARGS , _doc_glTexCoord3fv},
	 {"glTexCoord3i", _wrap_glTexCoord3i, METH_VARARGS , _doc_glTexCoord3i},
	 {"glTexCoord3iv", _wrap_glTexCoord3iv, METH_VARARGS , _doc_glTexCoord3iv},
	 {"glTexCoord3s", _wrap_glTexCoord3s, METH_VARARGS , _doc_glTexCoord3s},
	 {"glTexCoord3sv", _wrap_glTexCoord3sv, METH_VARARGS , _doc_glTexCoord3sv},
	 {"glTexCoord4d", _wrap_glTexCoord4d, METH_VARARGS , _doc_glTexCoord4d},
	 {"glTexCoord4dv", _wrap_glTexCoord4dv, METH_VARARGS , _doc_glTexCoord4dv},
	 {"glTexCoord4f", _wrap_glTexCoord4f, METH_VARARGS , _doc_glTexCoord4f},
	 {"glTexCoord4fv", _wrap_glTexCoord4fv, METH_VARARGS , _doc_glTexCoord4fv},
	 {"glTexCoord4i", _wrap_glTexCoord4i, METH_VARARGS , _doc_glTexCoord4i},
	 {"glTexCoord4iv", _wrap_glTexCoord4iv, METH_VARARGS , _doc_glTexCoord4iv},
	 {"glTexCoord4s", _wrap_glTexCoord4s, METH_VARARGS , _doc_glTexCoord4s},
	 {"glTexCoord4sv", _wrap_glTexCoord4sv, METH_VARARGS , _doc_glTexCoord4sv},
	 {"glVertex2d", _wrap_glVertex2d, METH_VARARGS , _doc_glVertex2d},
	 {"glVertex2dv", _wrap_glVertex2dv, METH_VARARGS , _doc_glVertex2dv},
	 {"glVertex2f", _wrap_glVertex2f, METH_VARARGS , _doc_glVertex2f},
	 {"glVertex2fv", _wrap_glVertex2fv, METH_VARARGS , _doc_glVertex2fv},
	 {"glVertex2i", _wrap_glVertex2i, METH_VARARGS , _doc_glVertex2i},
	 {"glVertex2iv", _wrap_glVertex2iv, METH_VARARGS , _doc_glVertex2iv},
	 {"glVertex2s", _wrap_glVertex2s, METH_VARARGS , _doc_glVertex2s},
	 {"glVertex2sv", _wrap_glVertex2sv, METH_VARARGS , _doc_glVertex2sv},
	 {"glVertex3d", _wrap_glVertex3d, METH_VARARGS , _doc_glVertex3d},
	 {"glVertex3dv", _wrap_glVertex3dv, METH_VARARGS , _doc_glVertex3dv},
	 {"glVertex3f", _wrap_glVertex3f, METH_VARARGS , _doc_glVertex3f},
	 {"glVertex3fv", _wrap_glVertex3fv, METH_VARARGS , _doc_glVertex3fv},
	 {"glVertex3i", _wrap_glVertex3i, METH_VARARGS , _doc_glVertex3i},
	 {"glVertex3iv", _wrap_glVertex3iv, METH_VARARGS , _doc_glVertex3iv},
	 {"glVertex3s", _wrap_glVertex3s, METH_VARARGS , _doc_glVertex3s},
	 {"glVertex3sv", _wrap_glVertex3sv, METH_VARARGS , _doc_glVertex3sv},
	 {"glVertex4d", _wrap_glVertex4d, METH_VARARGS , _doc_glVertex4d},
	 {"glVertex4dv", _wrap_glVertex4dv, METH_VARARGS , _doc_glVertex4dv},
	 {"glVertex4f", _wrap_glVertex4f, METH_VARARGS , _doc_glVertex4f},
	 {"glVertex4fv", _wrap_glVertex4fv, METH_VARARGS , _doc_glVertex4fv},
	 {"glVertex4i", _wrap_glVertex4i, METH_VARARGS , _doc_glVertex4i},
	 {"glVertex4iv", _wrap_glVertex4iv, METH_VARARGS , _doc_glVertex4iv},
	 {"glVertex4s", _wrap_glVertex4s, METH_VARARGS , _doc_glVertex4s},
	 {"glVertex4sv", _wrap_glVertex4sv, METH_VARARGS , _doc_glVertex4sv},
	 {"__has_extension", _wrap___has_extension, METH_VARARGS , _doc___has_extension},
	 {"glAccum", _wrap_glAccum, METH_VARARGS , _doc_glAccum},
	 {"glAlphaFunc", _wrap_glAlphaFunc, METH_VARARGS , _doc_glAlphaFunc},
	 {"glAreTexturesResident", _wrap_glAreTexturesResident, METH_VARARGS , _doc_glAreTexturesResident},
	 {"glBindTexture", _wrap_glBindTexture, METH_VARARGS , _doc_glBindTexture},
	 {"glBitmap", _wrap_glBitmap, METH_VARARGS , _doc_glBitmap},
	 {"glBlendFunc", _wrap_glBlendFunc, METH_VARARGS , _doc_glBlendFunc},
	 {"glClear", _wrap_glClear, METH_VARARGS , _doc_glClear},
	 {"glClearAccum", _wrap_glClearAccum, METH_VARARGS , _doc_glClearAccum},
	 {"glClearColor", _wrap_glClearColor, METH_VARARGS , _doc_glClearColor},
	 {"glClearDepth", _wrap_glClearDepth, METH_VARARGS , _doc_glClearDepth},
	 {"glClearIndex", _wrap_glClearIndex, METH_VARARGS , _doc_glClearIndex},
	 {"glClearStencil", _wrap_glClearStencil, METH_VARARGS , _doc_glClearStencil},
	 {"glClipPlane", _wrap_glClipPlane, METH_VARARGS , _doc_glClipPlane},
	 {"glColorMask", _wrap_glColorMask, METH_VARARGS , _doc_glColorMask},
	 {"glColorMaterial", _wrap_glColorMaterial, METH_VARARGS , _doc_glColorMaterial},
	 {"glColorPointer", _wrap_glColorPointer, METH_VARARGS , _doc_glColorPointer},
	 {"glColorPointerub", _wrap_glColorPointerub, METH_VARARGS , _doc_glColorPointerub},
	 {"glColorPointerb", _wrap_glColorPointerb, METH_VARARGS , _doc_glColorPointerb},
	 {"glColorPointerus", _wrap_glColorPointerus, METH_VARARGS , _doc_glColorPointerus},
	 {"glColorPointers", _wrap_glColorPointers, METH_VARARGS , _doc_glColorPointers},
	 {"glColorPointerui", _wrap_glColorPointerui, METH_VARARGS , _doc_glColorPointerui},
	 {"glColorPointeri", _wrap_glColorPointeri, METH_VARARGS , _doc_glColorPointeri},
	 {"glColorPointerf", _wrap_glColorPointerf, METH_VARARGS , _doc_glColorPointerf},
	 {"glColorPointerd", _wrap_glColorPointerd, METH_VARARGS , _doc_glColorPointerd},
	 {"glCopyPixels", _wrap_glCopyPixels, METH_VARARGS , _doc_glCopyPixels},
	 {"glCopyTexImage1D", _wrap_glCopyTexImage1D, METH_VARARGS , _doc_glCopyTexImage1D},
	 {"glCopyTexImage2D", _wrap_glCopyTexImage2D, METH_VARARGS , _doc_glCopyTexImage2D},
	 {"glCopyTexSubImage1D", _wrap_glCopyTexSubImage1D, METH_VARARGS , _doc_glCopyTexSubImage1D},
	 {"glCopyTexSubImage2D", _wrap_glCopyTexSubImage2D, METH_VARARGS , _doc_glCopyTexSubImage2D},
	 {"glCullFace", _wrap_glCullFace, METH_VARARGS , _doc_glCullFace},
	 {"glDeleteLists", _wrap_glDeleteLists, METH_VARARGS , _doc_glDeleteLists},
	 {"glDeleteTextures", _wrap_glDeleteTextures, METH_VARARGS , _doc_glDeleteTextures},
	 {"glDepthFunc", _wrap_glDepthFunc, METH_VARARGS , _doc_glDepthFunc},
	 {"glDepthMask", _wrap_glDepthMask, METH_VARARGS , _doc_glDepthMask},
	 {"glDepthRange", _wrap_glDepthRange, METH_VARARGS , _doc_glDepthRange},
	 {"glDisable", _wrap_glDisable, METH_VARARGS , _doc_glDisable},
	 {"glDisableClientState", _wrap_glDisableClientState, METH_VARARGS , _doc_glDisableClientState},
	 {"glDrawArrays", _wrap_glDrawArrays, METH_VARARGS , _doc_glDrawArrays},
	 {"glDrawBuffer", _wrap_glDrawBuffer, METH_VARARGS , _doc_glDrawBuffer},
	 {"glDrawElements", _wrap_glDrawElements, METH_VARARGS , _doc_glDrawElements},
	 {"glDrawElementsub", _wrap_glDrawElementsub, METH_VARARGS , _doc_glDrawElementsub},
	 {"glDrawElementsus", _wrap_glDrawElementsus, METH_VARARGS , _doc_glDrawElementsus},
	 {"glDrawElementsui", _wrap_glDrawElementsui, METH_VARARGS , _doc_glDrawElementsui},
	 {"glDrawPixels", _wrap_glDrawPixels, METH_VARARGS , _doc_glDrawPixels},
	 {"glDrawPixelsub", _wrap_glDrawPixelsub, METH_VARARGS , _doc_glDrawPixelsub},
	 {"glDrawPixelsb", _wrap_glDrawPixelsb, METH_VARARGS , _doc_glDrawPixelsb},
	 {"glDrawPixelsus", _wrap_glDrawPixelsus, METH_VARARGS , _doc_glDrawPixelsus},
	 {"glDrawPixelss", _wrap_glDrawPixelss, METH_VARARGS , _doc_glDrawPixelss},
	 {"glDrawPixelsui", _wrap_glDrawPixelsui, METH_VARARGS , _doc_glDrawPixelsui},
	 {"glDrawPixelsi", _wrap_glDrawPixelsi, METH_VARARGS , _doc_glDrawPixelsi},
	 {"glDrawPixelsf", _wrap_glDrawPixelsf, METH_VARARGS , _doc_glDrawPixelsf},
	 {"glEdgeFlagPointer", _wrap_glEdgeFlagPointer, METH_VARARGS , _doc_glEdgeFlagPointer},
	 {"glEdgeFlagPointerb", _wrap_glEdgeFlagPointerb, METH_VARARGS , _doc_glEdgeFlagPointerb},
	 {"glEnable", _wrap_glEnable, METH_VARARGS , _doc_glEnable},
	 {"glEnableClientState", _wrap_glEnableClientState, METH_VARARGS , _doc_glEnableClientState},
	 {"glEnd", _wrap_glEnd, METH_VARARGS , _doc_glEnd},
	 {"glEndList", _wrap_glEndList, METH_VARARGS , _doc_glEndList},
	 {"glEvalMesh1", _wrap_glEvalMesh1, METH_VARARGS , _doc_glEvalMesh1},
	 {"glEvalMesh2", _wrap_glEvalMesh2, METH_VARARGS , _doc_glEvalMesh2},
	 {"glFeedbackBuffer", _wrap_glFeedbackBuffer, METH_VARARGS , _doc_glFeedbackBuffer},
	 {"glFinish", _wrap_glFinish, METH_VARARGS , _doc_glFinish},
	 {"glFlush", _wrap_glFlush, METH_VARARGS , _doc_glFlush},
	 {"glFogf", _wrap_glFogf, METH_VARARGS , _doc_glFogf},
	 {"glFogfv", _wrap_glFogfv, METH_VARARGS , _doc_glFogfv},
	 {"glFogi", _wrap_glFogi, METH_VARARGS , _doc_glFogi},
	 {"glFogiv", _wrap_glFogiv, METH_VARARGS , _doc_glFogiv},
	 {"glFrontFace", _wrap_glFrontFace, METH_VARARGS , _doc_glFrontFace},
	 {"glFrustum", _wrap_glFrustum, METH_VARARGS , _doc_glFrustum},
	 {"glGenLists", _wrap_glGenLists, METH_VARARGS , _doc_glGenLists},
	 {"glGenTextures", _wrap_glGenTextures, METH_VARARGS , _doc_glGenTextures},
	 {"glGetBooleanv", _wrap_glGetBooleanv, METH_VARARGS , _doc_glGetBooleanv},
	 {"glGetClipPlane", _wrap_glGetClipPlane, METH_VARARGS , _doc_glGetClipPlane},
	 {"glGetDoublev", _wrap_glGetDoublev, METH_VARARGS , _doc_glGetDoublev},
	 {"glGetFloatv", _wrap_glGetFloatv, METH_VARARGS , _doc_glGetFloatv},
	 {"glGetIntegerv", _wrap_glGetIntegerv, METH_VARARGS , _doc_glGetIntegerv},
	 {"glGetLightfv", _wrap_glGetLightfv, METH_VARARGS , _doc_glGetLightfv},
	 {"glGetLightiv", _wrap_glGetLightiv, METH_VARARGS , _doc_glGetLightiv},
	 {"glGetMapdv", _wrap_glGetMapdv, METH_VARARGS , _doc_glGetMapdv},
	 {"glGetMapfv", _wrap_glGetMapfv, METH_VARARGS , _doc_glGetMapfv},
	 {"glGetMapiv", _wrap_glGetMapiv, METH_VARARGS , _doc_glGetMapiv},
	 {"glGetMaterialfv", _wrap_glGetMaterialfv, METH_VARARGS , _doc_glGetMaterialfv},
	 {"glGetMaterialiv", _wrap_glGetMaterialiv, METH_VARARGS , _doc_glGetMaterialiv},
	 {"glGetPixelMapfv", _wrap_glGetPixelMapfv, METH_VARARGS , _doc_glGetPixelMapfv},
	 {"glGetPixelMapuiv", _wrap_glGetPixelMapuiv, METH_VARARGS , _doc_glGetPixelMapuiv},
	 {"glGetPixelMapusv", _wrap_glGetPixelMapusv, METH_VARARGS , _doc_glGetPixelMapusv},
	 {"glGetPolygonStipple", _wrap_glGetPolygonStipple, METH_VARARGS , _doc_glGetPolygonStipple},
	 {"glGetPolygonStippleub", _wrap_glGetPolygonStippleub, METH_VARARGS , _doc_glGetPolygonStippleub},
	 {"glGetString", _wrap_glGetString, METH_VARARGS , _doc_glGetString},
	 {"glGetTexEnvfv", _wrap_glGetTexEnvfv, METH_VARARGS , _doc_glGetTexEnvfv},
	 {"glGetTexEnviv", _wrap_glGetTexEnviv, METH_VARARGS , _doc_glGetTexEnviv},
	 {"glGetTexGendv", _wrap_glGetTexGendv, METH_VARARGS , _doc_glGetTexGendv},
	 {"glGetTexGenfv", _wrap_glGetTexGenfv, METH_VARARGS , _doc_glGetTexGenfv},
	 {"glGetTexGeniv", _wrap_glGetTexGeniv, METH_VARARGS , _doc_glGetTexGeniv},
	 {"glGetTexImage", _wrap_glGetTexImage, METH_VARARGS , _doc_glGetTexImage},
	 {"glGetTexImageub", _wrap_glGetTexImageub, METH_VARARGS , _doc_glGetTexImageub},
	 {"glGetTexImageb", _wrap_glGetTexImageb, METH_VARARGS , _doc_glGetTexImageb},
	 {"glGetTexImageus", _wrap_glGetTexImageus, METH_VARARGS , _doc_glGetTexImageus},
	 {"glGetTexImages", _wrap_glGetTexImages, METH_VARARGS , _doc_glGetTexImages},
	 {"glGetTexImageui", _wrap_glGetTexImageui, METH_VARARGS , _doc_glGetTexImageui},
	 {"glGetTexImagei", _wrap_glGetTexImagei, METH_VARARGS , _doc_glGetTexImagei},
	 {"glGetTexImagef", _wrap_glGetTexImagef, METH_VARARGS , _doc_glGetTexImagef},
	 {"glGetTexImaged", _wrap_glGetTexImaged, METH_VARARGS , _doc_glGetTexImaged},
	 {"glGetTexLevelParameterfv", _wrap_glGetTexLevelParameterfv, METH_VARARGS , _doc_glGetTexLevelParameterfv},
	 {"glGetTexLevelParameteriv", _wrap_glGetTexLevelParameteriv, METH_VARARGS , _doc_glGetTexLevelParameteriv},
	 {"glGetTexParameterfv", _wrap_glGetTexParameterfv, METH_VARARGS , _doc_glGetTexParameterfv},
	 {"glGetTexParameteriv", _wrap_glGetTexParameteriv, METH_VARARGS , _doc_glGetTexParameteriv},
	 {"glHint", _wrap_glHint, METH_VARARGS , _doc_glHint},
	 {"glIndexMask", _wrap_glIndexMask, METH_VARARGS , _doc_glIndexMask},
	 {"glIndexPointer", _wrap_glIndexPointer, METH_VARARGS , _doc_glIndexPointer},
	 {"glIndexPointerub", _wrap_glIndexPointerub, METH_VARARGS , _doc_glIndexPointerub},
	 {"glIndexPointerb", _wrap_glIndexPointerb, METH_VARARGS , _doc_glIndexPointerb},
	 {"glIndexPointers", _wrap_glIndexPointers, METH_VARARGS , _doc_glIndexPointers},
	 {"glIndexPointeri", _wrap_glIndexPointeri, METH_VARARGS , _doc_glIndexPointeri},
	 {"glIndexPointerf", _wrap_glIndexPointerf, METH_VARARGS , _doc_glIndexPointerf},
	 {"glIndexPointerd", _wrap_glIndexPointerd, METH_VARARGS , _doc_glIndexPointerd},
	 {"glInitNames", _wrap_glInitNames, METH_VARARGS , _doc_glInitNames},
	 {"glInterleavedArrays", _wrap_glInterleavedArrays, METH_VARARGS , _doc_glInterleavedArrays},
	 {"glIsEnabled", _wrap_glIsEnabled, METH_VARARGS , _doc_glIsEnabled},
	 {"glIsList", _wrap_glIsList, METH_VARARGS , _doc_glIsList},
	 {"glIsTexture", _wrap_glIsTexture, METH_VARARGS , _doc_glIsTexture},
	 {"glLightModelf", _wrap_glLightModelf, METH_VARARGS , _doc_glLightModelf},
	 {"glLightModelfv", _wrap_glLightModelfv, METH_VARARGS , _doc_glLightModelfv},
	 {"glLightModeli", _wrap_glLightModeli, METH_VARARGS , _doc_glLightModeli},
	 {"glLightModeliv", _wrap_glLightModeliv, METH_VARARGS , _doc_glLightModeliv},
	 {"glLightf", _wrap_glLightf, METH_VARARGS , _doc_glLightf},
	 {"glLightfv", _wrap_glLightfv, METH_VARARGS , _doc_glLightfv},
	 {"glLighti", _wrap_glLighti, METH_VARARGS , _doc_glLighti},
	 {"glLightiv", _wrap_glLightiv, METH_VARARGS , _doc_glLightiv},
	 {"glLineStipple", _wrap_glLineStipple, METH_VARARGS , _doc_glLineStipple},
	 {"glLineWidth", _wrap_glLineWidth, METH_VARARGS , _doc_glLineWidth},
	 {"glListBase", _wrap_glListBase, METH_VARARGS , _doc_glListBase},
	 {"glLoadIdentity", _wrap_glLoadIdentity, METH_VARARGS , _doc_glLoadIdentity},
	 {"glLoadMatrixd", _wrap_glLoadMatrixd, METH_VARARGS , _doc_glLoadMatrixd},
	 {"glLoadMatrixf", _wrap_glLoadMatrixf, METH_VARARGS , _doc_glLoadMatrixf},
	 {"glLoadName", _wrap_glLoadName, METH_VARARGS , _doc_glLoadName},
	 {"glLogicOp", _wrap_glLogicOp, METH_VARARGS , _doc_glLogicOp},
	 {"glMap1d", _wrap_glMap1d, METH_VARARGS , _doc_glMap1d},
	 {"glMap1f", _wrap_glMap1f, METH_VARARGS , _doc_glMap1f},
	 {"glMap2d", _wrap_glMap2d, METH_VARARGS , _doc_glMap2d},
	 {"glMap2f", _wrap_glMap2f, METH_VARARGS , _doc_glMap2f},
	 {"glMapGrid1d", _wrap_glMapGrid1d, METH_VARARGS , _doc_glMapGrid1d},
	 {"glMapGrid1f", _wrap_glMapGrid1f, METH_VARARGS , _doc_glMapGrid1f},
	 {"glMapGrid2d", _wrap_glMapGrid2d, METH_VARARGS , _doc_glMapGrid2d},
	 {"glMapGrid2f", _wrap_glMapGrid2f, METH_VARARGS , _doc_glMapGrid2f},
	 {"glMatrixMode", _wrap_glMatrixMode, METH_VARARGS , _doc_glMatrixMode},
	 {"glMultMatrixd", _wrap_glMultMatrixd, METH_VARARGS , _doc_glMultMatrixd},
	 {"glMultMatrixf", _wrap_glMultMatrixf, METH_VARARGS , _doc_glMultMatrixf},
	 {"glNewList", _wrap_glNewList, METH_VARARGS , _doc_glNewList},
	 {"glNormalPointer", _wrap_glNormalPointer, METH_VARARGS , _doc_glNormalPointer},
	 {"glNormalPointerb", _wrap_glNormalPointerb, METH_VARARGS , _doc_glNormalPointerb},
	 {"glNormalPointers", _wrap_glNormalPointers, METH_VARARGS , _doc_glNormalPointers},
	 {"glNormalPointeri", _wrap_glNormalPointeri, METH_VARARGS , _doc_glNormalPointeri},
	 {"glNormalPointerf", _wrap_glNormalPointerf, METH_VARARGS , _doc_glNormalPointerf},
	 {"glNormalPointerd", _wrap_glNormalPointerd, METH_VARARGS , _doc_glNormalPointerd},
	 {"glOrtho", _wrap_glOrtho, METH_VARARGS , _doc_glOrtho},
	 {"glPassThrough", _wrap_glPassThrough, METH_VARARGS , _doc_glPassThrough},
	 {"glPixelMapfv", _wrap_glPixelMapfv, METH_VARARGS , _doc_glPixelMapfv},
	 {"glPixelMapuiv", _wrap_glPixelMapuiv, METH_VARARGS , _doc_glPixelMapuiv},
	 {"glPixelMapusv", _wrap_glPixelMapusv, METH_VARARGS , _doc_glPixelMapusv},
	 {"glPixelStoref", _wrap_glPixelStoref, METH_VARARGS , _doc_glPixelStoref},
	 {"glPixelStorei", _wrap_glPixelStorei, METH_VARARGS , _doc_glPixelStorei},
	 {"glPixelTransferf", _wrap_glPixelTransferf, METH_VARARGS , _doc_glPixelTransferf},
	 {"glPixelTransferi", _wrap_glPixelTransferi, METH_VARARGS , _doc_glPixelTransferi},
	 {"glPixelZoom", _wrap_glPixelZoom, METH_VARARGS , _doc_glPixelZoom},
	 {"glPointSize", _wrap_glPointSize, METH_VARARGS , _doc_glPointSize},
	 {"glPolygonMode", _wrap_glPolygonMode, METH_VARARGS , _doc_glPolygonMode},
	 {"glPolygonOffset", _wrap_glPolygonOffset, METH_VARARGS , _doc_glPolygonOffset},
	 {"glPolygonStipple", _wrap_glPolygonStipple, METH_VARARGS , _doc_glPolygonStipple},
	 {"glPolygonStippleub", _wrap_glPolygonStippleub, METH_VARARGS , _doc_glPolygonStippleub},
	 {"glPopAttrib", _wrap_glPopAttrib, METH_VARARGS , _doc_glPopAttrib},
	 {"glPopClientAttrib", _wrap_glPopClientAttrib, METH_VARARGS , _doc_glPopClientAttrib},
	 {"glPopMatrix", _wrap_glPopMatrix, METH_VARARGS , _doc_glPopMatrix},
	 {"glPopName", _wrap_glPopName, METH_VARARGS , _doc_glPopName},
	 {"glPrioritizeTextures", _wrap_glPrioritizeTextures, METH_VARARGS , _doc_glPrioritizeTextures},
	 {"glPushAttrib", _wrap_glPushAttrib, METH_VARARGS , _doc_glPushAttrib},
	 {"glPushClientAttrib", _wrap_glPushClientAttrib, METH_VARARGS , _doc_glPushClientAttrib},
	 {"glPushMatrix", _wrap_glPushMatrix, METH_VARARGS , _doc_glPushMatrix},
	 {"glPushName", _wrap_glPushName, METH_VARARGS , _doc_glPushName},
	 {"glRasterPos2d", _wrap_glRasterPos2d, METH_VARARGS , _doc_glRasterPos2d},
	 {"glRasterPos2dv", _wrap_glRasterPos2dv, METH_VARARGS , _doc_glRasterPos2dv},
	 {"glRasterPos2f", _wrap_glRasterPos2f, METH_VARARGS , _doc_glRasterPos2f},
	 {"glRasterPos2fv", _wrap_glRasterPos2fv, METH_VARARGS , _doc_glRasterPos2fv},
	 {"glRasterPos2i", _wrap_glRasterPos2i, METH_VARARGS , _doc_glRasterPos2i},
	 {"glRasterPos2iv", _wrap_glRasterPos2iv, METH_VARARGS , _doc_glRasterPos2iv},
	 {"glRasterPos2s", _wrap_glRasterPos2s, METH_VARARGS , _doc_glRasterPos2s},
	 {"glRasterPos2sv", _wrap_glRasterPos2sv, METH_VARARGS , _doc_glRasterPos2sv},
	 {"glRasterPos3d", _wrap_glRasterPos3d, METH_VARARGS , _doc_glRasterPos3d},
	 {"glRasterPos3dv", _wrap_glRasterPos3dv, METH_VARARGS , _doc_glRasterPos3dv},
	 {"glRasterPos3f", _wrap_glRasterPos3f, METH_VARARGS , _doc_glRasterPos3f},
	 {"glRasterPos3fv", _wrap_glRasterPos3fv, METH_VARARGS , _doc_glRasterPos3fv},
	 {"glRasterPos3i", _wrap_glRasterPos3i, METH_VARARGS , _doc_glRasterPos3i},
	 {"glRasterPos3iv", _wrap_glRasterPos3iv, METH_VARARGS , _doc_glRasterPos3iv},
	 {"glRasterPos3s", _wrap_glRasterPos3s, METH_VARARGS , _doc_glRasterPos3s},
	 {"glRasterPos3sv", _wrap_glRasterPos3sv, METH_VARARGS , _doc_glRasterPos3sv},
	 {"glRasterPos4d", _wrap_glRasterPos4d, METH_VARARGS , _doc_glRasterPos4d},
	 {"glRasterPos4dv", _wrap_glRasterPos4dv, METH_VARARGS , _doc_glRasterPos4dv},
	 {"glRasterPos4f", _wrap_glRasterPos4f, METH_VARARGS , _doc_glRasterPos4f},
	 {"glRasterPos4fv", _wrap_glRasterPos4fv, METH_VARARGS , _doc_glRasterPos4fv},
	 {"glRasterPos4i", _wrap_glRasterPos4i, METH_VARARGS , _doc_glRasterPos4i},
	 {"glRasterPos4iv", _wrap_glRasterPos4iv, METH_VARARGS , _doc_glRasterPos4iv},
	 {"glRasterPos4s", _wrap_glRasterPos4s, METH_VARARGS , _doc_glRasterPos4s},
	 {"glRasterPos4sv", _wrap_glRasterPos4sv, METH_VARARGS , _doc_glRasterPos4sv},
	 {"glReadBuffer", _wrap_glReadBuffer, METH_VARARGS , _doc_glReadBuffer},
	 {"glReadPixels", _wrap_glReadPixels, METH_VARARGS , _doc_glReadPixels},
	 {"glReadPixelsub", _wrap_glReadPixelsub, METH_VARARGS , _doc_glReadPixelsub},
	 {"glReadPixelsb", _wrap_glReadPixelsb, METH_VARARGS , _doc_glReadPixelsb},
	 {"glReadPixelsus", _wrap_glReadPixelsus, METH_VARARGS , _doc_glReadPixelsus},
	 {"glReadPixelss", _wrap_glReadPixelss, METH_VARARGS , _doc_glReadPixelss},
	 {"glReadPixelsui", _wrap_glReadPixelsui, METH_VARARGS , _doc_glReadPixelsui},
	 {"glReadPixelsi", _wrap_glReadPixelsi, METH_VARARGS , _doc_glReadPixelsi},
	 {"glReadPixelsf", _wrap_glReadPixelsf, METH_VARARGS , _doc_glReadPixelsf},
	 {"glReadPixelsd", _wrap_glReadPixelsd, METH_VARARGS , _doc_glReadPixelsd},
	 {"glRectd", _wrap_glRectd, METH_VARARGS , _doc_glRectd},
	 {"glRectdv", _wrap_glRectdv, METH_VARARGS , _doc_glRectdv},
	 {"glRectf", _wrap_glRectf, METH_VARARGS , _doc_glRectf},
	 {"glRectfv", _wrap_glRectfv, METH_VARARGS , _doc_glRectfv},
	 {"glRecti", _wrap_glRecti, METH_VARARGS , _doc_glRecti},
	 {"glRectiv", _wrap_glRectiv, METH_VARARGS , _doc_glRectiv},
	 {"glRects", _wrap_glRects, METH_VARARGS , _doc_glRects},
	 {"glRectsv", _wrap_glRectsv, METH_VARARGS , _doc_glRectsv},
	 {"glRenderMode", _wrap_glRenderMode, METH_VARARGS , _doc_glRenderMode},
	 {"glRotated", _wrap_glRotated, METH_VARARGS , _doc_glRotated},
	 {"glRotatef", _wrap_glRotatef, METH_VARARGS , _doc_glRotatef},
	 {"glScaled", _wrap_glScaled, METH_VARARGS , _doc_glScaled},
	 {"glScalef", _wrap_glScalef, METH_VARARGS , _doc_glScalef},
	 {"glScissor", _wrap_glScissor, METH_VARARGS , _doc_glScissor},
	 {"glSelectBuffer", _wrap_glSelectBuffer, METH_VARARGS , _doc_glSelectBuffer},
	 {"glShadeModel", _wrap_glShadeModel, METH_VARARGS , _doc_glShadeModel},
	 {"glStencilFunc", _wrap_glStencilFunc, METH_VARARGS , _doc_glStencilFunc},
	 {"glStencilMask", _wrap_glStencilMask, METH_VARARGS , _doc_glStencilMask},
	 {"glStencilOp", _wrap_glStencilOp, METH_VARARGS , _doc_glStencilOp},
	 {"glTexCoordPointer", _wrap_glTexCoordPointer, METH_VARARGS , _doc_glTexCoordPointer},
	 {"glTexCoordPointerb", _wrap_glTexCoordPointerb, METH_VARARGS , _doc_glTexCoordPointerb},
	 {"glTexCoordPointers", _wrap_glTexCoordPointers, METH_VARARGS , _doc_glTexCoordPointers},
	 {"glTexCoordPointeri", _wrap_glTexCoordPointeri, METH_VARARGS , _doc_glTexCoordPointeri},
	 {"glTexCoordPointerf", _wrap_glTexCoordPointerf, METH_VARARGS , _doc_glTexCoordPointerf},
	 {"glTexCoordPointerd", _wrap_glTexCoordPointerd, METH_VARARGS , _doc_glTexCoordPointerd},
	 {"glTexEnvf", _wrap_glTexEnvf, METH_VARARGS , _doc_glTexEnvf},
	 {"glTexEnvfv", _wrap_glTexEnvfv, METH_VARARGS , _doc_glTexEnvfv},
	 {"glTexEnvi", _wrap_glTexEnvi, METH_VARARGS , _doc_glTexEnvi},
	 {"glTexEnviv", _wrap_glTexEnviv, METH_VARARGS , _doc_glTexEnviv},
	 {"glTexGend", _wrap_glTexGend, METH_VARARGS , _doc_glTexGend},
	 {"glTexGendv", _wrap_glTexGendv, METH_VARARGS , _doc_glTexGendv},
	 {"glTexGenf", _wrap_glTexGenf, METH_VARARGS , _doc_glTexGenf},
	 {"glTexGenfv", _wrap_glTexGenfv, METH_VARARGS , _doc_glTexGenfv},
	 {"glTexGeni", _wrap_glTexGeni, METH_VARARGS , _doc_glTexGeni},
	 {"glTexGeniv", _wrap_glTexGeniv, METH_VARARGS , _doc_glTexGeniv},
	 {"glTexImage1D", _wrap_glTexImage1D, METH_VARARGS , _doc_glTexImage1D},
	 {"glTexImage1Dub", _wrap_glTexImage1Dub, METH_VARARGS , _doc_glTexImage1Dub},
	 {"glTexImage1Db", _wrap_glTexImage1Db, METH_VARARGS , _doc_glTexImage1Db},
	 {"glTexImage1Dus", _wrap_glTexImage1Dus, METH_VARARGS , _doc_glTexImage1Dus},
	 {"glTexImage1Ds", _wrap_glTexImage1Ds, METH_VARARGS , _doc_glTexImage1Ds},
	 {"glTexImage1Dui", _wrap_glTexImage1Dui, METH_VARARGS , _doc_glTexImage1Dui},
	 {"glTexImage1Di", _wrap_glTexImage1Di, METH_VARARGS , _doc_glTexImage1Di},
	 {"glTexImage1Df", _wrap_glTexImage1Df, METH_VARARGS , _doc_glTexImage1Df},
	 {"glTexImage2D", _wrap_glTexImage2D, METH_VARARGS , _doc_glTexImage2D},
	 {"glTexImage2Dub", _wrap_glTexImage2Dub, METH_VARARGS , _doc_glTexImage2Dub},
	 {"glTexImage2Db", _wrap_glTexImage2Db, METH_VARARGS , _doc_glTexImage2Db},
	 {"glTexImage2Dus", _wrap_glTexImage2Dus, METH_VARARGS , _doc_glTexImage2Dus},
	 {"glTexImage2Ds", _wrap_glTexImage2Ds, METH_VARARGS , _doc_glTexImage2Ds},
	 {"glTexImage2Dui", _wrap_glTexImage2Dui, METH_VARARGS , _doc_glTexImage2Dui},
	 {"glTexImage2Di", _wrap_glTexImage2Di, METH_VARARGS , _doc_glTexImage2Di},
	 {"glTexImage2Df", _wrap_glTexImage2Df, METH_VARARGS , _doc_glTexImage2Df},
	 {"glTexParameterf", _wrap_glTexParameterf, METH_VARARGS , _doc_glTexParameterf},
	 {"glTexParameterfv", _wrap_glTexParameterfv, METH_VARARGS , _doc_glTexParameterfv},
	 {"glTexParameteri", _wrap_glTexParameteri, METH_VARARGS , _doc_glTexParameteri},
	 {"glTexParameteriv", _wrap_glTexParameteriv, METH_VARARGS , _doc_glTexParameteriv},
	 {"glTexSubImage1D", _wrap_glTexSubImage1D, METH_VARARGS , _doc_glTexSubImage1D},
	 {"glTexSubImage1Dub", _wrap_glTexSubImage1Dub, METH_VARARGS , _doc_glTexSubImage1Dub},
	 {"glTexSubImage1Db", _wrap_glTexSubImage1Db, METH_VARARGS , _doc_glTexSubImage1Db},
	 {"glTexSubImage1Dus", _wrap_glTexSubImage1Dus, METH_VARARGS , _doc_glTexSubImage1Dus},
	 {"glTexSubImage1Ds", _wrap_glTexSubImage1Ds, METH_VARARGS , _doc_glTexSubImage1Ds},
	 {"glTexSubImage1Dui", _wrap_glTexSubImage1Dui, METH_VARARGS , _doc_glTexSubImage1Dui},
	 {"glTexSubImage1Di", _wrap_glTexSubImage1Di, METH_VARARGS , _doc_glTexSubImage1Di},
	 {"glTexSubImage1Df", _wrap_glTexSubImage1Df, METH_VARARGS , _doc_glTexSubImage1Df},
	 {"glTexSubImage2D", _wrap_glTexSubImage2D, METH_VARARGS , _doc_glTexSubImage2D},
	 {"glTexSubImage2Dub", _wrap_glTexSubImage2Dub, METH_VARARGS , _doc_glTexSubImage2Dub},
	 {"glTexSubImage2Db", _wrap_glTexSubImage2Db, METH_VARARGS , _doc_glTexSubImage2Db},
	 {"glTexSubImage2Dus", _wrap_glTexSubImage2Dus, METH_VARARGS , _doc_glTexSubImage2Dus},
	 {"glTexSubImage2Ds", _wrap_glTexSubImage2Ds, METH_VARARGS , _doc_glTexSubImage2Ds},
	 {"glTexSubImage2Dui", _wrap_glTexSubImage2Dui, METH_VARARGS , _doc_glTexSubImage2Dui},
	 {"glTexSubImage2Di", _wrap_glTexSubImage2Di, METH_VARARGS , _doc_glTexSubImage2Di},
	 {"glTexSubImage2Df", _wrap_glTexSubImage2Df, METH_VARARGS , _doc_glTexSubImage2Df},
	 {"glTranslated", _wrap_glTranslated, METH_VARARGS , _doc_glTranslated},
	 {"glTranslatef", _wrap_glTranslatef, METH_VARARGS , _doc_glTranslatef},
	 {"glVertexPointer", _wrap_glVertexPointer, METH_VARARGS , _doc_glVertexPointer},
	 {"glVertexPointerb", _wrap_glVertexPointerb, METH_VARARGS , _doc_glVertexPointerb},
	 {"glVertexPointers", _wrap_glVertexPointers, METH_VARARGS , _doc_glVertexPointers},
	 {"glVertexPointeri", _wrap_glVertexPointeri, METH_VARARGS , _doc_glVertexPointeri},
	 {"glVertexPointerf", _wrap_glVertexPointerf, METH_VARARGS , _doc_glVertexPointerf},
	 {"glVertexPointerd", _wrap_glVertexPointerd, METH_VARARGS , _doc_glVertexPointerd},
	 {"glViewport", _wrap_glViewport, METH_VARARGS , _doc_glViewport},
	 { NULL, NULL }
};

#ifdef __cplusplus
}
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */


static swig_type_info *swig_types_initial[] = {
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
    { SWIG_PY_STRING, "__version__", 0, 0, (void *) "1.75", 0 }, 
    { SWIG_PY_STRING, "__date__", 0, 0, (void *) "2001/08/27 03:58:17", 0 }, 
    { SWIG_PY_INT,     "__api_version__", (long) 257, 0, 0, 0},
    { SWIG_PY_STRING, "__author__", 0, 0, (void *) "Tarn Weisner Burton <twburton@users.sourceforge.net>\nMike C. Fletcher <mcfletch@users.sourceforge.net>", 0 }, 
    { SWIG_PY_STRING, "__doc__", 0, 0, (void *) "For general information about OpenGL, including documentation, see http://www.opengl.org\n\nOther sites that might be useful include:\n    MSDN:  http://msdn.microsoft.com/library/default.asp?url=/library/en-us/opengl/hh/opengl/openglstart_9uw5.asp?frame=true\n    Mesa3d:  http://www.mesa3d.org\n    OpenGL at Apple:  http://developer.apple.com/opengl", 0 }, 
    { SWIG_PY_INT,     "GL_VERSION_1_1", (long) 1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM", (long) 0x0100, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LOAD", (long) 0x0101, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RETURN", (long) 0x0102, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MULT", (long) 0x0103, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ADD", (long) 0x0104, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NEVER", (long) 0x0200, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LESS", (long) 0x0201, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EQUAL", (long) 0x0202, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LEQUAL", (long) 0x0203, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GREATER", (long) 0x0204, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NOTEQUAL", (long) 0x0205, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GEQUAL", (long) 0x0206, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALWAYS", (long) 0x0207, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_BIT", (long) 0x00000001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_BIT", (long) 0x00000002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_BIT", (long) 0x00000004, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_BIT", (long) 0x00000008, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_STIPPLE_BIT", (long) 0x00000010, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MODE_BIT", (long) 0x00000020, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHTING_BIT", (long) 0x00000040, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_BIT", (long) 0x00000080, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_BUFFER_BIT", (long) 0x00000100, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_BUFFER_BIT", (long) 0x00000200, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_BUFFER_BIT", (long) 0x00000400, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VIEWPORT_BIT", (long) 0x00000800, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TRANSFORM_BIT", (long) 0x00001000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ENABLE_BIT", (long) 0x00002000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_BUFFER_BIT", (long) 0x00004000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_HINT_BIT", (long) 0x00008000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EVAL_BIT", (long) 0x00010000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIST_BIT", (long) 0x00020000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BIT", (long) 0x00040000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SCISSOR_BIT", (long) 0x00080000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALL_ATTRIB_BITS", (long) 0x000fffff, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINTS", (long) 0x0000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINES", (long) 0x0001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_LOOP", (long) 0x0002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_STRIP", (long) 0x0003, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TRIANGLES", (long) 0x0004, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TRIANGLE_STRIP", (long) 0x0005, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TRIANGLE_FAN", (long) 0x0006, 0, 0, 0},
    { SWIG_PY_INT,     "GL_QUADS", (long) 0x0007, 0, 0, 0},
    { SWIG_PY_INT,     "GL_QUAD_STRIP", (long) 0x0008, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON", (long) 0x0009, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ZERO", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ONE", (long) 1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SRC_COLOR", (long) 0x0300, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ONE_MINUS_SRC_COLOR", (long) 0x0301, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SRC_ALPHA", (long) 0x0302, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ONE_MINUS_SRC_ALPHA", (long) 0x0303, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DST_ALPHA", (long) 0x0304, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ONE_MINUS_DST_ALPHA", (long) 0x0305, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DST_COLOR", (long) 0x0306, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ONE_MINUS_DST_COLOR", (long) 0x0307, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SRC_ALPHA_SATURATE", (long) 0x0308, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TRUE", (long) 1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FALSE", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE0", (long) 0x3000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE1", (long) 0x3001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE2", (long) 0x3002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE3", (long) 0x3003, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE4", (long) 0x3004, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIP_PLANE5", (long) 0x3005, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BYTE", (long) 0x1400, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNSIGNED_BYTE", (long) 0x1401, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SHORT", (long) 0x1402, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNSIGNED_SHORT", (long) 0x1403, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INT", (long) 0x1404, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNSIGNED_INT", (long) 0x1405, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FLOAT", (long) 0x1406, 0, 0, 0},
    { SWIG_PY_INT,     "GL_2_BYTES", (long) 0x1407, 0, 0, 0},
    { SWIG_PY_INT,     "GL_3_BYTES", (long) 0x1408, 0, 0, 0},
    { SWIG_PY_INT,     "GL_4_BYTES", (long) 0x1409, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DOUBLE", (long) 0x140A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NONE", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FRONT_LEFT", (long) 0x0400, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FRONT_RIGHT", (long) 0x0401, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BACK_LEFT", (long) 0x0402, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BACK_RIGHT", (long) 0x0403, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FRONT", (long) 0x0404, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BACK", (long) 0x0405, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LEFT", (long) 0x0406, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RIGHT", (long) 0x0407, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FRONT_AND_BACK", (long) 0x0408, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUX0", (long) 0x0409, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUX1", (long) 0x040A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUX2", (long) 0x040B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUX3", (long) 0x040C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NO_ERROR", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INVALID_ENUM", (long) 0x0500, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INVALID_VALUE", (long) 0x0501, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INVALID_OPERATION", (long) 0x0502, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STACK_OVERFLOW", (long) 0x0503, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STACK_UNDERFLOW", (long) 0x0504, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OUT_OF_MEMORY", (long) 0x0505, 0, 0, 0},
    { SWIG_PY_INT,     "GL_2D", (long) 0x0600, 0, 0, 0},
    { SWIG_PY_INT,     "GL_3D", (long) 0x0601, 0, 0, 0},
    { SWIG_PY_INT,     "GL_3D_COLOR", (long) 0x0602, 0, 0, 0},
    { SWIG_PY_INT,     "GL_3D_COLOR_TEXTURE", (long) 0x0603, 0, 0, 0},
    { SWIG_PY_INT,     "GL_4D_COLOR_TEXTURE", (long) 0x0604, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PASS_THROUGH_TOKEN", (long) 0x0700, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_TOKEN", (long) 0x0701, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_TOKEN", (long) 0x0702, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_TOKEN", (long) 0x0703, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BITMAP_TOKEN", (long) 0x0704, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DRAW_PIXEL_TOKEN", (long) 0x0705, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COPY_PIXEL_TOKEN", (long) 0x0706, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_RESET_TOKEN", (long) 0x0707, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EXP", (long) 0x0800, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EXP2", (long) 0x0801, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CW", (long) 0x0900, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CCW", (long) 0x0901, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COEFF", (long) 0x0A00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ORDER", (long) 0x0A01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DOMAIN", (long) 0x0A02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_COLOR", (long) 0x0B00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_INDEX", (long) 0x0B01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_NORMAL", (long) 0x0B02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_TEXTURE_COORDS", (long) 0x0B03, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_COLOR", (long) 0x0B04, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_INDEX", (long) 0x0B05, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_TEXTURE_COORDS", (long) 0x0B06, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_POSITION", (long) 0x0B07, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_POSITION_VALID", (long) 0x0B08, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CURRENT_RASTER_DISTANCE", (long) 0x0B09, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_SMOOTH", (long) 0x0B10, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_SIZE", (long) 0x0B11, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_SIZE_RANGE", (long) 0x0B12, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_SIZE_GRANULARITY", (long) 0x0B13, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_SMOOTH", (long) 0x0B20, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_WIDTH", (long) 0x0B21, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_WIDTH_RANGE", (long) 0x0B22, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_WIDTH_GRANULARITY", (long) 0x0B23, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_STIPPLE", (long) 0x0B24, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_STIPPLE_PATTERN", (long) 0x0B25, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_STIPPLE_REPEAT", (long) 0x0B26, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIST_MODE", (long) 0x0B30, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_LIST_NESTING", (long) 0x0B31, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIST_BASE", (long) 0x0B32, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIST_INDEX", (long) 0x0B33, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_MODE", (long) 0x0B40, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_SMOOTH", (long) 0x0B41, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_STIPPLE", (long) 0x0B42, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EDGE_FLAG", (long) 0x0B43, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CULL_FACE", (long) 0x0B44, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CULL_FACE_MODE", (long) 0x0B45, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FRONT_FACE", (long) 0x0B46, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHTING", (long) 0x0B50, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT_MODEL_LOCAL_VIEWER", (long) 0x0B51, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT_MODEL_TWO_SIDE", (long) 0x0B52, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT_MODEL_AMBIENT", (long) 0x0B53, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SHADE_MODEL", (long) 0x0B54, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_MATERIAL_FACE", (long) 0x0B55, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_MATERIAL_PARAMETER", (long) 0x0B56, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_MATERIAL", (long) 0x0B57, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG", (long) 0x0B60, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_INDEX", (long) 0x0B61, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_DENSITY", (long) 0x0B62, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_START", (long) 0x0B63, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_END", (long) 0x0B64, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_MODE", (long) 0x0B65, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_COLOR", (long) 0x0B66, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_RANGE", (long) 0x0B70, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_TEST", (long) 0x0B71, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_WRITEMASK", (long) 0x0B72, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_CLEAR_VALUE", (long) 0x0B73, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_FUNC", (long) 0x0B74, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_CLEAR_VALUE", (long) 0x0B80, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_TEST", (long) 0x0B90, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_CLEAR_VALUE", (long) 0x0B91, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_FUNC", (long) 0x0B92, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_VALUE_MASK", (long) 0x0B93, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_FAIL", (long) 0x0B94, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_PASS_DEPTH_FAIL", (long) 0x0B95, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_PASS_DEPTH_PASS", (long) 0x0B96, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_REF", (long) 0x0B97, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_WRITEMASK", (long) 0x0B98, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MATRIX_MODE", (long) 0x0BA0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NORMALIZE", (long) 0x0BA1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VIEWPORT", (long) 0x0BA2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MODELVIEW_STACK_DEPTH", (long) 0x0BA3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PROJECTION_STACK_DEPTH", (long) 0x0BA4, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_STACK_DEPTH", (long) 0x0BA5, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MODELVIEW_MATRIX", (long) 0x0BA6, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PROJECTION_MATRIX", (long) 0x0BA7, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_MATRIX", (long) 0x0BA8, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ATTRIB_STACK_DEPTH", (long) 0x0BB0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIENT_ATTRIB_STACK_DEPTH", (long) 0x0BB1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_TEST", (long) 0x0BC0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_TEST_FUNC", (long) 0x0BC1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_TEST_REF", (long) 0x0BC2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DITHER", (long) 0x0BD0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLEND_DST", (long) 0x0BE0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLEND_SRC", (long) 0x0BE1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLEND", (long) 0x0BE2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LOGIC_OP_MODE", (long) 0x0BF0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_LOGIC_OP", (long) 0x0BF1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_LOGIC_OP", (long) 0x0BF2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUX_BUFFERS", (long) 0x0C00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DRAW_BUFFER", (long) 0x0C01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_READ_BUFFER", (long) 0x0C02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SCISSOR_BOX", (long) 0x0C10, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SCISSOR_TEST", (long) 0x0C11, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_CLEAR_VALUE", (long) 0x0C20, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_WRITEMASK", (long) 0x0C21, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_CLEAR_VALUE", (long) 0x0C22, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_WRITEMASK", (long) 0x0C23, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_MODE", (long) 0x0C30, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA_MODE", (long) 0x0C31, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DOUBLEBUFFER", (long) 0x0C32, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STEREO", (long) 0x0C33, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RENDER_MODE", (long) 0x0C40, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PERSPECTIVE_CORRECTION_HINT", (long) 0x0C50, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT_SMOOTH_HINT", (long) 0x0C51, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE_SMOOTH_HINT", (long) 0x0C52, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_SMOOTH_HINT", (long) 0x0C53, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FOG_HINT", (long) 0x0C54, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GEN_S", (long) 0x0C60, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GEN_T", (long) 0x0C61, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GEN_R", (long) 0x0C62, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GEN_Q", (long) 0x0C63, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_I", (long) 0x0C70, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_S_TO_S", (long) 0x0C71, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_R", (long) 0x0C72, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_G", (long) 0x0C73, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_B", (long) 0x0C74, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_A", (long) 0x0C75, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_R_TO_R", (long) 0x0C76, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_G_TO_G", (long) 0x0C77, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_B_TO_B", (long) 0x0C78, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_A_TO_A", (long) 0x0C79, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_I_SIZE", (long) 0x0CB0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_S_TO_S_SIZE", (long) 0x0CB1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_R_SIZE", (long) 0x0CB2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_G_SIZE", (long) 0x0CB3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_B_SIZE", (long) 0x0CB4, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_I_TO_A_SIZE", (long) 0x0CB5, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_R_TO_R_SIZE", (long) 0x0CB6, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_G_TO_G_SIZE", (long) 0x0CB7, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_B_TO_B_SIZE", (long) 0x0CB8, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PIXEL_MAP_A_TO_A_SIZE", (long) 0x0CB9, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_SWAP_BYTES", (long) 0x0CF0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_LSB_FIRST", (long) 0x0CF1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_ROW_LENGTH", (long) 0x0CF2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_SKIP_ROWS", (long) 0x0CF3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_SKIP_PIXELS", (long) 0x0CF4, 0, 0, 0},
    { SWIG_PY_INT,     "GL_UNPACK_ALIGNMENT", (long) 0x0CF5, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_SWAP_BYTES", (long) 0x0D00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_LSB_FIRST", (long) 0x0D01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_ROW_LENGTH", (long) 0x0D02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_SKIP_ROWS", (long) 0x0D03, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_SKIP_PIXELS", (long) 0x0D04, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PACK_ALIGNMENT", (long) 0x0D05, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP_COLOR", (long) 0x0D10, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP_STENCIL", (long) 0x0D11, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_SHIFT", (long) 0x0D12, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_OFFSET", (long) 0x0D13, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RED_SCALE", (long) 0x0D14, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RED_BIAS", (long) 0x0D15, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ZOOM_X", (long) 0x0D16, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ZOOM_Y", (long) 0x0D17, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GREEN_SCALE", (long) 0x0D18, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GREEN_BIAS", (long) 0x0D19, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLUE_SCALE", (long) 0x0D1A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLUE_BIAS", (long) 0x0D1B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_SCALE", (long) 0x0D1C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_BIAS", (long) 0x0D1D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_SCALE", (long) 0x0D1E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_BIAS", (long) 0x0D1F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_EVAL_ORDER", (long) 0x0D30, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_LIGHTS", (long) 0x0D31, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_CLIP_PLANES", (long) 0x0D32, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_TEXTURE_SIZE", (long) 0x0D33, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_PIXEL_MAP_TABLE", (long) 0x0D34, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_ATTRIB_STACK_DEPTH", (long) 0x0D35, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_MODELVIEW_STACK_DEPTH", (long) 0x0D36, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_NAME_STACK_DEPTH", (long) 0x0D37, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_PROJECTION_STACK_DEPTH", (long) 0x0D38, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_TEXTURE_STACK_DEPTH", (long) 0x0D39, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_VIEWPORT_DIMS", (long) 0x0D3A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH", (long) 0x0D3B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SUBPIXEL_BITS", (long) 0x0D50, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_BITS", (long) 0x0D51, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RED_BITS", (long) 0x0D52, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GREEN_BITS", (long) 0x0D53, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLUE_BITS", (long) 0x0D54, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA_BITS", (long) 0x0D55, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_BITS", (long) 0x0D56, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_BITS", (long) 0x0D57, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_RED_BITS", (long) 0x0D58, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_GREEN_BITS", (long) 0x0D59, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_BLUE_BITS", (long) 0x0D5A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ACCUM_ALPHA_BITS", (long) 0x0D5B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NAME_STACK_DEPTH", (long) 0x0D70, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AUTO_NORMAL", (long) 0x0D80, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_COLOR_4", (long) 0x0D90, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_INDEX", (long) 0x0D91, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_NORMAL", (long) 0x0D92, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_TEXTURE_COORD_1", (long) 0x0D93, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_TEXTURE_COORD_2", (long) 0x0D94, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_TEXTURE_COORD_3", (long) 0x0D95, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_TEXTURE_COORD_4", (long) 0x0D96, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_VERTEX_3", (long) 0x0D97, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_VERTEX_4", (long) 0x0D98, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_COLOR_4", (long) 0x0DB0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_INDEX", (long) 0x0DB1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_NORMAL", (long) 0x0DB2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_TEXTURE_COORD_1", (long) 0x0DB3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_TEXTURE_COORD_2", (long) 0x0DB4, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_TEXTURE_COORD_3", (long) 0x0DB5, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_TEXTURE_COORD_4", (long) 0x0DB6, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_VERTEX_3", (long) 0x0DB7, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_VERTEX_4", (long) 0x0DB8, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_GRID_DOMAIN", (long) 0x0DD0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP1_GRID_SEGMENTS", (long) 0x0DD1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_GRID_DOMAIN", (long) 0x0DD2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MAP2_GRID_SEGMENTS", (long) 0x0DD3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_1D", (long) 0x0DE0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_2D", (long) 0x0DE1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FEEDBACK_BUFFER_POINTER", (long) 0x0DF0, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FEEDBACK_BUFFER_SIZE", (long) 0x0DF1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FEEDBACK_BUFFER_TYPE", (long) 0x0DF2, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SELECTION_BUFFER_POINTER", (long) 0x0DF3, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SELECTION_BUFFER_SIZE", (long) 0x0DF4, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_WIDTH", (long) 0x1000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_HEIGHT", (long) 0x1001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_INTERNAL_FORMAT", (long) 0x1003, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BORDER_COLOR", (long) 0x1004, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BORDER", (long) 0x1005, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DONT_CARE", (long) 0x1100, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FASTEST", (long) 0x1101, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NICEST", (long) 0x1102, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT0", (long) 0x4000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT1", (long) 0x4001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT2", (long) 0x4002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT3", (long) 0x4003, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT4", (long) 0x4004, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT5", (long) 0x4005, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT6", (long) 0x4006, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LIGHT7", (long) 0x4007, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AMBIENT", (long) 0x1200, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DIFFUSE", (long) 0x1201, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SPECULAR", (long) 0x1202, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POSITION", (long) 0x1203, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SPOT_DIRECTION", (long) 0x1204, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SPOT_EXPONENT", (long) 0x1205, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SPOT_CUTOFF", (long) 0x1206, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CONSTANT_ATTENUATION", (long) 0x1207, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINEAR_ATTENUATION", (long) 0x1208, 0, 0, 0},
    { SWIG_PY_INT,     "GL_QUADRATIC_ATTENUATION", (long) 0x1209, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COMPILE", (long) 0x1300, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COMPILE_AND_EXECUTE", (long) 0x1301, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLEAR", (long) 0x1500, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AND", (long) 0x1501, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AND_REVERSE", (long) 0x1502, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COPY", (long) 0x1503, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AND_INVERTED", (long) 0x1504, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NOOP", (long) 0x1505, 0, 0, 0},
    { SWIG_PY_INT,     "GL_XOR", (long) 0x1506, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OR", (long) 0x1507, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NOR", (long) 0x1508, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EQUIV", (long) 0x1509, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INVERT", (long) 0x150A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OR_REVERSE", (long) 0x150B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COPY_INVERTED", (long) 0x150C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OR_INVERTED", (long) 0x150D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NAND", (long) 0x150E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SET", (long) 0x150F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EMISSION", (long) 0x1600, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SHININESS", (long) 0x1601, 0, 0, 0},
    { SWIG_PY_INT,     "GL_AMBIENT_AND_DIFFUSE", (long) 0x1602, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_INDEXES", (long) 0x1603, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MODELVIEW", (long) 0x1700, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PROJECTION", (long) 0x1701, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE", (long) 0x1702, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR", (long) 0x1800, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH", (long) 0x1801, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL", (long) 0x1802, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_INDEX", (long) 0x1900, 0, 0, 0},
    { SWIG_PY_INT,     "GL_STENCIL_INDEX", (long) 0x1901, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DEPTH_COMPONENT", (long) 0x1902, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RED", (long) 0x1903, 0, 0, 0},
    { SWIG_PY_INT,     "GL_GREEN", (long) 0x1904, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BLUE", (long) 0x1905, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA", (long) 0x1906, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB", (long) 0x1907, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA", (long) 0x1908, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE", (long) 0x1909, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE_ALPHA", (long) 0x190A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_BITMAP", (long) 0x1A00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POINT", (long) 0x1B00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINE", (long) 0x1B01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FILL", (long) 0x1B02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RENDER", (long) 0x1C00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FEEDBACK", (long) 0x1C01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SELECT", (long) 0x1C02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_FLAT", (long) 0x1D00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SMOOTH", (long) 0x1D01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_KEEP", (long) 0x1E00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_REPLACE", (long) 0x1E01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INCR", (long) 0x1E02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DECR", (long) 0x1E03, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VENDOR", (long) 0x1F00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RENDERER", (long) 0x1F01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERSION", (long) 0x1F02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EXTENSIONS", (long) 0x1F03, 0, 0, 0},
    { SWIG_PY_INT,     "GL_S", (long) 0x2000, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T", (long) 0x2001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_R", (long) 0x2002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_Q", (long) 0x2003, 0, 0, 0},
    { SWIG_PY_INT,     "GL_MODULATE", (long) 0x2100, 0, 0, 0},
    { SWIG_PY_INT,     "GL_DECAL", (long) 0x2101, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_ENV_MODE", (long) 0x2200, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_ENV_COLOR", (long) 0x2201, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_ENV", (long) 0x2300, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EYE_LINEAR", (long) 0x2400, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OBJECT_LINEAR", (long) 0x2401, 0, 0, 0},
    { SWIG_PY_INT,     "GL_SPHERE_MAP", (long) 0x2402, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GEN_MODE", (long) 0x2500, 0, 0, 0},
    { SWIG_PY_INT,     "GL_OBJECT_PLANE", (long) 0x2501, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EYE_PLANE", (long) 0x2502, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NEAREST", (long) 0x2600, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINEAR", (long) 0x2601, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NEAREST_MIPMAP_NEAREST", (long) 0x2700, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINEAR_MIPMAP_NEAREST", (long) 0x2701, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NEAREST_MIPMAP_LINEAR", (long) 0x2702, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LINEAR_MIPMAP_LINEAR", (long) 0x2703, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_MAG_FILTER", (long) 0x2800, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_MIN_FILTER", (long) 0x2801, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_WRAP_S", (long) 0x2802, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_WRAP_T", (long) 0x2803, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLAMP", (long) 0x2900, 0, 0, 0},
    { SWIG_PY_INT,     "GL_REPEAT", (long) 0x2901, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIENT_PIXEL_STORE_BIT", (long) 0x00000001, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIENT_VERTEX_ARRAY_BIT", (long) 0x00000002, 0, 0, 0},
    { SWIG_PY_INT,     "GL_CLIENT_ALL_ATTRIB_BITS", (long) 0xffffffff, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_OFFSET_FACTOR", (long) 0x8038, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_OFFSET_UNITS", (long) 0x2A00, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_OFFSET_POINT", (long) 0x2A01, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_OFFSET_LINE", (long) 0x2A02, 0, 0, 0},
    { SWIG_PY_INT,     "GL_POLYGON_OFFSET_FILL", (long) 0x8037, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA4", (long) 0x803B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA8", (long) 0x803C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA12", (long) 0x803D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_ALPHA16", (long) 0x803E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE4", (long) 0x803F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE8", (long) 0x8040, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE12", (long) 0x8041, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE16", (long) 0x8042, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE4_ALPHA4", (long) 0x8043, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE6_ALPHA2", (long) 0x8044, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE8_ALPHA8", (long) 0x8045, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE12_ALPHA4", (long) 0x8046, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE12_ALPHA12", (long) 0x8047, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LUMINANCE16_ALPHA16", (long) 0x8048, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INTENSITY", (long) 0x8049, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INTENSITY4", (long) 0x804A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INTENSITY8", (long) 0x804B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INTENSITY12", (long) 0x804C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INTENSITY16", (long) 0x804D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_R3_G3_B2", (long) 0x2A10, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB4", (long) 0x804F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB5", (long) 0x8050, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB8", (long) 0x8051, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB10", (long) 0x8052, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB12", (long) 0x8053, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB16", (long) 0x8054, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA2", (long) 0x8055, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA4", (long) 0x8056, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB5_A1", (long) 0x8057, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA8", (long) 0x8058, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGB10_A2", (long) 0x8059, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA12", (long) 0x805A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_RGBA16", (long) 0x805B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_RED_SIZE", (long) 0x805C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_GREEN_SIZE", (long) 0x805D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BLUE_SIZE", (long) 0x805E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_ALPHA_SIZE", (long) 0x805F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_LUMINANCE_SIZE", (long) 0x8060, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_INTENSITY_SIZE", (long) 0x8061, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PROXY_TEXTURE_1D", (long) 0x8063, 0, 0, 0},
    { SWIG_PY_INT,     "GL_PROXY_TEXTURE_2D", (long) 0x8064, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_PRIORITY", (long) 0x8066, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_RESIDENT", (long) 0x8067, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BINDING_1D", (long) 0x8068, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_BINDING_2D", (long) 0x8069, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERTEX_ARRAY", (long) 0x8074, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NORMAL_ARRAY", (long) 0x8075, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_ARRAY", (long) 0x8076, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_ARRAY", (long) 0x8077, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COORD_ARRAY", (long) 0x8078, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EDGE_FLAG_ARRAY", (long) 0x8079, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERTEX_ARRAY_SIZE", (long) 0x807A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERTEX_ARRAY_TYPE", (long) 0x807B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERTEX_ARRAY_STRIDE", (long) 0x807C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NORMAL_ARRAY_TYPE", (long) 0x807E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NORMAL_ARRAY_STRIDE", (long) 0x807F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_ARRAY_SIZE", (long) 0x8081, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_ARRAY_TYPE", (long) 0x8082, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_ARRAY_STRIDE", (long) 0x8083, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_ARRAY_TYPE", (long) 0x8085, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_ARRAY_STRIDE", (long) 0x8086, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COORD_ARRAY_SIZE", (long) 0x8088, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COORD_ARRAY_TYPE", (long) 0x8089, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COORD_ARRAY_STRIDE", (long) 0x808A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EDGE_FLAG_ARRAY_STRIDE", (long) 0x808C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_VERTEX_ARRAY_POINTER", (long) 0x808E, 0, 0, 0},
    { SWIG_PY_INT,     "GL_NORMAL_ARRAY_POINTER", (long) 0x808F, 0, 0, 0},
    { SWIG_PY_INT,     "GL_COLOR_ARRAY_POINTER", (long) 0x8090, 0, 0, 0},
    { SWIG_PY_INT,     "GL_INDEX_ARRAY_POINTER", (long) 0x8091, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COORD_ARRAY_POINTER", (long) 0x8092, 0, 0, 0},
    { SWIG_PY_INT,     "GL_EDGE_FLAG_ARRAY_POINTER", (long) 0x8093, 0, 0, 0},
    { SWIG_PY_INT,     "GL_V2F", (long) 0x2A20, 0, 0, 0},
    { SWIG_PY_INT,     "GL_V3F", (long) 0x2A21, 0, 0, 0},
    { SWIG_PY_INT,     "GL_C4UB_V2F", (long) 0x2A22, 0, 0, 0},
    { SWIG_PY_INT,     "GL_C4UB_V3F", (long) 0x2A23, 0, 0, 0},
    { SWIG_PY_INT,     "GL_C3F_V3F", (long) 0x2A24, 0, 0, 0},
    { SWIG_PY_INT,     "GL_N3F_V3F", (long) 0x2A25, 0, 0, 0},
    { SWIG_PY_INT,     "GL_C4F_N3F_V3F", (long) 0x2A26, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T2F_V3F", (long) 0x2A27, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T4F_V4F", (long) 0x2A28, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T2F_C4UB_V3F", (long) 0x2A29, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T2F_C3F_V3F", (long) 0x2A2A, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T2F_N3F_V3F", (long) 0x2A2B, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T2F_C4F_N3F_V3F", (long) 0x2A2C, 0, 0, 0},
    { SWIG_PY_INT,     "GL_T4F_C4F_N3F_V4F", (long) 0x2A2D, 0, 0, 0},
    { SWIG_PY_INT,     "GL_LOGIC_OP", (long) 0x0BF1, 0, 0, 0},
    { SWIG_PY_INT,     "GL_TEXTURE_COMPONENTS", (long) 0x1003, 0, 0, 0},
{0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) init__init___(void) {
    PyObject *m, *d;
    int i;
    SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule("__init___", __init___Methods);
    d = PyModule_GetDict(m);
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
    }
    
    #ifdef NUMERIC
    PyArray_API = NULL;
    import_array();
    init_util();
    PyErr_Clear();
    #endif
    
    GLerror = PyErr_NewException("OpenGL.GL.GLerror", PyExc_EnvironmentError, NULL);
    GLUerror = PyErr_NewException("OpenGL.GLU.GLUerror", PyExc_EnvironmentError, NULL);
    #if HAS_DYNAMIC_EXT
    ProcAddresses = PyDict_New();
    PyDict_SetItemString(d, "proc", ProcAddresses);
    #endif
    #ifndef GL_VERSION_1_1
    contexts = PyDict_New();
    #endif
    _util_API._decrement = decrementLock;
    _util_API._decrementPointer = decrementPointerLock;
    _util_API._incrementLock = incrementLock;
    _util_API._incrementPointerLock = incrementPointerLock;
    _util_API._acquire = acquire;
    _util_API._acquirePointer = acquirePointer;
    _util_API.InitExtension = InitExtension;
    #if HAS_DYNAMIC_EXT
    _util_API.GL_GetProcAddress = GL_GetProcAddress;
    #endif
    _util_API._GLerror = GLerror;
    _util_API._GLUerror = GLUerror;
    PyDict_SetItemString(d, "_util_API", PyCObject_FromVoidPtr((void*)&_util_API, NULL));
    #ifdef NUMERIC
    PyDict_SetItemString(d, "__numeric_support__", PyInt_FromLong(1));
    PyDict_SetItemString(d, "__numeric_present__", PyInt_FromLong((PyArray_API) ? 1 : 0));
    #else
    PyDict_SetItemString(d, "__numeric_support__", PyInt_FromLong(0));
    PyDict_SetItemString(d, "__numeric_present__", PyInt_FromLong(0));
    #endif
    
    PyDict_SetItemString(d, "GLerror", GLerror);
    SWIG_InstallConstants(d,swig_const_table);
}

