/**********  Simple input values **********/
%typemap(python, in) GLbyte, GLubyte, GLshort
{
	if (PyInt_Check($source) || PyLong_Check($source))
	{
		$target = ($type)(PyInt_AsLong( PyNumber_Int($source)));
	}
	else if (PyString_Check ($source))
	{
		/* what is a GLshort's size? */
		$target = ($type) PyString_AsString($source)[0];
	}
}

%typemap(python, in) GLboolean
{
	$target = (PyObject_IsTrue($source)) ? GL_TRUE : GL_FALSE;
}


%typemap(python, out) const GLubyte*
{
	if ($source) $target = PyString_FromString($source); else Py_INCREF($target = Py_None);
}


%typemap(python, in) const void *buffer
{
	int len;
	PyObject* str;
	if ($source == Py_None) $target = NULL; else
	{
		str = PyObject_Str($source);
		PyString_AsStringAndSize(str, (char**)&$target, &len);
		Py_DECREF(str);
	}
}


%typemap(python, out) const wchar_t*
{
	if ($source) $target = PyUnicode_FromWideChar($source, wcslen($source)); else Py_INCREF($target = Py_None);
}


%typemap(python,in) PyObject*, void*
{
	$target = $source;
}

%typemap(python,out) PyObject*, void*
{
	$target = $source;
}

%typemap(python,in) PyObject* pyfunc
{
	if ($source != Py_None && !PyCallable_Check($source))
	{
		PyErr_SetString(PyExc_Exception, "Not callable.");
		return NULL;
	}
	$target = $source;
}


%typemap(python,ignore) GLenum type_UNSIGNED_BYTE
{
	$target = GL_UNSIGNED_BYTE;
}

%typemap(python,ignore) GLenum type_BYTE
{
	$target = GL_BYTE;
}

%typemap(python,ignore) GLenum type_UNSIGNED_SHORT
{
	$target = GL_UNSIGNED_SHORT;
}

%typemap(python,ignore) GLenum type_SHORT
{
	$target = GL_SHORT;
}

%typemap(python,ignore) GLenum type_UNSIGNED_INT
{
	$target = GL_UNSIGNED_INT;
}

%typemap(python,ignore) GLenum type_INT
{
	$target = GL_INT;
}

%typemap(python,ignore) GLenum type_FLOAT
{
	$target = GL_FLOAT;
}

%typemap(python,ignore) GLenum type_DOUBLE
{
	$target = GL_DOUBLE;
}

%typemap(python,ignore) GLsizei stride_0, GLint stride_0, GLint ustride_0, GLint vstride_0
{
	$target = 0;
}

